/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.dialogs.HelpCloseDialog;
import rene.zirkel.objects.ConstructionObject;

public class DefineMacro
extends HelpCloseDialog {
    TextField Name;
    TextField PromptFor;
    TextArea Comment;
    ZirkelCanvas ZC;
    Vector V;
    boolean Aborted = true;
    Checkbox TargetsOnly;
    Checkbox Invisible;
    Checkbox HideDuplicates;

    public DefineMacro(Frame frame, ZirkelCanvas zirkelCanvas) {
        super(frame, Zirkel.name("definemacro.title"), true);
        Component component;
        Object object;
        this.ZC = zirkelCanvas;
        this.setLayout(new BorderLayout());
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new GridLayout(0, 2));
        myPanel.add(new MyLabel(Zirkel.name("definemacro.name")));
        this.Name = new TextFieldAction((DoActionListener)this, "", 20);
        myPanel.add(this.Name);
        this.add("North", new Panel3D(myPanel));
        MyPanel myPanel2 = new MyPanel();
        myPanel2.setLayout(new BorderLayout());
        myPanel2.add("North", new MyLabel(Zirkel.name("definemacro.comment")));
        this.Comment = new TextArea("", 5, 40, 1);
        myPanel2.add("Center", this.Comment);
        if (Global.Background != null) {
            this.Comment.setBackground(Global.Background);
        }
        MyPanel myPanel3 = new MyPanel();
        myPanel3.setLayout(new GridLayout(0, 1));
        myPanel3.add(new MyLabel(Zirkel.name("definemacro.parameters")));
        Enumeration enumeration = this.ZC.getConstruction().getParameters().elements();
        this.V = new Vector();
        while (enumeration.hasMoreElements()) {
            object = (ConstructionObject)enumeration.nextElement();
            component = new TextFieldAction((DoActionListener)this, "", ((ConstructionObject)object).getName());
            this.V.addElement(component);
            myPanel3.add(component);
        }
        if (zirkelCanvas.getConstruction().countTargets() > 0) {
            object = new MyPanel();
            ((Container)object).setLayout(new GridLayout(1, 0));
            ((Container)object).add(new MyLabel(Zirkel.name("definemacro.targetsonly")));
            this.TargetsOnly = new CheckboxAction(this, "", "TargetsOnly");
            this.TargetsOnly.setState(true);
            ((Container)object).add(this.TargetsOnly);
            myPanel3.add((Component)object);
            object = new MyPanel();
            ((Container)object).setLayout(new GridLayout(1, 0));
            ((Container)object).add(new MyLabel(Zirkel.name("definemacro.invisible")));
            this.Invisible = new CheckboxAction(this, "", "Invisible");
            this.Invisible.setState(false);
            ((Container)object).add(this.Invisible);
            myPanel3.add((Component)object);
        }
        object = new MyPanel();
        ((Container)object).setLayout(new GridLayout(1, 0));
        ((Container)object).add(new MyLabel(Zirkel.name("menu.options.hideduplicates")));
        this.HideDuplicates = new CheckboxAction(this, "", "HideDuplicates");
        this.HideDuplicates.setState(true);
        ((Container)object).add(this.HideDuplicates);
        myPanel3.add((Component)object);
        component = new MyPanel();
        ((Container)component).setLayout(new GridLayout(1, 0));
        ((Container)component).add(new MyLabel(Zirkel.name("definemacro.promptfor")));
        this.PromptFor = new TextFieldAction((DoActionListener)this, "", "");
        ((Container)component).add(this.PromptFor);
        myPanel3.add(component);
        myPanel2.add("South", myPanel3);
        this.add("Center", new Panel3D(myPanel2));
        MyPanel myPanel4 = new MyPanel();
        myPanel4.add(new ButtonAction(this, Zirkel.name("ok"), "OK"));
        myPanel4.add(new ButtonAction(this, Zirkel.name("abort"), "Close"));
        this.addHelp(myPanel4, "macro");
        this.add("South", new Panel3D(myPanel4));
        this.center(frame);
        this.pack();
    }

    public void doAction(String string) {
        if (string.equals("OK")) {
            this.Aborted = false;
            this.doclose();
        } else {
            super.doAction(string);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.Name.requestFocus();
    }

    public boolean isAborted() {
        return this.Aborted;
    }

    public String[] getParams() {
        String[] stringArray = new String[this.V.size()];
        for (int i = 0; i < this.V.size(); ++i) {
            stringArray[i] = ((TextField)this.V.elementAt(i)).getText();
        }
        return stringArray;
    }

    public String getName() {
        return this.Name.getText();
    }

    public String getComment() {
        return this.Comment.getText();
    }

    public boolean targetsOnly() {
        if (this.TargetsOnly == null) {
            return false;
        }
        return this.TargetsOnly.getState();
    }

    public boolean invisible() {
        if (this.Invisible == null) {
            return false;
        }
        return this.Invisible.getState();
    }

    public boolean hideduplicates() {
        return this.HideDuplicates.getState();
    }

    public String[] getPromptFor() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.PromptFor.getText(), ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }
}

