//
// $Id$
//
//
// Original author: Matt Chambers <matt.chambers <a.t> vanderbilt.edu>
//
// Copyright 2008 Spielberg Family Center for Applied Proteomics
//   Cedars-Sinai Medical Center, Los Angeles, California  90048
//
// Licensed under the Apache License, Version 2.0 (the "License"); 
// you may not use this file except in compliance with the License. 
// You may obtain a copy of the License at 
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software 
// distributed under the License is distributed on an "AS IS" BASIS, 
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
// See the License for the specific language governing permissions and 
// limitations under the License.
//


#include "SavitzkyGolaySmoother.hpp"
#include "pwiz/utility/misc/unit.hpp"
#include "pwiz/utility/misc/Std.hpp"

using namespace pwiz::util;
using namespace pwiz::analysis;


ostream* os_ = 0;


struct TestData
{
    int polynomialOrder, windowSize;
    const char* xRaw;
    const char* yRaw;
    const char* xSmoothed;
    const char* ySmoothed;
};

const TestData testData[] =
{
    /*{
     2, 7,
     "1 2 3 4 5 6 7 8  9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34  35 36 37 38 39 40 41 42 43 44 45 46",
     "0 0 0 0 0 0 0 5 10 20 40 20 10 5  0  0  0  0  3  4  10 9  7  3  0  0  0  0  0  0  10 30 60 100 80 20 5  0  0  0  0  0  0  0  0  0",
     "4.611696e-16  6.422213e-15  3.142785e-15  2.869500e-15 -4.761905e-01 -2.380952e-01  9.523810e-01  3.571429e+00  1.428571e+01 2.357143e+01  2.666667e+01  2.357143e+01  1.428571e+01  3.571429e+00  9.523810e-01 -5.238095e-01 -4.285714e-01  4.761905e-01 2.714286e+00  5.666667e+00  8.190476e+00  8.571429e+00  6.809524e+00  3.333333e+00  1.000000e+00 -2.380952e-01 -2.857143e-01 -9.523810e-01 -1.428571e+00  1.428571e+00  1.095238e+01  3.666667e+01  6.809524e+01  7.904762e+01  6.738095e+01  3.952381e+01 9.285714e+00 -3.333333e+00 -1.190476e+00 -4.761905e-01 -1.366428e-16 -6.832142e-16 -2.391250e-16  4.577535e-15  6.832142e-15 2.186285e-15"
    },

    {
     2, 7,
     "7 8  9 10 11 12 13 14 15 18 19 20 21 22 23 24 25 30 31 32 33 34  35 36 37 38",
     "0 5 10 20 40 20 10 5  0  0  3  4  10 9  7  3  0  0  10 30 60 100 80 20 5  0",
     "7 8  9 10 11 12 13 14 15 18 19 20 21 22 23 24 25 30 31 32 33 34  35 36 37 38"
    },*/

    {
     2, 11,
     "300.000066203793 300.000611626572 300.001157051333 300.001702478078 300.058437690186 300.058983325233 300.059528962264 300.06007460128 300.06062024228 300.061165885264 300.061711530233 300.062257177186 300.062802826123 300.063348477046 300.063894129952 300.064439784843 300.064985441719 300.065531100579 300.066076761424 301.055887660805 301.056436929468 301.056986200136 301.057535472809 301.058084747485 301.058634024166 301.059183302851 301.059732583541 301.060281866235 301.060831150933 301.061380437635 301.061929726342 301.062479017053 301.063028309769 301.063577604489 311.869088211176 311.869677645283 311.870267081618 311.870856520182 311.871445960974 311.872035403993 311.872624849241 311.873214296717 311.873803746421 311.874393198353 311.874982652514 311.875572108902 311.876161567519 311.876751028364 311.877340491437 311.877929956739 311.878519424268 311.879108894026 311.879698366013 311.880287840227 311.88087731667 311.881466795341 311.882056276241 315.73174362051 315.732347745926 315.732951873654 315.733556003694 315.734160136047 315.734764270711 315.735368407687 315.735972546974 315.736576688574 315.737180832486 315.73778497871 315.738389127246 316.901416544052 316.902025153901 316.902633766087 316.90324238061 316.903850997471 316.90445961667 316.905068238207 316.905676862081 316.906285488293 316.906894116843 316.907502747731 316.908111380957 316.90872001652 316.909328654421 326.293591849569 326.294237069432 326.294882291847 326.295527516814 326.296172744332 326.296817974402 326.297463207024 326.298108442198 326.298753679923 326.299398920201 326.30004416303 327.074882186811 327.075530500256 327.076178816272 327.076827134858 327.077475456014 327.07812377974 327.078772106036 327.079420434903 327.080068766339 327.080717100346 327.081365436923 327.082013776071 327.082662117789 327.083310462077 327.083958808935 341.007109159311 341.007813880848 341.008518605298 341.00922333266 341.009928062936 341.010632796124 341.011337532225 341.012042271238 341.012747013165 "
    "341.013451758004 341.014156505757 341.014861256422 341.01556601 341.016270766491 341.016975525895 341.017680288212 341.018385053442 341.019089821585 341.019794592642 341.020499366611 341.021204143493 341.021908923288 341.022613705997 341.023318491618 341.024023280153 341.024728071601 342.01359244987 342.014301337525 342.015010228119 342.015719121651 342.016428018122 342.017136917532 342.01784581988 342.018554725167 342.019263633392 342.019972544557 342.02068145866 342.021390375702 342.022099295682 342.022808218602 342.02351714446 342.873501341248 342.874213798035 342.874926257782 342.87563872049 342.876351186159 342.877063654789 342.87777612638 342.878488600932 342.879201078445 342.879913558918 342.880626042353 342.881338528749 344.97306118134 344.9737823902 344.974503602076 344.975224816967 344.975946034874 344.976667255797 344.977388479735 344.978109706689 344.978830936658 344.979552169644 344.980273405644 344.980994644661 344.981715886693 355.063935356091 355.064699374529 355.065463396255 355.066227421269 355.066991449572 355.067755481162 355.06851951604 355.069283554207 355.070047595661 355.070811640404 355.071575688435 355.072339739754 355.073103794361 355.073867852257 355.074631913441 355.075395977913 355.076160045673 355.076924116722 355.077688191059 355.078452268685 356.064553240471 356.065321571195 356.066089905234 356.06685824259 356.067626583261 356.068394927249 356.069163274552 356.069931625172 356.070699979107 356.071468336359 356.072236696926 356.07300506081 356.073773428009 356.074541798525 356.075310172357 356.076078549505 356.076846929969 356.07761531375 356.078383700846 356.079152091259 356.079920484988 356.080688882034 357.062327559534 357.063100202372 357.063872848555 357.064645498081 357.065418150951 357.066190807165 357.066963466723 357.067736129625 357.068508795871 357.069281465461 357.070054138395 357.070826814673 357.071599494295 357.072372177261 357.073144863571 357.073917553225 357.074690246224 357.075462942566 357.076235642253 "
    "357.077008345284 357.077781051659 357.078553761379 357.079326474442 357.08009919085 359.023183355092 359.023964507385 359.024745663078 359.02552682217 359.026307984661 359.027089150551 359.027870319841 359.028651492531 359.029432668619 359.030213848107 359.030995030994 359.031776217281 359.032557406967 359.033338600053 359.034119796538 359.034900996422 359.035682199706 360.023491974674 360.024277485921 360.025063000597 360.0258485187 360.02663404023 360.027419565189 360.028205093575 360.028990625389 360.029776160632 360.030561699301 360.031347241399 360.032132786925 360.032918335879 360.03370388826 360.03448944407 361.021491400285 361.02228127251 361.023071148191 361.023861027329 361.024650909923 361.025440795974 361.026230685481 361.027020578444 361.027810474864 361.02860037474 361.029390278072 361.030180184861 361.030970095107 361.031760008809 371.095690561049 371.096525130684 371.097359704072 371.098194281215 371.099028862111 371.099863446762 371.100698035166 371.101532627324 371.102367223236 371.103201822902 371.104036426322 371.104871033497 371.105705644425 371.106540259107 371.107374877543 371.108209499734 371.109044125678 371.109878755377 371.11071338883 372.078066820464 372.078905814551 372.079744812421 372.080583814075 372.081422819513 372.082261828735 372.083100841741 372.08393985853 372.084778879103 372.08561790346 372.086456931601 372.087295963526 372.095686490895 372.096525564444 372.097364641778 372.098203722896 372.099042807799 372.099881896485 372.100720988956 372.101560085211 372.102399185251 372.103238289075 372.104077396683 372.104916508076 372.105755623254 372.106594742216 372.107433864962 372.108272991493 373.076623237254 373.077466740653 373.078310247866 373.079153758894 373.079997273735 373.080840792391 373.081684314862 373.082527841147 373.083371371246 373.084214905159 373.085058442887 373.08590198443 373.086745529787 373.101086384495 373.101929998517 373.102773616354 373.103617238007 373.104460863474 373.105304492756 373.106148125853 "
    "373.106991762765 373.107835403493 373.108679048035 373.109522696393 373.110366348566 373.111210004555 415.030543316388 415.031587197383 415.032631083628 415.033674975125 415.034718871873 415.035762773872 415.036806681123 415.037850593625 415.038894511378 415.039938434383 415.040982362639 415.042026296147 415.043070234906 415.044114178917 415.045158128179 415.046202082693 415.047246042459 416.004675140758 416.005723927765 416.006772720059 416.007821517642 416.008870320513 416.009919128672 416.01096794212 416.012016760856 416.01306558488 416.014114414193 416.015163248794 416.016212088684 416.030896402465 416.031945321688 416.032994246201 416.034043176002 416.035092111093 416.036141051473 416.037189997143 416.038238948102 416.03928790435 416.040336865888 416.041385832715 416.042434804832 416.043483782239 416.044532764935 416.04558175292 416.046630746196 416.047679744761 417.027651705639 417.028705657034 417.029759613757 417.030813575807 417.031867543184 417.032921515889 417.033975493922 417.035029477282 417.036083465969 417.037137459984 417.038191459327 417.039245463997 417.040299473995 417.041353489321 426.357976566382 426.359078206359 426.360179852029 426.361281503392 426.362383160449 426.363484823198 426.36458649164 426.365688165776 426.366789845604 426.367891531126 426.368993222341 428.935877697296 428.936992699323 428.938107707146 428.939222720767 428.940337740184 428.941452765398 428.94256779641 428.943682833218 428.944797875823 428.945912924226 428.947027978426 429.083108101101 429.0842238687 429.085339642101 429.086455421305 429.087571206312 429.088686997122 429.089802793735 429.090918596151 429.09203440437 429.093150218392 429.094266038217 429.095381863845 429.096497695277 429.097613532512 429.09872937555 429.099845224392 429.100961079037 429.102076939486 429.134439417209 429.135555451783 429.136671492162 429.137787538345 429.138903590334 429.140019648128 429.141135711726 429.14225178113 429.143367856339 429.144483937353 429.145600024173 429.146716116797 "
    "429.85101025753 429.852130022341 429.853249792985 429.854369569464 429.855489351777 429.856609139924 429.857728933905 429.858848733721 429.859968539371 429.861088350855 429.862208168173 429.863327991326 429.864447820313 429.865567655135 429.866687495792 429.867807342283 429.868927194608 429.870047052768 429.871166916764 429.872286786593 429.873406662258 429.874526543758 429.875646431092 429.876766324261 429.877886223266 430.081805059062 430.082926026641 430.084047000064 430.08516797933 430.086288964439 430.087409955392 430.088530952189 430.089651954829 430.090772963313 430.091893977641 430.093014997813 430.094136023828 430.095257055687 430.09637809339 430.097499136937 430.098620186328 430.099741241563 430.100862302643 430.101983369566 431.078404724764 431.079530893455 431.08065706803 431.081783248489 431.082909434832 431.08403562706 431.085161825172 431.086288029168 431.087414239049 431.088540454814 431.089666676463 431.090792903997 431.091919137416 431.093045376719 431.094171621907 431.09529787298 431.096424129938 431.09755039278 431.098676661507 431.099802936119 432.079633824813 432.080765230898 432.081896642908 432.083028060844 432.084159484704 432.085290914491 432.086422350202 432.087553791839 432.088685239402 432.08981669289 432.090948152304 432.092079617643 432.093211088908 444.61606065115 444.617258663358 444.618456682022 444.619654707142 444.620852738719 444.622050776751 444.62324882124 444.624446872186 444.625644929587 444.626842993445 444.62804106376 444.629239140531 444.630437223759 445.111389571898 445.112590254911 445.113790944402 445.114991640371 445.116192342817 445.117393051741 445.118593767143 445.119794489023 445.120995217382 445.122195952218 445.123396693532 445.124597441324 445.125798195595 445.126998956343 445.128199723571 445.129400497276 445.13060127746 446.092099627601 446.093305607359 446.094511593638 446.095717586437 446.096923585757 446.098129591598 446.099335603959 446.100541622841 446.101747648245 446.102953680169 446.104159718614 "
    "446.10536576358 446.106571815068 446.107777873076 446.108983937606 446.110190008657 446.111396086229 446.112602170323 446.113808260938 446.115014358075 446.116220461733 446.117426571913 446.118632688614 446.119838811837 446.121044941582 446.122251077849 446.123457220638 446.124663369948 446.12586952578 446.127075688135 446.128281857011 446.12948803241 446.130694214331 446.131900402774 446.133106597739 447.092888369096 447.09409976606 447.095311169589 447.096522579682 447.09773399634 447.098945419563 447.100156849351 447.101368285703 447.10257972862 447.103791178103 447.10500263415 447.106214096762 447.10742556594 447.108637041682 447.10984852399 447.111060012863 447.112271508302 447.113483010306 447.114694518875 447.115906034009 447.11711755571 447.118329083975 447.119540618807 447.120752160204 447.121963708167 447.123175262696 447.12438682379 447.125598391451 447.126809965677 447.128021546469 447.129233133828 447.130444727752 447.131656328243 449.794778250235 449.796004332987 449.797230422424 449.798456518544 449.799682621349 449.800908730839 449.802134847013 449.803360969872 449.804587099415 449.805813235643 449.807039378556 449.808265528153 476.291926493584 476.293301287096 476.294676088545 476.296050897931 476.297425715253 476.298800540512 476.300175373707 476.30155021484 476.30292506391 476.304299920917 476.305674785861 476.307049658742 487.815419569054 487.81686169142 487.818303822312 487.819745961732 487.821188109678 487.822630266151 487.824072431152 487.825514604679 487.826956786733 487.828398977315 487.829841176424 489.047206755368 489.048656169973 489.050105593169 489.051555024957 489.053004465336 489.054453914307 489.05590337187 489.057352838025 489.058802312771 489.06025179611 489.06170128804 489.063150788563 489.064600297678 489.066049815385 489.067499341685 494.497639238354 494.499121140501 494.500603051529 494.50208497144 494.503566900233 494.505048837908 494.506530784465 494.508012739904 494.509494704226 494.510976677431 494.512458659517 "
    "503.097384350016 503.098918243574 503.100452146485 503.10198605875 503.103519980368 503.10505391134 503.106587851665 503.108121801345 503.109655760378 503.111189728765 503.112723706507 503.114257693603 503.115791690052 503.117325695857 503.118859711015 503.120393735528 503.121927769396 503.123461812619 503.124995865196 504.057895208494 504.059434964655 504.060974730222 504.062514505197 504.064054289579 504.065594083369 504.067133886566 504.06867369917 504.070213521182 504.071753352602 504.073293193429 504.097931926196 504.099471926969 504.101011937151 504.102551956742 504.104091985743 504.105632024154 504.107172071974 504.108712129204 504.110252195844 504.111792271893 504.113332357353 504.114872452223 504.116412556503 504.117952670193 504.119492793294 504.121032925805 504.122573067726 504.124113219059 504.136434768509 504.137975004541 504.139515249984 504.141055504838 504.142595769105 504.144136042783 504.145676325873 504.147216618374 504.148756920288 504.150297231614 504.151837552352 504.153377882502 505.094736580555 505.096282677762 505.097828784435 505.099374900573 505.100921026176 505.102467161245 505.104013305779 505.105559459779 505.107105623245 505.108651796177 505.110197978574 505.111744170438 505.113290371768 505.114836582564 505.116382802826 505.117929032555 505.11947527175 505.121021520412 505.12256777854 506.095491214212 506.097043444127 506.098595683563 506.100147932522 506.101700191001 506.103252459003 506.104804736527 506.106357023573 506.107909320141 506.109461626231 506.111013941844 506.112566266978 506.114118601636 517.627784100423 517.62940787711 517.631031663984 517.632655461045 517.634279268294 517.635903085731 517.637526913356 517.639150751169 517.64077459917 517.642398457359 517.644022325736 519.117811946194 519.11944508466 519.121078233402 519.122711392419 519.124344561713 519.125977741282 519.127610931128 519.129244131249 519.130877341647 519.132510562322 519.134143793272 519.1357770345 519.137410286004 519.139043547785 519.140676819843 "
    "519.142310102177 519.143943394789 519.145576697678 519.147210010844 519.148843334287 519.150476668008 519.152110012007 519.153743366283 520.107741759837 520.109381132867 520.111020516231 520.11265990993 520.114299313963 520.115938728332 520.117578153035 520.119217588074 520.120857033448 520.122496489157 520.124135955201 520.125775431581 520.130693922735 520.132333440458 520.133972968517 520.135612506911 520.137252055643 520.13889161471 520.140531184113 520.142170763854 520.14381035393 520.145449954343 520.147089565093 520.14872918618 520.150368817604 520.152008459365 520.153648111463 520.155287773898 521.127785814089 521.129431623767 521.131077443839 521.132723274308 521.134369115172 521.136014966432 521.137660828088 521.13930670014 521.140952582588 521.142598475432 521.144244378673 521.14589029231 521.147536216343 531.114696350534 531.11640584546 531.118115351391 531.119824868327 531.121534396267 531.123243935212 531.124953485163 531.126663046119 531.12837261808 531.130082201046 531.131791795019 531.179664894929 531.181374808109 531.183084732298 531.184794667495 531.186504613701 531.188214570917 531.189924539141 531.191634518375 531.193344508618 531.195054509871 531.196764522133 531.198474545405 539.793121824335 539.79488764215 539.796653471517 539.798419312438 539.800185164913 539.80195102894 539.803716904521 539.805482791656 539.807248690344 539.809014600586 539.810780522383 544.657227988968 544.659025773986 544.660823570872 544.662621379626 544.664419200249 544.66621703274 544.6680148771 544.669812733329 544.671610601426 544.673408481392 544.675206373228 544.677004276933 544.678802192507 544.68060011995 544.682398059264 544.684196010447 544.685993973499 544.687791948422 544.689589935214 544.691387933877 564.063114662872 564.065042838848 564.066971028006 564.068899230347 564.07082744587 564.072755674577 564.074683916467 564.076612171539 564.078540439795 564.080468721235 564.082397015858 564.084325323664 564.086253644655 577.113045862246 577.115064289413 "
    "577.1170827307 577.119101186105 577.12111965563 577.123138139273 577.125156637036 577.127175148919 577.129193674921 577.131212215043 577.133230769285 577.135249337647 577.137267920129 577.139286516732 577.141305127455 577.143323752299 578.095668254573 578.09769356096 578.099718881538 578.101744216308 578.103769565269 578.105794928421 578.107820305765 578.1098456973 578.111871103028 578.113896522947 578.115921957059 578.117947405363 578.119972867859 578.121998344549 578.124023835431 578.126049340506 578.128074859774 578.130100393235 578.13212594089 578.134151502738 578.13617707878 578.138202669016 578.140228273445 578.142253892069 578.144279524888 578.1463051719 579.112127291178 579.114159725986 579.116192175059 579.118224638399 579.120257116005 579.122289607877 579.124322114016 579.126354634422 579.128387169095 579.130419718034 579.132452281241 579.134484858716 579.136517450457 579.138550056467 579.140582676744 579.142615311289 593.146836106552 593.148968246848 593.151100402472 593.153232573424 593.155364759706 593.157496961317 593.159629178256 593.161761410526 593.163893658125 593.166025921053 593.168158199311 593.1702904929 593.172422801818 593.174555126067 594.334675871054 594.336816559592 594.338957263551 594.341097982931 594.343238717732 594.345379467954 594.347520233598 594.349661014664 594.351801811151 594.35394262306 594.356083450392 594.358224293146 602.991717202929 602.993920708033 602.996124229242 602.998327766555 603.000531319973 603.002734889497 603.004938475125 603.007142076859 603.009345694699 603.011549328644 603.013752978696 603.015956644853 603.018160327117 603.020364025487 603.022567739964 603.024771470548 603.026975217238 647.653798614949 647.656340625328 647.65888265566 647.661424705948 647.66396677619 647.666508866388 647.669050976542 647.671593106651 647.674135256716 647.676677426738 647.679219616716 647.681761826651 647.684304056543 647.686846306392 647.689388576198 647.691930865962 647.694473175684 647.697015505364 647.699557855003 "
    "651.129472007141 651.132041374488 651.134610762114 651.137180170017 651.139749598198 651.142319046658 651.144888515396 651.147458004413 651.150027513709 651.152597043284 651.155166593139 651.157736163274 651.160305753689 651.162875364383 651.165444995359 651.168014646615 652.130488515969 652.133065789459 652.135643083321 652.138220397554 652.140797732159 652.143375087136 652.145952462485 652.148529858207 652.151107274301 652.153684710768 652.156262167609 652.158839644823 652.16141714241 652.163994660372 652.166572198708 652.169149757418 652.594726156514 652.597307100729 652.599888065358 652.602469050403 652.605050055862 652.607631081738 652.610212128029 652.612793194736 652.615374281859 652.617955389399 652.620536517356 653.126832071549 653.129417226335 653.132002401586 653.134587597302 653.137172813482 653.139758050129 653.142343307241 653.14492858482 653.147513882864 653.150099201375 653.152684540353 653.155269899798 653.157855279709 653.160440680089 653.163026100936 660.922514101737 660.925161337446 660.927808594361 660.930455872483 660.933103171812 660.935750492348 660.938397834091 660.941045197042 660.943692581201 660.946339986568 660.948987413144 660.951634860928 660.954282329921 660.983405888706 660.986053612226 660.988701356959 660.991349122903 660.993996910061 660.996644718431 660.999292548015 661.001940398812 661.004588270823 661.007236164048 661.009884078488 661.012532014142 664.411346114577 664.414021372197 664.41669665136 664.419371952069 664.422047274321 664.424722618119 664.427397983461 664.430073370349 664.432748778782 664.435424208761 664.438099660286 664.440775133357 664.443450627975 664.44612614414 664.448801681852 664.451477241112 664.454152821919 664.456828424273 664.459504048176 664.462179693628 664.464855360628 667.159443330433 667.162140764336 667.164838220052 667.16753569758 667.170233196922 667.172930718076 667.175628261044 667.178325825826 667.181023412421 667.183721020831 667.186418651055 667.189116303095 667.191813976949 "
    "667.194511672619 667.197209390104 667.199907129405 668.145457833561 668.148163246605 668.150868681559 668.153574138422 668.156279617196 668.158985117879 668.161690640472 668.164396184977 668.167101751392 668.169807339718 668.172512949956 668.175218582105 668.177924236166 668.180629912139 668.183335610025 668.186041329824 668.188747071536 668.19145283516 668.194158620699 668.196864428151 668.199570257517 670.158915513485 670.161637256666 670.164359021956 670.167080809353 670.16980261886 670.172524450475 670.175246304198 670.177968180032 670.180690077974 670.183411998027 670.186133940189 670.188855904462 670.191577890846 677.272020770102 677.274800597507 677.277580447732 677.280360320776 677.283140216641 677.285920135325 677.28870007683 677.291480041156 677.294260028303 677.297040038272 677.299820071062 677.302600126674 677.305380205108 677.308160306364 677.310940430444 677.313720577346 677.316500747072 677.319280939622 677.322061154995 677.324841393193 677.327621654214 677.330401938061 677.333182244733 677.33596257423 684.185792158615 684.188629030244 684.191465925398 684.194302844078 684.197139786283 684.199976752015 684.202813741274 684.205650754059 684.208487790372 684.211324850212 684.21416193358 684.216999040475 684.2198361709 684.222673324852 684.225510502334 685.302497766186 685.305343905889 685.308190069232 685.311036256217 685.313882466843 685.316728701111 685.319574959021 685.322421240572 685.325267545767 685.328113874604 685.330960227085 685.333806603209 685.336653002977 685.339499426388 685.345192344145 685.34803883849 685.350885356481 685.353731898117 685.356578463399 685.359425052328 685.362271664902 685.365118301123 685.367964960991 685.370811644507 685.37365835167 685.376505082481 686.165961086862 686.168814403222 686.171667743312 686.174521107133 686.177374494685 686.180227905968 686.183081340982 686.185934799728 686.188788282207 686.191641788417 686.19449531836 686.197348872036 699.464091765658 699.467056750447 699.470021760373 699.472986795436 "
    "699.475951855637 699.478916940975 699.481882051452 699.484847187067 699.487812347821 699.490777533714 699.493742744746 699.496707980919 699.499673242231 699.502638528684 699.505603840277 699.508569177012 699.511534538887 699.514499925905 707.540962759248 707.54399661424 707.54703049525 707.550064402278 707.553098335324 707.556132294389 707.559166279473 707.562200290576 707.565234327699 707.568268390842 707.571302480006 707.574336595191 707.577370736396 707.580404903623 707.583439096872 707.586473316143 707.589507561437 707.592541832753 707.595576130092 712.253358999635 712.256433401729 712.259507830364 712.26258228554 712.265656767258 712.268731275519 712.271805810321 712.274880371667 712.277954959555 712.281029573987 712.284104214963 714.637817537752 714.640912559113 714.644007607282 714.647102682261 714.650197784048 714.653292912646 714.656388068053 714.65948325027 714.662578459298 714.665673695137 714.668768957787 714.671864247249 725.142802571441 725.145989253758 725.149175964084 725.152362702418 725.155549468761 725.158736263113 725.161923085476 725.165109935848 725.168296814231 725.171483720624 725.174670655029 725.177857617445 725.181044607873 725.184231626314 725.187418672767 725.190605747233 725.193792849713 725.196979980206 726.144799061961 726.147994557046 726.151190080255 726.15438563159 726.15758121105 726.160776818635 726.163972454346 726.167168118184 726.170363810149 726.17355953024 726.176755278459 726.179951054806 726.183146859281 726.186342691885 726.189538552617 727.133547186777 727.136751390037 727.139955621536 727.143159881275 727.146364169255 727.149568485475 727.152772829936 727.155977202638 727.159181603583 727.162386032769 727.165590490198 727.16879497587 727.171999489785 727.175204031944 727.178408602347 727.181613200995 727.184817827887 727.188022483024 728.144269729676 728.147482846893 728.150695992466 728.153909166398 728.157122368687 728.160335599336 728.163548858343 728.16676214571 728.169975461436 728.173188805523 728.17640217797 "
    "728.179615578778 728.182829007947 728.623337067404 728.626554414027 728.629771789064 728.632989192515 728.63620662438 728.639424084659 728.642641573354 728.645859090464 728.64907663599 728.652294209931 728.65551181229 728.658729443065 739.579801260267 739.583116094462 739.586430958371 739.589745851995 739.593060775335 739.596375728391 739.599690711162 739.603005723651 739.606320765856 739.609635837779 739.61295093942 741.174345003278 741.177674146565 741.18100331976 741.184332522862 741.187661755872 741.190991018791 741.194320311618 741.197649634355 741.200978987002 741.204308369558 741.207637782025 741.210967224403 741.214296696693 741.217626198894 741.220955731007 741.224285293032 742.067626706004 742.070963878878 742.074301081766 742.077638314671 742.080975577592 742.08431287053 742.087650193485 742.090987546457 742.094324929448 742.097662342457 742.100999785484 742.104337258531 742.107674761597 742.111012294683 742.11434985779 742.117687450917 742.121025074066 742.124362727236 742.127700410428 742.131038123643 742.13437586688 742.137713640141 742.141051443425 742.174431127655 742.177769261226 742.181107424826 742.184445618454 742.187783842111 742.191122095798 742.194460379515 742.197798693263 742.201137037042 742.204475410852 742.207813814694 742.211152248568 742.214490712474 742.217829206413 742.221167730386 742.224506284392 742.227844868433 743.1470966977 743.150443586686 743.153790505819 743.157137455098 743.160484434525 743.1638314441 743.167178483823 743.170525553695 743.173872653716 743.177219783887 743.180566944208 743.183914134679 743.187261355301 743.190608606074 743.193955886998 743.197303198075 743.200650539304 743.203997910686 743.20734531222 743.210692743909 743.214040205752 743.217387697749 743.220735219901 743.224082772208 743.227430354671 743.23077796729 744.176009584717 744.179365747906 744.182721941368 744.186078165103 744.18943441911 744.192790703391 744.196147017945 744.199503362773 744.202859737876 744.206216143254 744.209572578908 "
    "744.212929044837 744.216285541042 744.219642067524 744.222998624283 758.202410978174 758.205894849435 758.209378752713 758.212862688007 758.216346655318 758.219830654647 758.223314685994 758.226798749359 758.230282844744 758.233766972148 758.237251131571 758.240735323015 758.24421954648 758.247703801965 758.251188089473 758.254672409002 759.203597733713 759.207090811794 759.210583922019 759.214077064387 759.2175702389 759.221063445557 759.22455668436 759.228049955308 759.231543258401 759.235036593642 759.238529961029 759.242023360563 759.245516792245 759.249010256075 760.200427521877 760.203929778783 760.207432067959 760.210934389405 760.214436743123 760.217939129111 760.221441547372 760.224943997905 760.228446480711 760.231948995789 760.235451543142 760.238954122768 760.24245673467 760.316019040799 760.319522362853 760.323025717192 760.326529103815 760.330032522725 760.33353597392 760.337039457402 760.340542973171 760.344046521228 760.347550101572 760.351053714205 760.354557359126 760.358061036338 760.361564745838 777.189954415057 777.193614963706 777.197275546837 777.200936164451 777.204596816548 777.208257503129 777.211918224194 777.215578979744 777.219239769779 777.2229005943 777.226561453308 777.230222346802 777.233883274784 777.237544237253 799.160490663856 799.164361099883 799.1682315734 799.172102084408 799.175972632907 799.179843218898 799.183713842382 799.187584503358 799.191455201828 799.195325937792 799.19919671125 799.203067522204 799.206938370653 799.210809256599 799.214680180041 799.21855114098 800.16418774129 800.168067905512 800.171948107365 800.175828346849 800.179708623967 800.183588938718 800.187469291103 800.191349681123 800.195230108777 800.199110574067 800.202991076993 800.206871617555 800.210752195754 801.158739593593 801.162629409414 801.166519263006 801.170409154372 801.174299083511 801.178189050424 801.182079055111 801.185969097572 801.18985917781 801.193749295823 801.197639451613 801.20152964518 801.205419876525 801.209310145647 "
    "801.213200452549 810.055165196855 810.059141881054 810.063118604297 810.067095366586 810.07107216792 810.0750490083 810.079025887728 810.083002806202 810.086979763725 810.090956760296 810.094933795916 810.098910870585 810.102887984305 810.106865137076 815.189564537267 815.19359179245 815.197619087424 815.20164642219 815.205673796749 815.209701211101 815.213728665248 815.217756159189 815.221783692925 815.225811266457 815.229838879786 815.233866532911 815.237894225833 815.241921958555 815.245949731074 815.249977543393 815.395005298192 815.3990345835 815.40306390863 815.407093273582 815.411122678358 815.415152122956 815.419181607379 815.423211131626 815.427240695699 815.431270299597 815.435299943322 815.439329626874 816.169358934812 816.17339587673 816.177432858584 816.181469880374 816.1855069421 816.189544043764 816.193581185365 816.197618366904 816.201655588382 816.2056928498 816.209730151157 816.213767492455 816.217804873695 816.221842294876 816.225879756 816.229917257066 816.233954798077 816.237992379031 816.24202999993 816.246067660775 816.250105361565 816.254143102302 817.183885871236 817.187932855536 817.19197987992 817.196026944389 817.200074048944 817.204121193585 817.208168378313 817.212215603128 817.216262868032 817.220310173024 817.224357518104 817.228404903275 817.232452328536 817.236499793888 817.240547299332 817.244594844868 817.248642430496 817.252690056218 818.164426363991 818.16848306611 818.172539808458 818.176596591035 818.180653413842 818.18471027688 818.18876718015 818.192824123651 818.196881107384 818.200938131351 818.204995195551 818.209052299986 818.213109444656 818.21716662956 818.221223854701 818.225281120079 818.229338425694 818.233395771546 818.237453157638 818.241510583968 818.245568050537 818.249625557347 819.18392233678 819.18798915515 819.1920560139 819.19612291303 819.200189852541 819.204256832432 819.208323852706 819.212390913362 819.216458014401 819.220525155824 819.224592337631 819.228659559823 819.2327268224 819.236794125363 "
    "819.240861468713 819.24492885245 820.193731546341 820.197808397262 820.201885288712 820.205962220691 820.210039193201 820.214116206241 820.218193259813 820.222270353916 820.226347488553 820.230424663722 820.234501879425 820.238579135663 832.21883436359 832.223031634984 832.227228948716 832.231426304787 832.235623703196 832.239821143946 832.244018627035 832.248216152466 832.252413720239 832.256611330353 832.260808982811 832.265006677613 832.269204414758 832.273402194249 832.277600016085 832.281797880267 832.285995786796 832.290193735673 832.294391726897 832.298589760471 833.218980432568 833.223187798465 833.227395206852 833.231602657731 833.235810151102 833.240017686965 833.244225265321 833.248432886172 833.252640549516 833.256848255356 833.261056003692 833.265263794525 833.269471627854 833.273679503681 834.221533310184 834.225750807043 834.229968346546 834.234185928695 834.238403553488 834.242621220928 834.246838931015 834.251056683749 834.255274479132 834.259492317163 834.263710197844 834.267928121174 835.218046494203 835.222274073065 835.226501694725 835.230729359182 835.234957066438 835.239184816494 835.243412609349 835.247640445004 835.251868323461 835.256096244719 835.26032420878 835.264552215644 835.268780265312 835.273008357784 835.277236493061 873.174235302306 873.178855854748 873.18347645609 873.188097106335 873.192717805482 873.197338553533 873.201959350488 873.206580196348 873.211201091114 873.215822034786 873.220443027366 873.225064068854 873.229685159251 873.234306298558 873.238927486775 874.17804253512 874.182673717335 874.18730494862 874.191936228976 874.196567558404 874.201198936904 874.205830364477 874.210461841124 874.215093366845 874.219724941642 874.224356565516 874.228988238466 874.233619960494 874.238251731601 874.303101680785 874.307734188164 874.312366744634 874.316999350196 874.321632004851 874.3262647086 874.330897461442 874.335530263379 874.340163114412 874.344796014542 874.349428963769 874.354061962094 875.174876842222 875.179518592457 "
    "875.184160391931 875.188802240643 875.193444138596 875.198086085788 875.202728082222 875.207370127898 875.212012222817 875.216654366978 875.221296560385 875.225938803036 875.230581094934 889.200602342844 889.205394064883 889.210185838565 889.214977663891 889.219769540862 889.224561469479 889.229353449744 889.234145481656 889.238937565216 889.243729700426 889.248521887286 889.253314125797 889.25810641596 889.262898757776 889.267691151245 889.272483596368 889.277276093147 889.282068641582 889.286861241673 889.291653893423 889.296446596831 889.301239351898 889.306032158626 889.310825017014 889.315617927065 889.320410888778 889.325203902155 889.329996967196 889.334790083902 890.02073813417 890.0255386994 890.030339316416 890.03513998522 890.039940705812 890.044741478193 890.049542302364 890.054343178326 890.059144106079 890.063945085625 890.068746116964 890.073547200097 890.078348335025 890.083149521749 890.174381911812 890.179184134627 890.183986409256 890.188788735699 890.193591113957 890.198393544031 890.203196025921 890.207998559629 890.212801145155 890.217603782501 890.222406471667 890.227209212653 890.232012005462 890.236814850093 890.241617746547 890.246420694826 890.25122369493 890.25602674686 890.260829850616 890.2656330062 890.270436213613 890.275239472855 890.280042783927 891.198426546905 891.203239824931 891.208053154948 891.212866536959 891.217679970964 891.222493456964 891.22730699496 891.232120584952 891.236934226942 891.24174792093 891.246561666917 891.251375464905 891.256189314893 891.261003216882 891.265817170875 891.27063117687 891.27544523487 891.280259344875 892.200708915166 892.205533025772 892.210357188546 892.21518140349 892.220005670603 892.224829989886 892.229654361341 892.234478784968 892.239303260768 892.244127788742 892.248952368891 892.253777001215 892.258601685716 892.263426422395 892.268251211251 892.273076052286 893.142398272161 893.147232571559 893.15206692329 893.156901327355 893.161735783755 893.166570292491 893.171404853563 "
    "893.176239466974 893.181074132723 893.185908850811 893.190743621239 893.20041331912 893.205248246574 893.210083226371 893.214918258513 893.219753343 893.224588479834 893.229423669014 893.234258910542 893.239094204419 893.243929550645 893.248764949222 893.25360040015 893.25843590343 893.263271459063 893.26810706705 893.272942727391 894.197514830975 894.202360559179 894.207206339903 894.212052173146 894.21689805891 894.221743997196 894.226589988005 894.231436031336 894.236282127192 894.241128275573 894.24597447648 894.250820729913 894.255667035874 894.260513394364 894.265359805383 894.270206268932 906.234202718878 906.239179781027 906.244156897845 906.249134069332 906.25411129549 906.259088576319 906.26406591182 906.269043301994 906.274020746843 906.278998246366 906.283975800565 906.288953409441 906.293931072995 906.298908791226 907.235692252254 907.240680320926 907.245668444448 907.250656622821 907.255644856045 907.260633144123 907.265621487054 907.270609884839 907.27559833748 907.280586844978 907.285575407332 907.290564024546 907.295552696618 907.30054142355 908.234398692328 908.239397749042 908.244396860787 908.249396027565 908.254395249375 908.25939452622 908.2643938581 908.269393245016 908.274392686968 908.279392183959 908.284391735988 908.289391343056 922.842856257044 922.84801742175 922.853178644185 922.858339924351 922.86350126225 922.86866265788 922.873824111245 922.878985622344 922.884147191179 922.88930881775 922.894470502059 934.042623867136 934.0479110658 934.053198324322 934.058485642702 934.063773020941 934.069060459041 934.074347957002 934.079635514825 934.084923132512 934.090210810063 934.09549854748 934.100786344763 934.106074201913 934.111362118932 962.94815872668 962.953778232548 962.959397804004 962.96501744105 962.970637143686 962.976256911914 962.981876745735 962.987496645149 962.993116610159 962.998736640765 963.004356736968 963.00997689877 963.217969011729 963.223591667127 963.229214388169 963.234837174856 963.240460027188 963.246082945167 "
    "963.251705928794 963.257328978069 963.262952092996 963.268575273574 963.274198519804 963.279821831688 963.285445209227 963.291068652422 963.296692161274 963.302315735784 963.307939375954 963.313563081784 963.319186853277 963.324810690432 963.420425969611 963.426050988895 963.431676073865 963.43730122452 963.442926440862 963.448551722892 963.454177070612 963.459802484022 963.465427963124 963.471053507919 963.476679118408 963.482304794592 964.21420252401 964.219836816216 964.225471174269 964.23110559817 964.236740087921 964.242374643523 964.248009264976 964.253643952283 964.259278705443 964.26491352446 964.270548409332 964.276183360063 964.281818376652 964.287453459101 964.293088607411 964.298723821583 964.304359101619 964.309994447519 964.315629859286 964.321265336919 964.32690088042 964.33253648979 964.338172165031 964.343807906143 964.349443713128 964.355079585987 964.36071552472 964.36635152933 964.467810878442 964.473448134917 964.479085457292 964.484722845568 964.490360299745 964.495997819824 964.501635405808 964.507273057696 964.512910775491 964.518548559193 964.524186408804 964.529824324324 965.201207199106 965.206853032182 965.212498931307 965.218144896483 965.223790927711 965.229437024992 965.235083188328 965.240729417718 965.246375713166 965.252022074672 965.257668502236 965.26331499586 965.268961555546 965.274608181294 965.280254873106 965.285901630983 965.291548454925 965.297195344935 965.302842301012 965.308489323159 965.314136411377 965.319783565667 965.325430786029 965.331078072465 966.212864647697 966.218522322157 966.224180062874 966.22983786985 966.235495743085 966.241153682582 966.246811688342 966.252469760364 966.258127898651 966.263786103204 966.269444374024 966.275102711111 966.280761114469 966.286419584096 966.292078119995 966.297736722167 966.303395390612 966.309054125333 966.31471292633 966.320371793604 966.326030727157 967.215306113877 967.220975534084 967.226645020755 967.232314573891 967.237984193494 967.243653879564 967.249323632103 "
    "967.254993451112 967.260663336592 967.266333288544 967.272003306969 967.277673391869 967.283343543245 967.289013761098 967.294684045428 967.300354396238 967.306024813528 967.3116952973 967.317365847555 967.323036464293 967.328707147517 967.334377897227 967.340048713424 967.345719596109 967.351390545285 980.194309595126 980.200132191883 980.205954857816 980.211777592926 980.217600397214 980.223423270681 980.229246213329 980.235069225159 980.240892306172 980.24671545637 980.252538675753 980.258361964323 980.264185322081 980.270008749028 980.275832245166 980.281655810496 980.287479445018 980.293303148735 980.299126921648 980.304950763757 980.310774675063 980.31659865557 980.322422705276 989.849128120579 989.855065986618 989.861003923897 989.866941932417 989.872880012179 989.878818163186 989.884756385438 989.890694678936 989.896633043682 989.902571479677 989.908509986923 989.91444856542 1024.22504311064 1024.23140056509 1024.23775809846 1024.24411571076 1024.25047340198 1024.25683117213 1024.26318902121 1024.26954694921 1024.27590495616 1024.28226304203 1024.28862120684 1024.29497945058 1024.30133777326 1024.30769617489 1024.31405465545 1024.32041321495 1024.3267718534 1024.3331305708 1024.33948936714 1024.62571693597 1024.63207936544 1024.63844187393 1024.64480446143 1024.65116712796 1024.6575298735 1024.66389269807 1024.67025560165 1024.67661858427 1024.6829816459 1024.68934478657 1024.69570800627 1024.80389483394 1024.8102594764 1024.81662419793 1024.82298899851 1024.82935387816 1024.83571883686 1024.84208387463 1024.84844899146 1024.85481418736 1024.86117946232 1024.86754481635 1024.87391024946 1024.88027576163 1024.88664135288 1037.17792520177 1037.18444447285 1037.19096382588 1037.19748326088 1037.20400277783 1037.21052237674 1037.21704205761 1037.22356182045 1037.23008166525 1037.23660159202 1037.24312160075 1037.24964169146 1037.25616186413 1037.26268211878 1037.2692024554 1037.275722874 1037.28224337457 1037.28876395712 1037.29528462166 1037.30180536817 "
    "1037.30832619667 1037.31484710715 1037.32136809962 1037.32788917408 1038.22205208364 1038.22858448726 1038.2351169731 1038.24164954113 1038.24818219137 1038.25471492382 1038.26124773848 1038.26778063535 1038.27431361443 1038.28084667573 1038.28737981924 1038.29391304497 1038.30044635292 1038.30697974309 1038.31351321548 1038.32004677009 1038.32658040693 1039.22901160479 1039.235556686 1039.24210184966 1039.24864709577 1039.25519242432 1039.26173783531 1039.26828332876 1039.27482890466 1039.28137456301 1039.28792030381 1039.29446612706 1039.30101203278 1039.30755802095 1039.31410409158 1039.32065024467 1039.32719648023 1039.33374279825 1039.34028919873 1039.34683568169 1040.22481095549 1040.23136858588 1040.23792629894 1040.24448409469 1040.25104197312 1040.25759993424 1040.26415797804 1040.27071610453 1040.27727431371 1040.28383260558 1040.29039098014 1040.2969494374 1040.30350797735 1040.3100666 1040.31662530535 1040.32318409339 1040.32974296414 1041.2290907215 1041.2356610201 1041.24223140163 1041.24880186607 1041.25537241343 1041.26194304372 1041.26851375694 1041.27508455308 1041.28165543215 1041.28822639415 1041.29479743909 1041.30136856695 1041.30793977776 1041.3145110715 1041.32108244817 1041.32765390779 1041.33422545035 1041.34079707585 1041.3473687843 1041.35394057569 1041.36051245003 1041.36708440732 1041.37365644756 1041.38022857076 1041.3868007769 1041.39337306601 1041.39994543807 1041.40651789309 1041.41309043107 1041.41966305201 1088.79279195134 1088.79997622919 1088.80716060185 1088.81434506932 1088.82152963161 1088.82871428871 1088.83589904063 1088.84308388737 1088.85026882893 1088.85745386531 1088.86463899652 1098.12539546821 1098.13270343459 1098.14001149825 1098.14731965918 1098.15462791738 1098.16193627285 1098.1692447256 1098.17655327563 1098.18386192294 1098.19117066753 1098.19847950941 1098.20578844857 1098.21309748502 1098.22040661877 1098.2277158498 1098.23502517813 1098.24233460375 1098.24964412667 1098.2569537469 1098.26426346442 "
    "1098.27157327925 1111.23703980607 1111.2445233295 1111.25200695373 1111.25949067876 1111.26697450458 1111.27445843121 1111.28194245863 1111.28942658687 1111.29691081591 1111.30439514576 1111.31187957642 1111.31936410789 1111.32684874018 1111.33433347329 1111.34181830722 1111.34930324196 1112.25572512581 1112.26322237607 1112.27071972739 1112.27821717979 1112.28571473327 1112.29321238783 1112.30071014346 1112.30820800018 1112.31570595798 1112.32320401687 1112.33070217685 1112.33820043792 1112.34569880008 1112.41318860905 1112.42068798226 1112.42818745657 1112.43568703201 1112.44318670856 1112.45068648624 1112.45818636504 1112.46568634496 1112.47318642601 1112.48068660819 1112.48818689151 1112.49568727595 1112.50318776154 1112.57819818028 1112.58569977849 1112.59320147786 1112.60070327839 1112.60820518009 1112.61570718295 1112.62320928699 1112.63071149219 1112.63821379856 1112.64571620611 1112.65321871484 1112.66072132475 1114.26108654592 1114.26861085524 1114.27613526618 1114.28365977874 1114.29118439293 1114.29870910874 1114.30623392618 1114.31375884525 1114.32128386596 1114.32880898829 1114.33633421227 1115.25517475482 1115.2627124958 1115.27025033867 1115.27778828344 1115.28532633011 1115.29286447867 1115.30040272913 1115.3079410815 1115.31547953577 1115.32301809195 1115.33055675004 1115.33809551004 1115.34563437195 1130.2815779083 1130.28932013803 1130.29706247383 1130.30480491569 1130.31254746363 1130.32029011764 1130.32803287773 1130.33577574389 1130.34351871613 1130.35126179446 1130.35900497886 1147.66276619636 1147.67074837394 1147.67873066254 1147.68671306219 1147.69469557288 1147.70267819461 1147.71066092738 1147.7186437712 1147.72662672607 1147.73460979199 1147.74259296897 1147.750576257 1147.75855965609 1147.76654316625 1147.77452678746 1182.98466783959 1182.99314891893 1183.00163011987 1183.01011144242 1183.01859288659 1183.02707445237 1183.03555613976 1183.04403794878 1183.05251987942 1183.06100193168 1183.06948410557 1183.07796640108 1183.1712796801 "
    "1183.17976343539 1183.18824731234 1183.19673131095 1183.20521543123 1183.21369967318 1183.22218403681 1183.23066852212 1183.2391531291 1183.24763785777 1183.25612270812 1183.26460768015 1183.27309277388 1183.68052043171 1183.68901149146 1183.69750267303 1183.70599397643 1183.71448540165 1183.7229769487 1183.73146861758 1183.7399604083 1183.74845232085 1183.75694435525 1183.76543651148 1183.77392878956 1188.27493289966 1188.28349000304 1188.29204722968 1188.30060457956 1188.30916205269 1188.31771964907 1188.32627736871 1188.3348352116 1188.34339317776 1188.35195126718 1188.36050947987 1209.74923184622 1209.75810103042 1209.76697034466 1209.77583978896 1209.78470936331 1209.79357906772 1209.80244890218 1209.81131886671 1209.82018896131 1209.82905918597 1209.83792954071 1209.87341226042 1209.88228326555 1209.89115440077 1209.90002566609 1209.9088970615 1209.917768587 1209.92664024261 1209.93551202832 1209.94438394413 1209.95325599005 1209.96212816609 1214.99579864251 1215.00474492341 1215.01369133607 1215.02263788047 1215.03158455663 1215.04053136455 1215.04947830422 1215.05842537566 1215.06737257887 1215.07631991384 1215.08526738058 1215.0942149791 1215.10316270939 1215.11211057146 1240.4233010027 1240.43262565993 1240.44195045736 1240.45127539499 1240.46060047282 1240.46992569085 1240.47925104909 1240.48857654754 1240.4979021862 1240.50722796507 1240.51655388417 1240.52587994349 1240.53520614303 1240.5445324828 1243.04905650569 1243.05842068214 1243.06778499968 1243.0771494583 1243.08651405802 1243.09587879883 1243.10524368075 1243.11460870376 1243.12397386788 1243.13333917311 1243.14270461945 1243.15207020691 1243.16143593548 1243.17080180517 1243.18016781599 1243.18953396794 1250.94602927114 1250.95551280543 1250.96499648351 1250.97448030538 1250.98396427106 1250.99344838053 1251.00293263381 1251.0124170309 1251.0219015718 1251.03138625652 1251.04087108505 1251.05035605741 1261.31128248752 1261.32092383336 1261.33056532659 1261.34020696722 1261.34984875525 "
    "1261.35949069069 1261.36913277353 1261.37877500379 1261.38841738147 1261.39805990657 1261.40770257909 1261.94792763215 1261.95757871339 1261.96722994224 1261.97688131873 1261.98653284283 1261.99618451457 1262.00583633394 1262.01548830095 1262.02514041559 1262.03479267788 1262.04444508782 1262.05409764541 1262.06375035065 1262.07340320354 1262.32442921749 1262.33408605841 1262.34374304707 1262.35340018349 1262.36305746766 1262.3727148996 1262.3823724793 1262.39203020678 1262.40168808202 1262.41134610504 1262.42100427584 1262.43066259442 1262.44032106079 1263.28117374346 1263.29084522825 1263.30051686113 1263.31018864211 1263.31986057118 1263.32953264835 1263.33920487361 1263.34887724699 1263.35854976847 1263.36822243806 1263.37789525577 1263.3875682216 1263.39724133555 1263.40691459763 1265.31544052296 1265.32514318102 1265.33484598788 1265.34454894355 1265.35425204803 1265.36395530132 1265.37365870343 1265.38336225437 1265.39306595413 1265.40276980271 1265.41247380013 1265.42217794639 1273.46930606141 1273.47913417338 1273.48896243705 1273.49879085242 1273.5086194195 1273.51844813829 1273.5282770088 1273.53810603102 1273.54793520496 1273.55776453063 1273.56759400803 1273.57742363715 1273.58725341802 1273.59708335062 1273.60691343496 1273.61674367105 1273.62657405888 1281.32087896611 1281.33082864257 1281.34077847355 1281.35072845906 1281.3606785991 1281.37062889368 1281.38057934279 1281.39052994644 1281.40048070464 1281.41043161738 1281.42038268468 1281.43033390653 1281.44028528294 1281.45023681392 1281.46018849946 1281.47014033957 1281.48009233426 1293.16997731079 1293.18011185941 1293.19024656688 1293.2003814332 1293.21051645839 1293.22065164243 1293.23078698534 1293.24092248711 1293.25105814776 1293.26119396729 1293.27132994569 1293.28146608298 1409.30396671911 1409.31600329167 1409.32804006984 1409.34007705362 1409.35211424301 1409.36415163802 1409.37618923866 1409.38822704493 1409.40026505684 1409.4123032744 1409.4243416976 1409.43638032645 1439.81291838247 "
    "1439.82548173949 1439.83804531576 1439.85060911129 1439.86317312607 1439.87573736013 1439.88830181346 1439.90086648606 1439.91343137795 1439.92599648913 1439.93856181961 1439.97625912687 1439.98882533458 1440.00139176163 1440.013958408 1440.0265252737 1440.03909235875 1440.05165966315 1440.0642271869 1440.07679493 1440.08936289247 1440.10193107432 1456.39679555874 1456.40964999523 1456.42250465864 1456.43535954896 1456.44821466621 1456.46107001039 1456.47392558151 1456.48678137957 1456.49963740459 1456.51249365655 1456.52535013548 1456.53820684138 1456.55106377425 1456.5639209341 1456.57677832093 1469.49643693345 1469.5095236508 1469.52261060125 1469.5356977848 1469.54878520145 1469.56187285121 1469.57496073409 1469.58804885009 1469.60113719922 1469.61422578149 1469.6273145969 1469.64040364545 1477.46994793765 1477.48317705841 1477.49640641608 1477.50963601066 1477.52286584217 1477.53609591059 1477.54932621596 1477.56255675826 1477.5757875375 1477.58901855369 1477.60224980685 1477.61548129696 1477.62871302405 1477.64194498811 1477.65517718916 1477.6684096272 1477.68164230223 1477.69487521426 1477.7081083633 1477.72134174936 1478.91331787051 1478.9265728516 1478.93982807029 1478.9530835266 1478.96633922051 1478.97959515204 1478.99285132121 1479.006107728 1479.01936437244 1479.03262125452 1479.04587837426 1480.17360285036 1480.18688043216 1480.20015825217 1480.2134363104 1480.22671460685 1480.23999314153 1480.25327191444 1480.2665509256 1480.279830175 1480.29310966266 1480.30638938858 1480.31966935276 1480.33294955522 1480.34622999596 1480.35951067499 1480.37279159231 1480.38607274793 1480.39935414185 1480.41263577409 1480.42591764464 1480.73146645809 1480.74475405022 1480.75804188082 1480.77132994991 1480.78461825749 1480.79790680357 1480.81119558816 1480.82448461126 1480.83777387287 1480.85106337301 1480.86435311168 1480.87764308888 1480.89093330463 1480.90422375893 1480.91751445178 1480.9308053832 1480.94409655318 1480.95738796174 1480.97067960888 1480.983971494 "
    "1480.99726361894 1481.01055598187 1481.0238485834 1481.03714142355 1481.05043450231 1481.06372781971 1481.07702137574 1481.34294261915 1481.35624118796 1481.36953999554 1481.38283904191 1481.39613832706 1481.409437851 1481.42273761375 1481.4360376153 1481.44933785567 1481.46263833486 1481.47593905287 1481.48924000971 1481.50254120539 1481.51584263992 1481.5291443133 1481.54244622554 1481.55574837664 1481.56905076662 1481.58235339547 1481.5956562632 1481.60895936983 1481.62226271535 1481.63556629978 1481.64887012311 1481.66217418536 1481.67547848654 1482.36763154258 1482.38094851586 1482.39426572841 1482.40758318025 1482.42090087136 1482.43421880177 1482.44753697147 1482.46085538047 1482.47417402879 1482.48749291642 1482.50081204337 1482.51413140965 1482.52745101526 1482.54077086022 1493.62532276273 1493.63884277381 1493.65236302966 1493.66588353027 1493.67940427566 1493.69292526583 1493.70644650079 1493.71996798055 1493.73348970511 1493.74701167448 1493.76053388867 1493.77405634768 1511.59045068974 1511.60429789207 1511.6181453481 1511.63199305785 1511.64584102131 1511.65968923849 1511.6735377094 1511.68738643405 1511.70123541244 1511.71508464459 1511.72893413049 1599.95476419777 1599.97027768381 1599.98579147069 1600.00130555844",

     "0 0 0 0 0 0 0 0 0 193.855026245117 641.106506347656 877.26220703125 700.196716308594 274.883911132813 0 0 0 0 0 0 0 0 0 0 224.89469909668 511.670349121094 595.136657714844 452.148010253906 234.596389770508 74.6820220947266 0 0 0 0 0 0 0 0 119.225784301758 185.543075561523 200.134750366211 188.900192260742 160.073196411133 0 0 0 0 0 0 0 172.296859741211 200.144027709961 165.512985229492 0 0 0 0 0 0 0 0 83.4415893554688 208.525405883789 177.816024780273 100.466018676758 0 0 0 0 0 0 0 0 93.3426513671875 177.81330871582 221.383926391602 233.153823852539 185.899673461914 84.1839904785156 0 0 0 0 0 0 0 0 126.048049926758 184.371139526367 97.8295288085938 0 0 0 0 0 0 0 0 25.8681793212891 261.258850097656 531.637878417969 574.53076171875 413.904724121094 218.982650756836 112.732650756836 0 0 0 0 0 0 0 0 94.0497131347656 191.148391723633 161.991897583008 0 0 0 0 0 0 0 402.995788574219 1600.27600097656 3017.67749023438 3685.970703125 3078.0078125 1699.85888671875 531.254028320313 44.9793395996094 0 0 0 0 0 0 0 0 3.05120849609375 326.982971191406 918.194396972656 1295.37927246094 1141.49755859375 577.818969726563 26.3272705078125 0 0 0 0 0 0 0 0 125.907791137695 264.531921386719 266.280029296875 158.506088256836 0 0 0 0 0 0 0 0 45.1534271240234 245.012252807617 337.062133789063 230.558639526367 35.3934326171875 0 0 0 0 0 0 0 0 21.4011077880859 269.609924316406 302.905334472656 3843.85766601563 9906.61328125 14627.65625 14086.5751953125 8667.4873046875 2666.59497070313 152.549850463867 452.571411132813 21.2885437011719 0 0 0 0 0 0 0 0 0 242.630386352539 1476.34033203125 2982.52856445313 3656.2958984375 2926.99194335938 1440.77648925781 378.651611328125 617.814758300781 1036.13317871094 1038.09765625 677.166748046875 273.266662597656 106.01123046875 0 0 0 0 0 0 0 0 0 644.765441894531 1669.39282226563 2428.14697265625 2279.11108398438 1350.7001953125 456.782958984375 195.992416381836 144.774459838867 138.42707824707 203.370742797852 302.340209960938 350.181884765625 "
    "314.466613769531 225.259658813477 125.442489624023 0 0 0 0 0 0 0 0 0 229.676986694336 1286.525390625 3076.466796875 4448.58984375 4288.94775390625 2695.29956054688 856.980102539063 0 0 0 0 0 0 0 0 0 0 297.09423828125 790.947937011719 1078.3701171875 895.997009277344 377.297119140625 0 0 0 0 0 0 0 0 0 54.2761840820313 380.800170898438 604.678894042969 530.256896972656 239.020004272461 14.5890960693359 0 0 0 0 0 0 0 0 0 315.951721191406 1584.78002929688 3584.27490234375 4964.8896484375 4550.10595703125 2648.34790039063 761.737854003906 336.893249511719 327.000427246094 103.404342651367 0 0 0 0 0 0 0 0 137.308151245117 232.669479370117 225.336959838867 131.02082824707 0 0 0 0 0 0 0 0 0 309.901550292969 806.588073730469 1159.07531738281 1105.30993652344 695.416931152344 245.27473449707 13.4951171875 0 0 0 0 0 0 0 0 114.433959960938 215.006851196289 272.628845214844 187.665817260742 12.0498352050781 0 0 0 0 0 0 0 0 127.550247192383 182.018173217773 211.423233032227 191.385147094727 141.782333374023 0 0 0 0 0 0 0 0 0 745.767456054688 2422.9541015625 3720.92529296875 3568.47998046875 2088.86743164063 510.764953613281 183.886978149414 136.265151977539 0 0 0 0 0 0 0 0 171.257888793945 188.640060424805 192.395614624023 154.632247924805 0 0 0 0 0 0 0 0 130.887710571289 642.11865234375 1160.51184082031 1294.43505859375 977.964050292969 544.39794921875 308.192199707031 211.437362670898 76.1909332275391 0 0 0 0 0 0 0 0 0 229.855178833008 543.525207519531 586.220275878906 314.952575683594 0 0 0 0 0 0 0 0 0 154.422073364258 196.758010864258 149.831283569336 0 0 0 0 0 0 0 0 123.318832397461 188.429489135742 169.386795043945 0 0 0 0 0 0 0 0 2959.08642578125 8616.0419921875 13691.96484375 14140.76953125 9577.6708984375 3752.03759765625 393.419616699219 324.138061523438 232.52278137207 0 0 0 0 0 0 0 0 0 133.11164855957 205.964584350586 199.730422973633 139.437789916992 0 0 0 0 0 0 0 0 101.496200561523 185.133193969727 259.655029296875 244.710922241211 160.866897583 0 0 0 0 0 0 0 0 "
    "171.158157348633 209.737930297852 216.904006958008 153.206130981445 0 0 0 0 0 0 0 0 0 1064.01928710938 2744.22631835938 3925.62744140625 3728.50854492188 2484.57104492188 1484.09924316406 1184.474609375 801.294799804688 276.304870605469 0 0 0 0 0 0 0 0 0 0 300.0966796875 1263.98876953125 2300.80615234375 2527.240234375 1658.1162109375 416.934509277344 362.052856445313 510.349609375 422.890075683594 293.749877929688 96.1615142822266 0 0 0 0 0 0 0 0 277.112182617188 552.278137207031 634.911743164063 465.758728027344 230.118118286133 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 338.728454589844 100.444885253906 1113.40734863281 4002.13525390625 6734.62841796875 7179.69189453125 4943.12939453125 1888.85778808594 87.8339996337891 0 0 0 0 0 0 0 0 166.607498168945 203.203231811523 88.5599517822266 0 0 134.797103881836 252.799118041992 321.236206054688 317.407653808594 177.626174926758 0 0 0 0 0 0 0 0 420.235168457031 1400.63110351563 2127.62890625 2036.72399902344 1375.9619140625 1018.35345458984 909.901550292969 528.322021484375 118.658309936523 0 0 0 0 0 0 0 0 6.52516174316406 184.584854125977 399.570495605469 472.823852539063 311.700012207031 67.0648040771484 0 0 0 0 0 0 0 0 4.97833251953125 518.760131835938 1195.45788574219 1522.00109863281 1192.40087890625 457.996826171875 236.555740356445 455.735107421875 494.134094238281 419.947204589844 169.757431030273 0 0 0 0 0 0 0 0 158.202651977539 249.356582641602 255.182876586914 181.06364440918 0 0 0 0 0 0 0 0 173.365737915039 243.861038208008 222.755081176758 104.503341674805 0 0 0 0 0 0 0 0 127.732864379883 184.066452026367 159.648910522461 0 0 0 0 0 0 0 0 0 216.264389038086 564.540100097656 758.490661621094 593.172241210938 186.406509399414 0 0 0 0 0 0 0 0 0 57.8870544433594 189.093154907227 180.032363891602 0 0 0 0 0 0 0 0 107.181259155273 588.624389648438 3296.2294921875 6859.40966796875 8629.48046875 6954.76904296875 3204.29370117188 530.406066894531 701.101257324219 446.318359375 172.379989624023 0 0 0 0 0 0 0 0 "
    "106.025817871094 219.603103637695 171.653244018555 0 0 0 0 0 0 0 0 66.6060028076172 816.289489746094 2058.00170898438 2839.88916015625 2264.32885742188 887.272766113281 1098.07897949219 1184.8994140625 515.840759277344 0 0 0 0 0 0 0 0 0 107.923675537109 213.511978149414 238.096145629883 157.005569458008 0 0 0 0 0 0 0 0 84.7611541748047 279.91943359375 997.471740722656 1668.52087402344 1678.548828125 1062.6884765625 456.879150390625 261.066772460938 414.542724609375 400.814636230469 181.47590637207 0 0 0 0 0 0 0 0 162.703384399414 402.678283691406 606.938415527344 584.632751464844 322.495727539063 0 0 0 0 0 0 0 0 203.609512329102 221.824447631836 103.749816894531 0 0 0 0 0 0 0 0 139.273239135742 246.041458129883 237.826309204102 138.225112915039 0 0 0 102.917053222656 540.358703613281 1507.14807128906 2255.67041015625 2121.10278320313 1207.01428222656 254.796005249023 0 0 0 0 0 0 0 0 0 180.893783569336 216.125747680664 186.408401489258 92.5867767333984 0 0 0 0 0 0 0 0 67.1141357421875 314.660339355469 430.744506835938 249.505142211914 110.873168945313 311.952087402344 298.573059082031 158.444198608398 0 0 0 0 0 0 0 0 0 203.841903686523 330.667297363281 305.950500488281 171.00895690918 0 0 0 0 0 0 0 0 150.461807250977 187.074295043945 122.066360473633 0 0 0 0 0 0 0 0 128.328475952148 228.142013549805 224.649185180664 115.597442626953 0 0 0 0 0 0 0 0 121.621292114258 209.864395141602 180.903396606445 0 0 0 0 0 0 0 0 180.190689086914 221.191635131836 230.223587036133 203.161819458008 163.631942749023 0 0 0 103.920654296875 254.635330200195 239.919662475586 117.75276184082 0 0 0 0 0 0 0 0 127.274429321289 277.754516601563 418.050842285156 364.745910644531 108.102828979492 0 0 0 0 0 0 0 0 122.235366821289 204.649490356445 1283.6416015625 2732.66333007813 3403.52026367188 2677.83666992188 1189.97729492188 91.4230346679688 0 0 0 0 0 0 0 0 179.184860229492 218.383316040039 188.207290649414 103.431289672852 0 0 0 0 0 19.3411254882813 320.543273925781 708.724914550781 "
    "746.338012695313 324.464965820313 498.983642578125 805.302062988281 584.451416015625 150.821365356445 0 0 0 0 0 0 0 0 18.6659393310547 273.791931152344 556.722961425781 580.784423828125 324.137634277344 118.86296081543 192.937911987305 133.19303894043 0 0 0 0 0 0 0 0 156.306106567383 528.205383300781 857.985168457031 865.72802734375 528.765258789063 126.998458862305 0 0 0 0 0 0 0 0 141.282363891602 213.537307739258 188.727676391602 83.9633941650391 0 0 0 0 0 0 0 0 53.5650329589844 300.0869140625 496.208679199219 543.627502441406 469.730163574219 370.066101074219 289.648376464844 183.115615844727 57.3272399902344 0 0 0 0 0 0 0 0 128.359512329102 282.553894042969 428.125305175781 518.781311035156 625.49609375 722.9619140625 704.251159667969 596.822631835938 501.902587890625 382.079040527344 159.27229309082 0 0 0 0 0 0 0 0 65.7273559570313 820.538696289063 2162.48120117188 3311.76513671875 3299.95263671875 2090.16650390625 672.241455078125 0 0 0 0 0 0 0 0 0 0 308.417297363281 836.372497558594 1054.75146484375 828.995056152344 520.746643066406 281.113220214844 0 0 0 0 0 0 0 0 0 135.923385620117 224.629806518555 176.55793762207 0 0 0 0 0 0 0 0 0 243.977737426758 679.087585449219 930.161682128906 790.303100585938 379.179931640625 152.314804077148 0 0 0 0 0 0 0 0 136.929214477539 317.641784667969 361.6630859375 256.365356445313 53.1949462890625 0 0 0 0 0 0 0 0 79.8312377929688 199.234237670898 225.433242797852 110.191116333008 0 0 0 0 0 0 0 0 88.5470733642578 328.809631347656 486.254577636719 566.095397949219 679.935241699219 807.850219726563 851.315795898438 785.165161132813 654.703979492188 527.893920898438 423.899841308594 256.051086425781 0 0 0 0 0 0 0 0 0 0 325.090454101563 1122.31469726563 1884.14013671875 2005.18811035156 1370.16577148438 511.172485351563 0 0 0 0 0 0 0 0 0 144.137466430664 222.952560424805 139.711410522461 0 0 0 31.4209136962891 456.088439941406 906.362609863281 992.082092285156 640.056396484375 191.88249206543 0 0 0 0 0 0 0 0 0 142.481643676758 "
    "248.23698425293 361.091796875 321.38818359375 84.5967559814453 0 0 0 0 0 0 0 0 68.5481414794922 229.667556762695 342.556030273438 233.595016479492 12.875 284.913818359375 586.492919921875 765.540771484375 846.076843261719 837.908752441406 736.949829101563 570.628051757813 422.32958984375 338.351196289063 265.928649902344 102.936645507813 0 0 0 0 0 0 0 0 111.217437744141 194.165725708008 498.359680175781 810.423156738281 786.201354980469 424.384338378906 32.8225250244141 0 0 0 0 0 0 0 0 126.047775268555 188.677780151367 216.424392700195 207.760787963867 193.143905639648 173.67204284668 0 0 0 0 0 0 0 0 230.711318969727 263.243713378906 218.297134399414 121.326461791992 0 0 0 0 0 0 0 0 85.8698425292969 222.64518737793 225.071212768555 111.491928100586 0 0 0 0 0 0 0 0 158.272689819336 319.939025878906 405.672607421875 543.889831542969 709.350402832031 762.2890625 669.657836914063 464.710327148438 230.338363647461 135.231704711914 0 0 0 0 0 0 0 0 112.85188293457 340.410949707031 556.054382324219 649.1904296875 642.006286621094 595.709777832031 552.84423828125 532.100952148438 509.958984375 393.80126953125 147.021102905273 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 163.031021118164 257.087280273438 222.833755493164 69.1905975341797 0 0 0 0 0 0 0 0 0 193.01008605957 1283.4189453125 2651.75854492188 3263.72827148438 2533.265625 1061.58337402344 237.298934936523 292.41845703125 36.6092681884766 0 0 0 0 0 0 0 0 0 412.251708984375 1201.08520507813 1691.83618164063 1483.95202636719 787.549011230469 140.731460571289 0 0 0 0 0 0 0 0 155.059463500977 197.582107543945 226.128463745117 389.715087890625 812.975402832031 1328.24084472656 1494.00390625 1091.52282714844 416.5791015625 13.3121490478516 0 0 0 0 0 0 0 0 30.8641204833984 259.902893066406 398.201293945313 307.794982910156 89.9954833984375 0 0 0 0 0 0 0 0 250.239639282227 294.914489746094 240.247360229492 36.3681182861328 0 0 0 0 0 0 0 0 168.141342163086 211.644943237305 185.341293334961 0 0 0 0 0 0 0 0 0 1255.41430664063 "
    "4270.45751953125 7186.3505859375 7656.57861328125 5270.84912109375 2048.24633789063 131.94660949707 0 0 0 0 0 0 0 0 171.324295043945 234.151138305664 188.494430541992 85.8521118164063 0 0 0 0 0 0 0 177.790451049805 196.738876342773 191.143508911133 173.924301147461 0 0 0 0 0 0 0 0 27.4716339111328 870.664428710938 2696.56469726563 4313.33056640625 4373.56005859375 2848.65014648438 1105.826171875 363.445678710938 95.8519592285156 0 0 0 0 0 0 0 0 165.054183959961 190.630477905273 212.371444702148 119.549850463867 0 0 0 0 144.282302856445 1497.27661132813 3014.11791992188 3372.33959960938 2141.125 440.955444335938 486.9052734375 473.754028320313 237.800888061523 10.4761962890625 0 0 0 0 0 0 0 0 187.649795532227 717.752685546875 1004.04693603516 895.356262207031 611.759887695313 231.517959594727 0 0 0 0 0 0 0 0 0 0 380.191772460938 1166.65649414063 1580.28991699219 1321.69921875 695.5244140625 219.708572387695 60.3770294189453 0 0 0 0 0 0 0 0 168.744674682617 496.461608886719 797.966979980469 819.004150390625 524.868408203125 148.768051147461 0 0 0 0 0 0 0 0 114.591278076172 230.604568481445 404.740417480469 400.008056640625 149.154037475586 0 0 0 0 0 0 0 0 102.017929077148 332.576171875 431.327087402344 395.180480957031 291.81103515625 179.464797973633 0 0 0 0 0 0 0 0 328.818298339844 432.372192382813 513.603515625 524.003845214844 455.190307617188 323.07763671875 0 0 0 0 0 0 0 0 0 500.822875976563 1250.17626953125 1691.61279296875 1446.947265625 741.710021972656 242.135177612305 131.856307983398 0 0 0 0 0 0 0 0 106.934600830078 416.481811523438 591.3037109375 471.31884765625 154.692947387695 0 0 0 0 0 0 0 0 58.2242736816406 451.217834472656 867.215209960938 952.283020019531 683.782348632813 327.990234375 53.9348297119141 0 0 0 0 0 0 0 0 112.282455444336 194.305465698242 247.864517211914 283.480651855469 251.062362670898 154.861434936523 0 0 0 0 0 0 0 0 0 2550.76782226563 7417.4248046875 11472.3154296875 11331.73046875 7126.333984375 2372.173828125 154.968887329 0 0 "
    "0 0 0 0 0 0 171.941879272461 235.122146606445 189.759658813477 86.6224975585938 0 0 0 0 0 0 0 0 161.515548706055 191.835342407227 263.086181640625 280.552551269531 146.46711730957 354.734191894531 1819.36071777344 4197.60791015625 5904.71484375 5515.97998046875 3378.09521484375 1216.07165527344 240.816360473633 160.06672668457 0 0 0 0 0 0 0 0 168.925979614258 417.149658203125 1732.84704589844 3627.1572265625 4610.03076171875 3790.7890625 1980.00671386719 757.338623046875 314.47314453125 0 0 0 0 0 0 0 0 0 151.324813842773 253.94270324707 329.051940917969 266.352722167969 111.870147705078 0 196.40153503418 1169.40258789063 2201.71215820313 2499.97778320313 1842.07995605469 847.819702148438 294.143676757813 154.02375793457 0 0 0 0 0 0 0 0 0 263.716003417969 663.424133300781 945.621276855469 900.181091308594 586.183349609375 242.737838745117 0 0 0 0 0 0 0 0 0 87.7988586425781 273.416259765625 275.446044921875 122.881698608398 0 0 0 0 0 0 0 0 139.006607055664 632.857299804688 1046.19299316406 1076.18725585938 721.538818359375 282.741760253906 33.4364013671875 0 92.9069519042969 201.903335571289 216.809951782227 66.0712280273438 0 0 0 0 0 0 0 0 0 262.810607910156 583.060974121094 697.79833984375 522.555419921875 181.537673950195 0 0 0 0 0 0 0 0 258.55615234375 289.532775878906 243.079086303711 173.991165161133 0 0 0 0 0 0 0 0 37.7136077880859 214.55876159668 243.370010375977 18.9360961914063 35.8999176025391 191.428115844727 166.77082824707 0 0 0 0 0 0 0 0 0 258.869323730469 651.99658203125 911.448181152344 810.898193359375 421.798156738281 54.3055572509766 0 0 0 0 0 0 0 0 60.1159057617188 292.62109375 475.166442871094 465.994323730469 265.969482421875 59.4075927734375 0 0 0 0 0 0 0 0 129.671829223633 203.134628295898 214.902053833008 142.065078735352 0 0 0 0 0 0 0 0 68.9898071289063 258.451477050781 349.82421875 288.4658203125 184.60481262207 0 0 0 0 0 0 0 0 60.4415130615234 757.99267578125 4146.55859375 8593.078125 10882.390625 9079.6171875 4740.5390625 1125.72338867 " 
    "0 0 0 0 0 0 0 0 0 102.086837768555 209.562088012695 285.004333496094 167.125106811523 0 0 0 0 0 0 0 0 153.054061889648 218.63932800293 227.450668334961 199.439254760742 191.222061157227 179.493179321289 0 0 0 0 0 0 0 0 136.84049987793 243.085250854492 175.279190063477 0 0 0 165.884048461914 1627.97961425781 4570.39892578125 7233.904296875 7538.84521484375 5242.4697265625 2183.01293945313 247.249221801758 94.0259094238281 0 0 0 0 0 0 0 0 0 708.975402832031 2684.54736328125 4892.7626953125 5664.70263671875 4346.48974609375 2153.0361328125 792.776916503906 328.806335449219 26.2600402832031 0 0 0 0 0 0 0 0 0 600.651245117188 1863.01184082031 2856.58935546875 2825.29223632813 1829.23559570313 678.683837890625 156.775985717773 0 0 0 0 0 0 0 0 177.269912719727 213.871047973633 146.206100463867 0 0 0 0 0 0 0 0 0 438.628295898438 1067.17602539063 1423.88037109375 1322.46948242188 846.637451171875 222.935501098633 8.62030029296875 0 0 0 0 0 0 0 0 1.40678405761719 204.166915893555 495.588256835938 711.029602050781 672.086486816406 440.136291503906 197.460708618164 25.0921783447266 0 0 0 0 0 0 0 0 181.639419555664 454.123840332031 630.59228515625 540.996643066406 248.280014038086 0 0 0 0 0 0 0 0 0 0 272.537475585938 507.36669921875 482.3701171875 228.514022827148 0 0 0 0 0 0 0 0 0 173.016799926758 282.362365722656 239.30632019043 89.6678161621094 0 0 0 0 0 0 0 0 163.693313598633 238.812973022461 181.945022583008 0 0 0 0 0 0 0 0 154.68586730957 251.716812133789 301.325927734375 285.520263671875 212.902420043945 125.696426391602 0 0 0 0 0 0 0 0 144.465744018555 280.485534667969 282.486389160156 171.469833374023 0 0 0 0 0 0 0 0 168.80158996582 1852.96484375 4451.087890625 6223.240234375 5698.3251953125 3317.40869140625 947.944641113281 0 72.4445648193359 222.517288208008 190.692306518555 8.54414367675781 0 0 0 0 0 0 0 0 173.518569946289 287.66455078125 315.665649414063 180.375747680664 0 0 0 0 0 0 0 0 22.9653015136719 377.313659667969 1943.11608886719 3810.626464843 4614.140625 "
    "3648.7470703125 1708.49145507813 216.385025024414 180.797805786133 220.440505981445 66.8912200927734 0 0 0 0 0 143.90119934082 216.902420043945 185.753768920898 98.3815460205078 0 0 0 0 0 0 0 0 162.759536743164 215.904861450195 208.337875366211 127.708084106445 0 0 0 0 0 0 0 0 105.314514160156 217.56315612793 204.984756469727 103.096450805664 1431.53564453125 2977.5546875 3651.64916992188 2931.84326171875 1398.70080566406 87.1452484130859 320.6357421875 384.557983398438 269.201110839844 237.787063598633 238.22102355957 131.059158325195 0 0 0 0 0 0 0 0 82.7467803955078 540.114013671875 1467.232421875 2395.43090820313 2641.54028320313 2010.16149902344 989.484558105469 192.628158569336 0 0 179.865524291992 275.410278320313 175.700149536133 0 0 0 0 0 0 0 0 59.9419708251953 485.762634277344 988.358093261719 1207.15466308594 963.307312011719 438.903381347656 31.6091766357422 0 0 0 0 0 47.9591827392578 196.635208129883 252.011154174805 211.016983032227 150.474960327148 0 0 0 0 0 0 0 0 168.648544311523 212.75212097168 246.239303588867 241.005111694336 180.050369262695 0 0 0 0 93.9449157714844 308.76171875 510.256713867188 547.370849609375 379.794067382813 126.207992553711 0 0 0 0 0 0 0 0 165.212295532227 203.172348022461 187.95915222168 180.575973510742 0 0 0 0 0 0 0 0 75.0355987548828 196.667404174805 286.693542480469 310.418090820313 283.288269042969 260.312194824219 292.165649414063 351.78125 356.774780273438 261.874694824219 112.601119995117 0 0 0 0 0 0 0 0 147.65412902832 199.247695922852 206.355667114258 137.159103393555 0 0 0 0 0 0 0 0 153.178085327148 250.377090454102 305.382019042969 294.765869140625 215.430770874023 81.4587097167969 0 0 0 0 0 0 0 0 89.8516693115234 217.64045715332 309.367736816406 283.979248046875 149.045394897461 0 0 0 182.38005065918 418.089721679688 1096.13757324219 1732.892578125 1712.91027832031 1019.67010498047 253.890274047852 63.1096954345703 0 0 0 0 0 0 0 0 146.927871704102 197.823593139648 450.705383300781 1247.59985351563 "
    "2147.16479492188 2419.29248046875 1796.34436035156 783.829040527344 106.181396484375 0 0 0 0 0 0 0 0 0 334.013916015625 997.858215332031 1538.47912597656 1550.04187011719 1073.02502441406 532.429992675781 248.089309692383 200.781692504883 213.394241333008 177.545181274414 0 0 0 0 0 0 0 0 26.6942443847656 209.29020690918 520.969909667969 869.404174804688 1070.1162109375 975.004333496094 655.297485351563 316.672058105469 99.7084808349609 0 0 0 0 0 0 0 0 79.5495910644531 288.576049804688 554.977966308594 746.154174804688 740.367309570313 521.067321777344 227.974136352539 72.0663757324219 0 0 0 0 0 0 0 0 171.190017700195 314.421569824219 429.333374023438 416.543640136719 251.908309936523 31.249267578125 0 0 0 0 0 0 0 0 180.657669067383 192.169876098633 162.963485717773 0 0 0 0 0 0 0 0 155.606674194336 333.596923828125 371.658142089844 244.003341674805 111.538848876953 0 0 0 55.3578186035156 199.379867553711 277.664733886719 246.347457885742 148.267105102539 0 0 0 0 0 0 0 0 90.9604797363281 198.196731567383 372.608276367188 566.121337890625 624.478515625 473.921447753906 201.671371459961 0 0 0 0 0 0 0 0 0 120.198684692383 400.147033691406 571.140441894531 478.692626953125 229.758438110352 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 152.600845336914 225.899429321289 240.899063110352 190.175918579102 0 0 0 0 0 0 0 0 225.349227905273 261.482971191406 145.197463989258 0 0 0 0 0 0 0 0 64.5845184326172 213.417953491211 267.813903808594 201.623031616211 117.913467407227 0 0 0 0 0 0 0 0 182.848587036133 203.188278198242 155.740859985352 0 0 0 0 0 0 0 0 184.153060913086 247.411849975586 282.429565429688 316.498046875 347.890441894531 314.713134765625 179.080673217773 0 0 0 0 0 0 0 0 115.904327392578 226.538375854492 215.979263305664 129.574813842773 0 0 0 0 0 0 0 0 129.243606567383 308.855651855469 363.072937011719 252.200698852539 36.5062561035156 0 0 0 0 0 0 0 0 168.485580444336 221.236099243164 203.256454467773 118.937698364258 0 0 0 0 0 0 0 0 135.065872192383 197.25260925293 "
    "164.043045043945 0 0 0 0 0 0 0 0 101.22346496582 199.961135864258 181.580459594727 0 0 0 0 0 0 0 0 171.627029418945 216.893325805664 165.188735961914 0 0 0 0 0 0 0 0 184.577438354492 315.924865722656 400.736938476563 401.748779296875 309.456359863281 177.526077270508 0 0 0 0 0 0 0 0 71.3968505859375 196.379440307617 317.622741699219 323.017578125 218.84977722168 108.977661132813 0 0 0 0 0 0 0 0 143.710311889648 248.819686889648 318.435913085938 338.807861328125 306.490661621094 239.977798461914 197.418716430664 128.426620483398 0 0 0 0 0 0 0 0 126.655654907227 226.479202270508 229.53288269043 179.628677368164 0 0 0 0 0 0 0 0 144.30647277832 214.861099243164 189.256454467773 0 0 0 0 0 0 0 0 188.085342407227 308.395935058594 374.08056640625 337.305053710938 193.459030151367 33.2561950683594 0 0 0 0 0 0 0 0 101.20735168457 200.764785766602 247.183944702148 206.08268737793 87.9416961669922 0 0 0 0 0 0 0 0 95.3595581054688 225.91584777832 248.077072143555 250.59260559082 257.277648925781 180.943740844727 0 0 0 0 0 0 0 0 155.655776977539 238.868362426758 250.283981323242 157.468978881836 0 0 0 0 0 0 0 0 165.849624633789 341.285217285156 449.087829589844 465.197448730469 414.669006347656 350.80908203125 287.216369628906 202.29280090332 102.295700073242 0 0 0 0 0 0 0 0 122.961654663086 216.524826049805 227.398483276367 197.743057250977 252.932815551758 368.044921875 412.497924804688 332.376770019531 189.94221496582 0 0 0 0 0 0 0 0 110.821487426758 205.431838989258 197.784744262695 165.351150512695 0 0 0 0 0 0 0 0 148.747482299805 197.384048461914 222.412368774414 130.84407043457 0 0 0 0 0 0 0 0 186.619369506836 231.119979858398 185.139663696289 0 0 0 0 0 0 0 0 129.717819213867 224.055252075195 180.142196655273 0 0 0 0 0 0 0 0 176.265243530273 223.66975402832 295.446105957031 361.572326660156 360.102111816406 244.047714233398 41.8561553955078 0 0 0 0 0 0 0 0 160.23698425293 238.57145690918 249.646987915039 191.794631958008 0 0 0 0 0 0 0 0 177.559341430664 308.058898925781 "
    "348.306823730469 288.753173828125 157.469802856445 0 0 50.9171905517578 233.195449829102 366.537780761719 333.827880859375 112.628784179688 0 0 0 0 0 0 0 0 146.29948425293 221.006973266602 185.588424682617 0 0 0 0 0 0 0 0 169.829788208008 298.886840820313 375.022705078125 349.165283203125 326.073608398438 321.16162109375 301.307739257813 280.400939941406 268.34130859375 250.299697875977 206.922592163086 161.804183959961 0 0 0 0 0 0 0 0 106.515991210938 216.509872436523 174.441055297852 0 47.4068908691406 197.185470581055 263.215942382813 352.870300292969 434.091491699219 407.799926757813 297.367797851563 209.839736938477 246.22785949707 378.100463867188 491.783874511719 505.840270996094 403.557006835938 229.298934936523 54.6394348144531 0 0 0 0 0 0 0 0 50.5400085449219 198.851058959961 280.1474609375 285.830627441406 210.564895629883 50.8290405273438 0 0 0 0 0 170.184860229492 335.466613769531 475.362731933594 547.797119140625 496.642517089844 292.609191894531 4.42018127441406 0 0 0 0 0 0 0 0 386.298461914063 549.150512695313 612.910278320313 599.075317382813 479.97314453125 260.072143554688 0 0 0 0 0 0 0 0 157.101547241211 216.543563842773 210.621841430664 151.346878051758 0 0 0 0 0 0 0 0 163.830764770508 225.50910949707 155.86100769043 0 0 0 0 0 0 0 0",

     "300.000066203793 300.000611626572 300.001157051333 300.001702478078 300.057892033313 300.058437690186 300.058983325233 300.059528962264 300.06007460128 300.06062024228 300.061165885264 300.061711530233 300.062257177186 300.062802826123 300.063348477046 300.063894129952 300.064439784843 300.064985441719 300.065531100579 300.066076761424 300.066622424263 301.05533837009 301.055887660805 301.056436929468 301.056986200136 301.057535472809 301.058084747485 301.058634024166 301.059183302851 301.059732583541 301.060281866235 301.060831150933 301.061380437635 301.061929726342 301.062479017053 301.063028309769 301.063577604489 301.064126901211 301.064676199938 311.867909300619 311.868498757012 311.869088211176 311.869677645283 311.870267081618 311.870856520182 311.871445960974 311.872035403993 311.872624849241 311.873214296717 311.873803746421 311.874393198353 311.874982652514 311.875572108902 311.876161567519 311.876751028364 311.877340491437 311.877929956739 311.878519424268 311.879108894026 311.879698366013 311.880287840227 311.88087731667 311.881466795341 311.882056276241 311.882645759373 311.883235244734 315.73053532575 315.731139474286 315.73174362051 315.732347745926 315.732951873654 315.733556003694 315.734160136047 315.734764270711 315.735368407687 315.735972546974 315.736576688574 315.737180832486 315.73778497871 315.738389127246 315.738993278088 315.739597431241 316.900199279936 316.900807913163 316.901416544052 316.902025153901 316.902633766087 316.90324238061 316.903850997471 316.90445961667 316.905068238207 316.905676862081 316.906285488293 316.906894116843 316.907502747731 316.908111380957 316.90872001652 316.909328654421 316.909937294661 316.910545937239 326.292301361357 326.292946606739 326.293591849569 326.294237069432 326.294882291847 326.295527516814 326.296172744332 326.296817974402 326.297463207024 326.298108442198 326.298753679923 326.299398920201 326.30004416303 326.300689408412 326.301334656346 327.073585511089 327.074233850235 327.074882186811 "
    "327.075530500256 327.076178816272 327.076827134858 327.077475456014 327.07812377974 327.078772106036 327.079420434903 327.080068766339 327.080717100346 327.081365436923 327.082013776071 327.082662117789 327.083310462077 327.083958808935 327.084607158362 327.085255510359 341.005699660892 341.006404411558 341.007109159311 341.007813880848 341.008518605298 341.00922333266 341.009928062936 341.010632796124 341.011337532225 341.012042271238 341.012747013165 341.013451758004 341.014156505757 341.014861256422 341.01556601 341.016270766491 341.016975525895 341.017680288212 341.018385053442 341.019089821585 341.019794592642 341.020499366611 341.021204143493 341.021908923288 341.022613705997 341.023318491618 341.024023280153 341.024728071601 341.025432865961 341.026137663234 342.012174618732 342.01288353577 342.01359244987 342.014301337525 342.015010228119 342.015719121651 342.016428018122 342.017136917532 342.01784581988 342.018554725167 342.019263633392 342.019972544557 342.02068145866 342.021390375702 342.022099295682 342.022808218602 342.02351714446 342.024226073253 342.024935004984 342.872076371417 342.872788857813 342.873501341248 342.874213798035 342.874926257782 342.87563872049 342.876351186159 342.877063654789 342.87777612638 342.878488600932 342.879201078445 342.879913558918 342.880626042353 342.881338528749 342.882051018106 342.882763510424 344.971618706329 344.972339945342 344.97306118134 344.9737823902 344.974503602076 344.975224816967 344.975946034874 344.976667255797 344.977388479735 344.978109706689 344.978830936658 344.979552169644 344.980273405644 344.980994644661 344.981715886693 344.982437131737 344.983158379796 355.062407256743 355.063171308061 355.063935356091 355.064699374529 355.065463396255 355.066227421269 355.066991449572 355.067755481162 355.06851951604 355.069283554207 355.070047595661 355.070811640404 355.071575688435 355.072339739754 355.073103794361 355.073867852257 355.074631913441 355.075395977913 355.076160045673 355.076924116722 "
    "355.077688191059 355.078452268685 355.079216349597 355.079980433797 356.063784873266 356.064553240471 356.065321571195 356.066089905234 356.06685824259 356.067626583261 356.068394927249 356.069163274552 356.069931625172 356.070699979107 356.071468336359 356.072236696926 356.07300506081 356.073773428009 356.074541798525 356.075310172357 356.076078549505 356.076846929969 356.07761531375 356.078383700846 356.079152091259 356.079920484988 356.080688882034 356.0814572824 356.082225686083 357.061554879912 357.062327559534 357.063100202372 357.063872848555 357.064645498081 357.065418150951 357.066190807165 357.066963466723 357.067736129625 357.068508795871 357.069281465461 357.070054138395 357.070826814673 357.071599494295 357.072372177261 357.073144863571 357.073917553225 357.074690246224 357.075462942566 357.076235642253 357.077008345284 357.077781051659 357.078553761379 357.079326474442 357.08009919085 357.080871910601 357.081644633697 359.022402165402 359.023183355092 359.023964507385 359.024745663078 359.02552682217 359.026307984661 359.027089150551 359.027870319841 359.028651492531 359.029432668619 359.030213848107 359.030995030994 359.031776217281 359.032557406967 359.033338600053 359.034119796538 359.034900996422 359.035682199706 359.036463406393 360.02270642572 360.023491974674 360.024277485921 360.025063000597 360.0258485187 360.02663404023 360.027419565189 360.028205093575 360.028990625389 360.029776160632 360.030561699301 360.031347241399 360.032132786925 360.032918335879 360.03370388826 360.03448944407 360.035275003295 361.019911590167 361.020701496954 361.021491400285 361.02228127251 361.023071148191 361.023861027329 361.024650909923 361.025440795974 361.026230685481 361.027020578444 361.027810474864 361.02860037474 361.029390278072 361.030180184861 361.030970095107 361.031760008809 361.032549925965 361.033339846577 371.094855950121 371.095690561049 371.096525130684 371.097359704072 371.098194281215 371.099028862111 371.099863446762 371.100698035166 "
    "371.101532627324 371.102367223236 371.103201822902 371.104036426322 371.104871033497 371.105705644425 371.106540259107 371.107374877543 371.108209499734 371.109044125678 371.109878755377 371.11071338883 371.111548026036 371.112382666995 372.076388760396 372.077227792322 372.078066820464 372.078905814551 372.079744812421 372.080583814075 372.081422819513 372.082261828735 372.083100841741 372.08393985853 372.084778879103 372.08561790346 372.086456931601 372.087295963526 372.08813499923 372.088974038718 372.09484737572 372.095686490895 372.096525564444 372.097364641778 372.098203722896 372.099042807799 372.099881896485 372.100720988956 372.101560085211 372.102399185251 372.103238289075 372.104077396683 372.104916508076 372.105755623254 372.106594742216 372.107433864962 372.108272991493 372.109112121811 372.109951255914 373.074936157977 373.075779699523 373.076623237254 373.077466740653 373.078310247866 373.079153758894 373.079997273735 373.080840792391 373.081684314862 373.082527841147 373.083371371246 373.084214905159 373.085058442887 373.08590198443 373.086745529787 373.087589078956 373.088432631939 373.099399083966 373.100242736138 373.101086384495 373.101929998517 373.102773616354 373.103617238007 373.104460863474 373.105304492756 373.106148125853 373.106991762765 373.107835403493 373.108679048035 373.109522696393 373.110366348566 373.111210004555 373.112053664363 373.112897327987 415.029499377631 415.030543316388 415.031587197383 415.032631083628 415.033674975125 415.034718871873 415.035762773872 415.036806681123 415.037850593625 415.038894511378 415.039938434383 415.040982362639 415.042026296147 415.043070234906 415.044114178917 415.045158128179 415.046202082693 415.047246042459 415.048290007473 415.049333977738 416.002577466261 416.003626306154 416.004675140758 416.005723927765 416.006772720059 416.007821517642 416.008870320513 416.009919128672 416.01096794212 416.012016760856 416.01306558488 416.014114414193 416.015163248794 416.016212088684 416.01726093386 "
    "416.018309784324 416.028798463515 416.029847435635 416.030896402465 416.031945321688 416.032994246201 416.034043176002 416.035092111093 416.036141051473 416.037189997143 416.038238948102 416.03928790435 416.040336865888 416.041385832715 416.042434804832 416.043483782239 416.044532764935 416.04558175292 416.046630746196 416.047679744761 416.048728748618 416.049777757765 417.026597695644 417.027651705639 417.028705657034 417.029759613757 417.030813575807 417.031867543184 417.032921515889 417.033975493922 417.035029477282 417.036083465969 417.037137459984 417.038191459327 417.039245463997 417.040299473995 417.041353489321 417.04240750997 426.355773178261 426.356874875168 426.357976566382 426.359078206359 426.360179852029 426.361281503392 426.362383160449 426.363484823198 426.36458649164 426.365688165776 426.366789845604 426.367891531126 426.368993222341 426.370094919248 426.371196621848 428.93364758309 428.934762643092 428.935877697296 428.936992699323 428.938107707146 428.939222720767 428.940337740184 428.941452765398 428.94256779641 428.943682833218 428.944797875823 428.945912924226 428.947027978426 428.948143038428 428.949258104228 429.080876455648 429.081992281276 429.083108101101 429.0842238687 429.085339642101 429.086455421305 429.087571206312 429.088686997122 429.089802793735 429.090918596151 429.09203440437 429.093150218392 429.094266038217 429.095381863845 429.096497695277 429.097613532512 429.09872937555 429.099845224392 429.100961079037 429.102076939486 429.103192805742 429.132207237776 429.133323330395 429.134439417209 429.135555451783 429.136671492162 429.137787538345 429.138903590334 429.140019648128 429.141135711726 429.14225178113 429.143367856339 429.144483937353 429.145600024173 429.146716116797 429.147832215231 429.148948319471 429.848770617062 429.849890440213 429.85101025753 429.852130022341 429.853249792985 429.854369569464 429.855489351777 429.856609139924 429.857728933905 429.858848733721 429.859968539371 429.861088350855 429.862208168173 "
    "429.863327991326 429.864447820313 429.865567655135 429.866687495792 429.867807342283 429.868927194608 429.870047052768 429.871166916764 429.872286786593 429.873406662258 429.874526543758 429.875646431092 429.876766324261 429.877886223266 429.879006128111 429.880126038792 430.080684027207 430.081805059062 430.082926026641 430.084047000064 430.08516797933 430.086288964439 430.087409955392 430.088530952189 430.089651954829 430.090772963313 430.091893977641 430.093014997813 430.094136023828 430.095257055687 430.09637809339 430.097499136937 430.098620186328 430.099741241563 430.100862302643 430.101983369566 430.103104442333 431.077278491348 431.078404724764 431.079530893455 431.08065706803 431.081783248489 431.082909434832 431.08403562706 431.085161825172 431.086288029168 431.087414239049 431.088540454814 431.089666676463 431.090792903997 431.091919137416 431.093045376719 431.094171621907 431.09529787298 431.096424129938 431.09755039278 431.098676661507 431.099802936119 431.100929216617 431.102055503 432.077370900075 432.078502365406 432.079633824813 432.080765230898 432.081896642908 432.083028060844 432.084159484704 432.085290914491 432.086422350202 432.087553791839 432.088685239402 432.08981669289 432.090948152304 432.092079617643 432.093211088908 432.094342566101 432.09547404922 444.61606065115 444.617258663358 444.618456682022 444.619654707142 444.620852738719 444.622050776751 444.62324882124 444.624446872186 444.625644929587 444.626842993445 444.62804106376 444.629239140531 444.630437223759 445.108988082791 445.110188830584 445.111389571898 445.112590254911 445.113790944402 445.114991640371 445.116192342817 445.117393051741 445.118593767143 445.119794489023 445.120995217382 445.122195952218 445.123396693532 445.124597441324 445.125798195595 445.126998956343 445.128199723571 445.129400497276 445.13060127746 445.131802064126 445.133002857271 446.0896875442 446.09089358916 446.092099627601 446.093305607359 446.094511593638 446.095717586437 446.096923585757 "
    "446.098129591598 446.099335603959 446.100541622841 446.101747648245 446.102953680169 446.104159718614 446.10536576358 446.106571815068 446.107777873076 446.108983937606 446.110190008657 446.111396086229 446.112602170323 446.113808260938 446.115014358075 446.116220461733 446.117426571913 446.118632688614 446.119838811837 446.121044941582 446.122251077849 446.123457220638 446.124663369948 446.12586952578 446.127075688135 446.128281857011 446.12948803241 446.130694214331 446.131900402774 446.133106597739 446.13431279922 446.135519007222 447.090465450435 447.091676913048 447.092888369096 447.09409976606 447.095311169589 447.096522579682 447.09773399634 447.098945419563 447.100156849351 447.101368285703 447.10257972862 447.103791178103 447.10500263415 447.106214096762 447.10742556594 447.108637041682 447.10984852399 447.111060012863 447.112271508302 447.113483010306 447.114694518875 447.115906034009 447.11711755571 447.118329083975 447.119540618807 447.120752160204 447.121963708167 447.123175262696 447.12438682379 447.125598391451 447.126809965677 447.128021546469 447.129233133828 447.130444727752 447.131656328243 447.132867935294 447.134079548911 449.792325957731 449.793552107325 449.794778250235 449.796004332987 449.797230422424 449.798456518544 449.799682621349 449.800908730839 449.802134847013 449.803360969872 449.804587099415 449.805813235643 449.807039378556 449.808265528153 449.809491684437 449.810717847406 476.28917675577 476.290551628645 476.291926493584 476.293301287096 476.294676088545 476.296050897931 476.297425715253 476.298800540512 476.300175373707 476.30155021484 476.30292506391 476.304299920917 476.305674785861 476.307049658742 476.308424539565 476.309799428326 487.8125351623 487.813977369941 487.815419569054 487.81686169142 487.818303822312 487.819745961732 487.821188109678 487.822630266151 487.824072431152 487.825514604679 487.826956786733 487.828398977315 487.829841176424 487.831283384065 487.832725600234 489.045757246253 489.047206755368 "
    "489.048656169973 489.050105593169 489.051555024957 489.053004465336 489.054453914307 489.05590337187 489.057352838025 489.058802312771 489.06025179611 489.06170128804 489.063150788563 489.064600297678 489.066049815385 489.067499341685 489.068948876582 494.494675265302 494.496157256269 494.497639238354 494.499121140501 494.500603051529 494.50208497144 494.503566900233 494.505048837908 494.506530784465 494.508012739904 494.509494704226 494.510976677431 494.512458659517 494.513940650484 494.515422650332 503.094316385189 503.095850372279 503.097384350016 503.098918243574 503.100452146485 503.10198605875 503.103519980368 503.10505391134 503.106587851665 503.108121801345 503.109655760378 503.111189728765 503.112723706507 503.114257693603 503.115791690052 503.117325695857 503.118859711015 503.120393735528 503.121927769396 503.123461812619 503.124995865196 503.126529927119 503.128063998395 504.054815517436 504.056355367669 504.057895208494 504.059434964655 504.060974730222 504.062514505197 504.064054289579 504.065594083369 504.067133886566 504.06867369917 504.070213521182 504.071753352602 504.073293193429 504.074833043661 504.076372903301 504.094851745874 504.09639184074 504.097931926196 504.099471926969 504.101011937151 504.102551956742 504.104091985743 504.105632024154 504.107172071974 504.108712129204 504.110252195844 504.111792271893 504.113332357353 504.114872452223 504.116412556503 504.117952670193 504.119492793294 504.121032925805 504.122573067726 504.124113219059 504.125653379799 504.13335411762 504.134894447771 504.136434768509 504.137975004541 504.139515249984 504.141055504838 504.142595769105 504.144136042783 504.145676325873 504.147216618374 504.148756920288 504.150297231614 504.151837552352 504.153377882502 504.154918222058 504.156458571024 505.091644206301 505.093190398161 505.094736580555 505.096282677762 505.097828784435 505.099374900573 505.100921026176 505.102467161245 505.104013305779 505.105559459779 505.107105623245 505.108651796177 505.110197978574 "
    "505.111744170438 505.113290371768 505.114836582564 505.116382802826 505.117929032555 505.11947527175 505.121021520412 505.12256777854 505.124114046132 505.12566032319 506.092386573466 506.0939388986 506.095491214212 506.097043444127 506.098595683563 506.100147932522 506.101700191001 506.103252459003 506.104804736527 506.106357023573 506.107909320141 506.109461626231 506.111013941844 506.112566266978 506.114118601636 506.115670945814 506.117223299513 517.62453635348 517.626160232046 517.627784100423 517.62940787711 517.631031663984 517.632655461045 517.634279268294 517.635903085731 517.637526913356 517.639150751169 517.64077459917 517.642398457359 517.644022325736 517.645646204301 517.647270093055 519.11454547401 519.11617871524 519.117811946194 519.11944508466 519.121078233402 519.122711392419 519.124344561713 519.125977741282 519.127610931128 519.129244131249 519.130877341647 519.132510562322 519.134143793272 519.1357770345 519.137410286004 519.139043547785 519.140676819843 519.142310102177 519.143943394789 519.145576697678 519.147210010844 519.148843334287 519.150476668008 519.152110012007 519.153743366283 519.155376730835 520.104462817426 520.106102293798 520.107741759837 520.109381132867 520.111020516231 520.11265990993 520.114299313963 520.115938728332 520.117578153035 520.119217588074 520.120857033448 520.122496489157 520.124135955201 520.125775431581 520.1274149183 520.129054415356 520.130693922735 520.132333440458 520.133972968517 520.135612506911 520.137252055643 520.13889161471 520.140531184113 520.142170763854 520.14381035393 520.145449954343 520.147089565093 520.14872918618 520.150368817604 520.152008459365 520.153648111463 520.155287773898 520.15692744667 520.15856712978 521.126139890057 521.127785814089 521.129431623767 521.131077443839 521.132723274308 521.134369115172 521.136014966432 521.137660828088 521.13930670014 521.140952582588 521.142598475432 521.144244378673 521.14589029231 521.147536216343 521.149182150772 521.150828095596 531.111277151579 "
    "531.112986756559 531.114696350534 531.11640584546 531.118115351391 531.119824868327 531.121534396267 531.123243935212 531.124953485163 531.126663046119 531.12837261808 531.130082201046 531.131791795019 531.1335014 531.135211015986 531.17624485941 531.177954882673 531.179664894929 531.181374808109 531.183084732298 531.184794667495 531.186504613701 531.188214570917 531.189924539141 531.191634518375 531.193344508618 531.195054509871 531.196764522133 531.198474545405 531.20018457969 531.201894624984 539.789589969187 539.791355902538 539.793121824335 539.79488764215 539.796653471517 539.798419312438 539.800185164913 539.80195102894 539.803716904521 539.805482791656 539.807248690344 539.809014600586 539.810780522383 539.812546455734 539.814312400639 544.653632193427 544.655430097132 544.657227988968 544.659025773986 544.660823570872 544.662621379626 544.664419200249 544.66621703274 544.6680148771 544.669812733329 544.671610601426 544.673408481392 544.675206373228 544.677004276933 544.678802192507 544.68060011995 544.682398059264 544.684196010447 544.685993973499 544.687791948422 544.689589935214 544.691387933877 544.693185944405 544.694983966802 564.059258060445 564.06118636825 564.063114662872 564.065042838848 564.066971028006 564.068899230347 564.07082744587 564.072755674577 564.074683916467 564.076612171539 564.078540439795 564.080468721235 564.082397015858 564.084325323664 564.086253644655 564.088181978832 564.090110326193 577.109008739641 577.111027308003 577.113045862246 577.115064289413 577.1170827307 577.119101186105 577.12111965563 577.123138139273 577.125156637036 577.127175148919 577.129193674921 577.131212215043 577.133230769285 577.135249337647 577.137267920129 577.139286516732 577.141305127455 577.143323752299 577.145342391261 577.147361044343 578.091617372157 578.093642820461 578.095668254573 578.09769356096 578.099718881538 578.101744216308 578.103769565269 578.105794928421 578.107820305765 578.1098456973 578.111871103028 578.113896522947 578.115921957059 "
    "578.117947405363 578.119972867859 578.121998344549 578.124023835431 578.126049340506 578.128074859774 578.130100393235 578.13212594089 578.134151502738 578.13617707878 578.138202669016 578.140228273445 578.142253892069 578.144279524888 578.1463051719 578.148330833106 578.150356508506 579.108062150497 579.110094727971 579.112127291178 579.114159725986 579.116192175059 579.118224638399 579.120257116005 579.122289607877 579.124322114016 579.126354634422 579.128387169095 579.130419718034 579.132452281241 579.134484858716 579.136517450457 579.138550056467 579.140582676744 579.142615311289 579.144647960104 579.146680623187 593.142571534721 593.144703828301 593.146836106552 593.148968246848 593.151100402472 593.153232573424 593.155364759706 593.157496961317 593.159629178256 593.161761410526 593.163893658125 593.166025921053 593.168158199311 593.1702904929 593.172422801818 593.174555126067 593.176687465641 593.178819820543 594.330394200968 594.332535043722 594.334675871054 594.336816559592 594.338957263551 594.341097982931 594.343238717732 594.345379467954 594.347520233598 594.349661014664 594.351801811151 594.35394262306 594.356083450392 594.358224293146 594.360365151322 594.362506024921 602.987309886737 602.989513552885 602.991717202929 602.993920708033 602.996124229242 602.998327766555 603.000531319973 603.002734889497 603.004938475125 603.007142076859 603.009345694699 603.011549328644 603.013752978696 603.015956644853 603.018160327117 603.020364025487 603.022567739964 603.024771470548 603.026975217238 603.029178980037 603.031382758944 647.648714215036 647.65125642497 647.653798614949 647.656340625328 647.65888265566 647.661424705948 647.66396677619 647.666508866388 647.669050976542 647.671593106651 647.674135256716 647.676677426738 647.679219616716 647.681761826651 647.684304056543 647.686846306392 647.689388576198 647.691930865962 647.694473175684 647.697015505364 647.699557855003 647.702100224594 647.704642614142 651.124332887163 651.126902457291 651.129472007141 "
    "651.132041374488 651.134610762114 651.137180170017 651.139749598198 651.142319046658 651.144888515396 651.147458004413 651.150027513709 651.152597043284 651.155166593139 651.157736163274 651.160305753689 651.162875364383 651.165444995359 651.168014646615 651.17058431815 652.127911018382 652.130488515969 652.133065789459 652.135643083321 652.138220397554 652.140797732159 652.143375087136 652.145952462485 652.148529858207 652.151107274301 652.153684710768 652.156262167609 652.158839644823 652.16141714241 652.163994660372 652.166572198708 652.169149757418 652.171727336504 652.589563880196 652.592145028563 652.594726156514 652.597307100729 652.599888065358 652.602469050403 652.605050055862 652.607631081738 652.610212128029 652.612793194736 652.615374281859 652.617955389399 652.620536517356 652.623117665722 652.625698834504 653.124246691635 653.126832071549 653.129417226335 653.132002401586 653.134587597302 653.137172813482 653.139758050129 653.142343307241 653.14492858482 653.147513882864 653.150099201375 653.152684540353 653.155269899798 653.157855279709 653.160440680089 653.163026100936 653.165611542249 653.168197004028 660.917219227388 660.919866675166 660.922514101737 660.925161337446 660.927808594361 660.930455872483 660.933103171812 660.935750492348 660.938397834091 660.941045197042 660.943692581201 660.946339986568 660.948987413144 660.951634860928 660.954282329921 660.956929820121 660.959577331529 660.978110038611 660.980757974266 660.983405888706 660.986053612226 660.988701356959 660.991349122903 660.993996910061 660.996644718431 660.999292548015 661.001940398812 661.004588270823 661.007236164048 661.009884078488 661.012532014142 661.015179971004 661.01782794908 664.405995189996 664.408670663059 664.411346114577 664.414021372197 664.41669665136 664.419371952069 664.422047274321 664.424722618119 664.427397983461 664.430073370349 664.432748778782 664.435424208761 664.438099660286 664.440775133357 664.443450627975 664.44612614414 664.448801681852 664.451477241112 "
    "664.454152821919 664.456828424273 664.459504048176 664.462179693628 664.464855360628 664.467531049175 667.156745656581 667.159443330433 667.162140764336 667.164838220052 667.16753569758 667.170233196922 667.172930718076 667.175628261044 667.178325825826 667.181023412421 667.183721020831 667.186418651055 667.189116303095 667.191813976949 667.194511672619 667.197209390104 667.199907129405 667.202604890514 668.140046591184 668.142752223328 668.145457833561 668.148163246605 668.150868681559 668.153574138422 668.156279617196 668.158985117879 668.161690640472 668.164396184977 668.167101751392 668.169807339718 668.172512949956 668.175218582105 668.177924236166 668.180629912139 668.183335610025 668.186041329824 668.188747071536 668.19145283516 668.194158620699 668.196864428151 668.199570257517 668.202276108794 670.153471607066 670.156193571329 670.158915513485 670.161637256666 670.164359021956 670.167080809353 670.16980261886 670.172524450475 670.175246304198 670.177968180032 670.180690077974 670.183411998027 670.186133940189 670.188855904462 670.191577890846 670.194299899327 670.197021929917 677.266460681704 677.269240737313 677.272020770102 677.274800597507 677.277580447732 677.280360320776 677.283140216641 677.285920135325 677.28870007683 677.291480041156 677.294260028303 677.297040038272 677.299820071062 677.302600126674 677.305380205108 677.308160306364 677.310940430444 677.313720577346 677.316500747072 677.319280939622 677.322061154995 677.324841393193 677.327621654214 677.330401938061 677.333182244733 677.33596257423 677.338742926553 677.3415233017 684.180117968355 684.182955075248 684.185792158615 684.188629030244 684.191465925398 684.194302844078 684.197139786283 684.199976752015 684.202813741274 684.205650754059 684.208487790372 684.211324850212 684.21416193358 684.216999040475 684.2198361709 684.222673324852 684.225510502334 684.228347703342 684.231184927879 685.296805037587 685.299651413708 685.302497766186 685.305343905889 685.308190069232 685.311036256217 "
    "685.313882466843 685.316728701111 685.319574959021 685.322421240572 685.325267545767 685.328113874604 685.330960227085 685.333806603209 685.336653002977 685.339499426388 685.342345873435 685.345192344145 685.34803883849 685.350885356481 685.353731898117 685.356578463399 685.359425052328 685.362271664902 685.365118301123 685.367964960991 685.370811644507 685.37365835167 685.376505082481 685.379351836937 685.38219861504 686.160254003255 686.163107556924 686.165961086862 686.168814403222 686.171667743312 686.174521107133 686.177374494685 686.180227905968 686.183081340982 686.185934799728 686.188788282207 686.191641788417 686.19449531836 686.197348872036 686.200202449442 686.20305605058 699.458161318452 699.461126554625 699.464091765658 699.467056750447 699.470021760373 699.472986795436 699.475951855637 699.478916940975 699.481882051452 699.484847187067 699.487812347821 699.490777533714 699.493742744746 699.496707980919 699.499673242231 699.502638528684 699.505603840277 699.508569177012 699.511534538887 699.514499925905 699.517465338063 699.520430775363 707.534894554911 707.537928670089 707.540962759248 707.54399661424 707.54703049525 707.550064402278 707.553098335324 707.556132294389 707.559166279473 707.562200290576 707.565234327699 707.568268390842 707.571302480006 707.574336595191 707.577370736396 707.580404903623 707.583439096872 707.586473316143 707.589507561437 707.592541832753 707.595576130092 707.59861045345 707.601644802831 712.253358999635 712.256433401729 712.259507830364 712.26258228554 712.265656767258 712.268731275519 712.271805810321 712.274880371667 712.277954959555 712.281029573987 712.284104214963 714.631626985655 714.634722275108 714.637817537752 714.640912559113 714.644007607282 714.647102682261 714.650197784048 714.653292912646 714.656388068053 714.65948325027 714.662578459298 714.665673695137 714.668768957787 714.671864247249 714.674959563515 714.678054906591 725.139615581024 725.142802571441 725.145989253758 725.149175964084 725.152362702418 "
    "725.155549468761 725.158736263113 725.161923085476 725.165109935848 725.168296814231 725.171483720624 725.174670655029 725.177857617445 725.181044607873 725.184231626314 725.187418672767 725.190605747233 725.193792849713 725.196979980206 725.200167138713 725.203354325232 726.141603257488 726.144799061961 726.147994557046 726.151190080255 726.15438563159 726.15758121105 726.160776818635 726.163972454346 726.167168118184 726.170363810149 726.17355953024 726.176755278459 726.179951054806 726.183146859281 726.186342691885 726.189538552617 726.192734441476 726.195930358462 727.127138243687 727.130342729352 727.133547186777 727.136751390037 727.139955621536 727.143159881275 727.146364169255 727.149568485475 727.152772829936 727.155977202638 727.159181603583 727.162386032769 727.165590490198 727.16879497587 727.171999489785 727.175204031944 727.178408602347 727.181613200995 727.184817827887 727.188022483024 727.191227166403 727.194431878026 728.13784295644 728.141056357237 728.144269729676 728.147482846893 728.150695992466 728.153909166398 728.157122368687 728.160335599336 728.163548858343 728.16676214571 728.169975461436 728.173188805523 728.17640217797 728.179615578778 728.182829007947 728.186042465468 728.189255951349 728.616901834271 728.620119465045 728.623337067404 728.626554414027 728.629771789064 728.632989192515 728.63620662438 728.639424084659 728.642641573354 728.645859090464 728.64907663599 728.652294209931 728.65551181229 728.658729443065 728.66194710225 728.66516478985 739.57317102729 739.576486158636 739.579801260267 739.583116094462 739.586430958371 739.589745851995 739.593060775335 739.596375728391 739.599690711162 739.603005723651 739.606320765856 739.609635837779 739.61295093942 739.616266070766 739.619581231827 741.17101553099 741.174345003278 741.177674146565 741.18100331976 741.184332522862 741.187661755872 741.190991018791 741.194320311618 741.197649634355 741.200978987002 741.204308369558 741.207637782025 741.210967224403 741.214296696693 "
    "741.217626198894 741.220955731007 741.224285293032 741.227614884965 741.230944506809 742.06095178994 742.064289262981 742.067626706004 742.070963878878 742.074301081766 742.077638314671 742.080975577592 742.08431287053 742.087650193485 742.090987546457 742.094324929448 742.097662342457 742.100999785484 742.104337258531 742.107674761597 742.111012294683 742.11434985779 742.117687450917 742.121025074066 742.124362727236 742.127700410428 742.131038123643 742.13437586688 742.137713640141 742.141051443425 742.144389276727 742.147727140052 742.167754289952 742.171092723818 742.174431127655 742.177769261226 742.181107424826 742.184445618454 742.187783842111 742.191122095798 742.194460379515 742.197798693263 742.201137037042 742.204475410852 742.207813814694 742.211152248568 742.214490712474 742.217829206413 742.221167730386 742.224506284392 742.227844868433 742.231183482498 742.234522126595 743.140402346922 743.143749537385 743.1470966977 743.150443586686 743.153790505819 743.157137455098 743.160484434525 743.1638314441 743.167178483823 743.170525553695 743.173872653716 743.177219783887 743.180566944208 743.183914134679 743.187261355301 743.190608606074 743.193955886998 743.197303198075 743.200650539304 743.203997910686 743.20734531222 743.210692743909 743.214040205752 743.217387697749 743.220735219901 743.224082772208 743.227430354671 743.23077796729 743.234125610057 743.237473282979 744.169296683152 744.172653149071 744.176009584717 744.179365747906 744.182721941368 744.186078165103 744.18943441911 744.192790703391 744.196147017945 744.199503362773 744.202859737876 744.206216143254 744.209572578908 744.212929044837 744.216285541042 744.219642067524 744.222998624283 744.226355211311 758.198926754719 758.202410978174 758.205894849435 758.209378752713 758.212862688007 758.216346655318 758.219830654647 758.223314685994 758.226798749359 758.230282844744 758.233766972148 758.237251131571 758.240735323015 758.24421954648 758.247703801965 758.251188089473 758.254672409002 "
    "758.25815676055 758.26164114412 759.196610966793 759.200104366326 759.203597733713 759.207090811794 759.210583922019 759.214077064387 759.2175702389 759.221063445557 759.22455668436 759.228049955308 759.231543258401 759.235036593642 759.238529961029 759.242023360563 759.245516792245 759.249010256075 759.252503752057 759.255997280187 760.193422394897 760.196924974524 760.200427521877 760.203929778783 760.207432067959 760.210934389405 760.214436743123 760.217939129111 760.221441547372 760.224943997905 760.228446480711 760.231948995789 760.235451543142 760.238954122768 760.24245673467 760.245959378841 760.249462055285 760.309011783251 760.312515428169 760.316019040799 760.319522362853 760.323025717192 760.326529103815 760.330032522725 760.33353597392 760.337039457402 760.340542973171 760.344046521228 760.347550101572 760.351053714205 760.354557359126 760.358061036338 760.361564745838 760.365068487616 760.368572261681 777.182632662569 777.186293556055 777.189954415057 777.193614963706 777.197275546837 777.200936164451 777.204596816548 777.208257503129 777.211918224194 777.215578979744 777.219239769779 777.2229005943 777.226561453308 777.230222346802 777.233883274784 777.237544237253 777.241205234203 777.24486626564 799.156619815419 799.160490663856 799.164361099883 799.1682315734 799.172102084408 799.175972632907 799.179843218898 799.183713842382 799.187584503358 799.191455201828 799.195325937792 799.19919671125 799.203067522204 799.206938370653 799.210809256599 799.214680180041 799.21855114098 799.222422139414 799.226293175344 800.156426697814 800.160307238369 800.16418774129 800.168067905512 800.171948107365 800.175828346849 800.179708623967 800.183588938718 800.187469291103 800.191349681123 800.195230108777 800.199110574067 800.202991076993 800.206871617555 800.210752195754 800.214632811577 800.218513465034 801.150959244253 801.15484943781 801.158739593593 801.162629409414 801.166519263006 801.170409154372 801.174299083511 801.178189050424 801.182079055111 "
    "801.185969097572 801.18985917781 801.193749295823 801.197639451613 801.20152964518 801.205419876525 801.209310145647 801.213200452549 801.217090797225 801.220981179677 810.047211086567 810.051188161235 810.055165196855 810.059141881054 810.063118604297 810.067095366586 810.07107216792 810.0750490083 810.079025887728 810.083002806202 810.086979763725 810.090956760296 810.094933795916 810.098910870585 810.102887984305 810.106865137076 810.110842328887 810.114819559745 815.185536844356 815.189564537267 815.19359179245 815.197619087424 815.20164642219 815.205673796749 815.209701211101 815.213728665248 815.217756159189 815.221783692925 815.225811266457 815.229838879786 815.233866532911 815.237894225833 815.241921958555 815.245949731074 815.249977543393 815.254005395497 815.258033287397 815.386945970921 815.390975654469 815.395005298192 815.3990345835 815.40306390863 815.407093273582 815.411122678358 815.415152122956 815.419181607379 815.423211131626 815.427240695699 815.431270299597 815.435299943322 815.439329626874 815.443359350241 815.447389113433 816.161284292178 816.165321633463 816.169358934812 816.17339587673 816.177432858584 816.181469880374 816.1855069421 816.189544043764 816.193581185365 816.197618366904 816.201655588382 816.2056928498 816.209730151157 816.213767492455 816.217804873695 816.221842294876 816.225879756 816.229917257066 816.233954798077 816.237992379031 816.24202999993 816.246067660775 816.250105361565 816.254143102302 816.258180882971 816.262218703583 817.175791140998 817.179838526161 817.183885871236 817.187932855536 817.19197987992 817.196026944389 817.200074048944 817.204121193585 817.208168378313 817.212215603128 817.216262868032 817.220310173024 817.224357518104 817.228404903275 817.232452328536 817.236499793888 817.240547299332 817.244594844868 817.248642430496 817.252690056218 817.256737722019 818.156312195362 818.160369299793 818.164426363991 818.16848306611 818.172539808458 818.176596591035 818.180653413842 818.18471027688 818.18876718015 "
    "818.192824123651 818.196881107384 818.200938131351 818.204995195551 818.209052299986 818.213109444656 818.21716662956 818.221223854701 818.225281120079 818.229338425694 818.233395771546 818.237453157638 818.241510583968 818.245568050537 818.249625557347 818.253683104384 818.257740691659 819.179855074215 819.18392233678 819.18798915515 819.1920560139 819.19612291303 819.200189852541 819.204256832432 819.208323852706 819.212390913362 819.216458014401 819.220525155824 819.224592337631 819.228659559823 819.2327268224 819.236794125363 819.240861468713 819.24492885245 819.248996276561 820.185577074408 820.189654330641 820.193731546341 820.197808397262 820.201885288712 820.205962220691 820.210039193201 820.214116206241 820.218193259813 820.222270353916 820.226347488553 820.230424663722 820.234501879425 820.238579135663 820.242656432421 820.246733769709 832.210439016361 832.214636711145 832.21883436359 832.223031634984 832.227228948716 832.231426304787 832.235623703196 832.239821143946 832.244018627035 832.248216152466 832.252413720239 832.256611330353 832.260808982811 832.265006677613 832.269204414758 832.273402194249 832.277600016085 832.281797880267 832.285995786796 832.290193735673 832.294391726897 832.298589760471 832.302787836383 832.306985954642 833.214772599242 833.218980432568 833.223187798465 833.227395206852 833.231602657731 833.235810151102 833.240017686965 833.244225265321 833.248432886172 833.252640549516 833.256848255356 833.261056003692 833.265263794525 833.269471627854 833.273679503681 833.277887422002 833.282095382819 834.213097506187 834.217315429509 834.221533310184 834.225750807043 834.229968346546 834.234185928695 834.238403553488 834.242621220928 834.246838931015 834.251056683749 834.255274479132 834.259492317163 834.263710197844 834.267928121174 834.272146087143 834.276364095759 835.209590523302 835.213818530152 835.218046494203 835.222274073065 835.226501694725 835.230729359182 835.234957066438 835.239184816494 835.243412609349 835.247640445004 "
    "835.251868323461 835.256096244719 835.26032420878 835.264552215644 835.268780265312 835.273008357784 835.277236493061 835.281464671138 835.285692892018 873.169614211921 873.174235302306 873.178855854748 873.18347645609 873.188097106335 873.192717805482 873.197338553533 873.201959350488 873.206580196348 873.211201091114 873.215822034786 873.220443027366 873.225064068854 873.229685159251 873.234306298558 873.238927486775 873.243548723895 873.248170009922 874.168779238317 874.173410911255 874.17804253512 874.182673717335 874.18730494862 874.191936228976 874.196567558404 874.201198936904 874.205830364477 874.210461841124 874.215093366845 874.219724941642 874.224356565516 874.228988238466 874.233619960494 874.238251731601 874.242883551777 874.24751542103 874.293835733264 874.298468731571 874.303101680785 874.307734188164 874.312366744634 874.316999350196 874.321632004851 874.3262647086 874.330897461442 874.335530263379 874.340163114412 874.344796014542 874.349428963769 874.354061962094 874.358695009507 874.363328106014 875.165592406175 875.17023464882 875.174876842222 875.179518592457 875.184160391931 875.188802240643 875.193444138596 875.198086085788 875.202728082222 875.207370127898 875.212012222817 875.216654366978 875.221296560385 875.225938803036 875.230581094934 875.235223436068 875.239865826445 889.191017917482 889.195810155987 889.200602342844 889.205394064883 889.210185838565 889.214977663891 889.219769540862 889.224561469479 889.229353449744 889.234145481656 889.238937565216 889.243729700426 889.248521887286 889.253314125797 889.25810641596 889.262898757776 889.267691151245 889.272483596368 889.277276093147 889.282068641582 889.286861241673 889.291653893423 889.296446596831 889.301239351898 889.306032158626 889.310825017014 889.315617927065 889.320410888778 889.325203902155 889.329996967196 889.334790083902 889.339583252267 889.344376472295 890.011136019719 890.015937102839 890.02073813417 890.0255386994 890.030339316416 890.03513998522 890.039940705812 "
    "890.044741478193 890.049542302364 890.054343178326 890.059144106079 890.063945085625 890.068746116964 890.073547200097 890.078348335025 890.083149521749 890.087950760261 890.092752050565 890.164776481687 890.169579222658 890.174381911812 890.179184134627 890.183986409256 890.188788735699 890.193591113957 890.198393544031 890.203196025921 890.207998559629 890.212801145155 890.217603782501 890.222406471667 890.227209212653 890.232012005462 890.236814850093 890.241617746547 890.246420694826 890.25122369493 890.25602674686 890.260829850616 890.2656330062 890.270436213613 890.275239472855 890.280042783927 890.284846146813 890.289649561525 891.193612696933 891.198426546905 891.203239824931 891.208053154948 891.212866536959 891.217679970964 891.222493456964 891.22730699496 891.232120584952 891.236934226942 891.24174792093 891.246561666917 891.251375464905 891.256189314893 891.261003216882 891.265817170875 891.27063117687 891.27544523487 891.280259344875 891.285073506869 891.289887720863 892.195884230679 892.200708915166 892.205533025772 892.210357188546 892.21518140349 892.220005670603 892.224829989886 892.229654361341 892.234478784968 892.239303260768 892.244127788742 892.248952368891 892.253777001215 892.258601685716 892.263426422395 892.268251211251 892.273076052286 892.277900945486 892.28272589086 893.132728678992 893.137563501745 893.142398272161 893.147232571559 893.15206692329 893.156901327355 893.161735783755 893.166570292491 893.171404853563 893.176239466974 893.181074132723 893.185908850811 893.190743621239 893.195578443991 893.20041331912 893.205248246574 893.210083226371 893.214918258513 893.219753343 893.224588479834 893.229423669014 893.234258910542 893.239094204419 893.243929550645 893.248764949222 893.25360040015 893.25843590343 893.263271459063 893.26810706705 893.272942727391 893.277778440074 893.282614205108 894.187822376649 894.192668630074 894.197514830975 894.202360559179 894.207206339903 894.212052173146 894.21689805891 894.221743997196 "
    "894.226589988005 894.231436031336 894.236282127192 894.241128275573 894.24597447648 894.250820729913 894.255667035874 894.260513394364 894.265359805383 894.270206268932 894.275052784995 894.279899353585 906.224247555827 906.229225164689 906.234202718878 906.239179781027 906.244156897845 906.249134069332 906.25411129549 906.259088576319 906.26406591182 906.269043301994 906.274020746843 906.278998246366 906.283975800565 906.288953409441 906.293931072995 906.298908791226 906.303886564125 907.230703580199 907.235692252254 907.240680320926 907.245668444448 907.250656622821 907.255644856045 907.260633144123 907.265621487054 907.270609884839 907.27559833748 907.280586844978 907.285575407332 907.290564024546 907.295552696618 907.30054142355 907.305530205327 908.224399533254 908.229399140308 908.234398692328 908.239397749042 908.244396860787 908.249396027565 908.254395249375 908.25939452622 908.2643938581 908.269393245016 908.274392686968 908.279392183959 908.284391735988 908.289391343056 908.294391005152 908.299390722284 922.8325328307 922.837694572739 922.842856257044 922.84801742175 922.853178644185 922.858339924351 922.86350126225 922.86866265788 922.873824111245 922.878985622344 922.884147191179 922.88930881775 922.894470502059 922.899632244099 922.904794043873 934.032048332465 934.037336129731 934.042623867136 934.0479110658 934.053198324322 934.058485642702 934.063773020941 934.069060459041 934.074347957002 934.079635514825 934.084923132512 934.090210810063 934.09549854748 934.100786344763 934.106074201913 934.111362118932 934.116650095803 934.121938132538 962.936918468701 962.942538630487 962.94815872668 962.953778232548 962.959397804004 962.96501744105 962.970637143686 962.976256911914 962.981876745735 962.987496645149 962.993116610159 962.998736640765 963.004356736968 963.00997689877 963.015597126149 963.021217419121 963.206722453644 963.21234576551 963.217969011729 963.223591667127 963.229214388169 963.234837174856 963.240460027188 963.246082945167 "
    "963.251705928794 963.257328978069 963.262952092996 963.268575273574 963.274198519804 963.279821831688 963.285445209227 963.291068652422 963.296692161274 963.302315735784 963.307939375954 963.313563081784 963.319186853277 963.324810690432 963.330434593232 963.33605856169 963.409174682961 963.414800359131 963.420425969611 963.426050988895 963.431676073865 963.43730122452 963.442926440862 963.448551722892 963.454177070612 963.459802484022 963.465427963124 963.471053507919 963.476679118408 963.482304794592 963.487930536452 963.493556344003 964.202932688446 964.208567639153 964.21420252401 964.219836816216 964.225471174269 964.23110559817 964.236740087921 964.242374643523 964.248009264976 964.253643952283 964.259278705443 964.26491352446 964.270548409332 964.276183360063 964.281818376652 964.287453459101 964.293088607411 964.298723821583 964.304359101619 964.309994447519 964.315629859286 964.321265336919 964.32690088042 964.33253648979 964.338172165031 964.343807906143 964.349443713128 964.355079585987 964.36071552472 964.36635152933 964.371987599797 964.377623736134 964.456535113329 964.462173028838 964.467810878442 964.473448134917 964.479085457292 964.484722845568 964.490360299745 964.495997819824 964.501635405808 964.507273057696 964.512910775491 964.518548559193 964.524186408804 964.529824324324 964.535462305732 964.541100353044 965.189914277939 965.19556077155 965.201207199106 965.206853032182 965.212498931307 965.218144896483 965.223790927711 965.229437024992 965.235083188328 965.240729417718 965.246375713166 965.252022074672 965.257668502236 965.26331499586 965.268961555546 965.274608181294 965.280254873106 965.285901630983 965.291548454925 965.297195344935 965.302842301012 965.308489323159 965.314136411377 965.319783565667 965.325430786029 965.331078072465 965.336725424962 965.342372843529 966.20154803981 966.207206376885 966.212864647697 966.218522322157 966.224180062874 966.22983786985 966.235495743085 966.241153682582 966.246811688342 966.252469760364 "
    "966.258127898651 966.263786103204 966.269444374024 966.275102711111 966.280761114469 966.286419584096 966.292078119995 966.297736722167 966.303395390612 966.309054125333 966.31471292633 966.320371793604 966.326030727157 966.331689726967 966.337348793051 967.203966010578 967.209636095462 967.215306113877 967.220975534084 967.226645020755 967.232314573891 967.237984193494 967.243653879564 967.249323632103 967.254993451112 967.260663336592 967.266333288544 967.272003306969 967.277673391869 967.283343543245 967.289013761098 967.294684045428 967.300354396238 967.306024813528 967.3116952973 967.317365847555 967.323036464293 967.328707147517 967.334377897227 967.340048713424 967.345719596109 967.351390545285 967.35706156094 967.36273264308 980.1826630872 980.188486375754 980.194309595126 980.200132191883 980.205954857816 980.211777592926 980.217600397214 980.223423270681 980.229246213329 980.235069225159 980.240892306172 980.24671545637 980.252538675753 980.258361964323 980.264185322081 980.270008749028 980.275832245166 980.281655810496 980.287479445018 980.293303148735 980.299126921648 980.304950763757 980.310774675063 980.31659865557 980.322422705276 980.328246824169 980.334071012257 989.83725103487 989.843189613347 989.849128120579 989.855065986618 989.861003923897 989.866941932417 989.872880012179 989.878818163186 989.884756385438 989.890694678936 989.896633043682 989.902571479677 989.908509986923 989.91444856542 989.920387215148 989.926325936123 1024.21232670211 1024.21868494584 1024.22504311064 1024.23140056509 1024.23775809846 1024.24411571076 1024.25047340198 1024.25683117213 1024.26318902121 1024.26954694921 1024.27590495616 1024.28226304203 1024.28862120684 1024.29497945058 1024.30133777326 1024.30769617489 1024.31405465545 1024.32041321495 1024.3267718534 1024.3331305708 1024.33948936714 1024.34584824235 1024.35220719649 1024.61299057556 1024.61935379528 1024.62571693597 1024.63207936544 1024.63844187393 1024.64480446143 1024.65116712796 1024.6575298735 "
    "1024.66389269807 1024.67025560165 1024.67661858427 1024.6829816459 1024.68934478657 1024.69570800627 1024.7020713049 1024.70843468254 1024.79116404677 1024.79752947989 1024.80389483394 1024.8102594764 1024.81662419793 1024.82298899851 1024.82935387816 1024.83571883686 1024.84208387463 1024.84844899146 1024.85481418736 1024.86117946232 1024.86754481635 1024.87391024946 1024.88027576163 1024.88664135288 1024.89300702314 1024.89937277246 1037.16488510239 1037.17140519306 1037.17792520177 1037.18444447285 1037.19096382588 1037.19748326088 1037.20400277783 1037.21052237674 1037.21704205761 1037.22356182045 1037.23008166525 1037.23660159202 1037.24312160075 1037.24964169146 1037.25616186413 1037.26268211878 1037.2692024554 1037.275722874 1037.28224337457 1037.28876395712 1037.29528462166 1037.30180536817 1037.30832619667 1037.31484710715 1037.32136809962 1037.32788917408 1037.33441033044 1037.34093156877 1038.20898571443 1038.21551894014 1038.22205208364 1038.22858448726 1038.2351169731 1038.24164954113 1038.24818219137 1038.25471492382 1038.26124773848 1038.26778063535 1038.27431361443 1038.28084667573 1038.28737981924 1038.29391304497 1038.30044635292 1038.30697974309 1038.31351321548 1038.32004677009 1038.32658040693 1038.33311412598 1038.33964792725 1039.22246561664 1039.22901160479 1039.235556686 1039.24210184966 1039.24864709577 1039.25519242432 1039.26173783531 1039.26828332876 1039.27482890466 1039.28137456301 1039.28792030381 1039.29446612706 1039.30101203278 1039.30755802095 1039.31410409158 1039.32065024467 1039.32719648023 1039.33374279825 1039.34028919873 1039.34683568169 1039.35338224708 1039.35992889493 1040.21169412377 1040.21825258097 1040.22481095549 1040.23136858588 1040.23792629894 1040.24448409469 1040.25104197312 1040.25759993424 1040.26415797804 1040.27071610453 1040.27727431371 1040.28383260558 1040.29039098014 1040.2969494374 1040.30350797735 1040.3100666 1040.31662530535 1040.32318409339 1040.32974296414 1040.33630191754 1040.34286095363 "
    "1041.21594854869 1041.22251967656 1041.2290907215 1041.2356610201 1041.24223140163 1041.24880186607 1041.25537241343 1041.26194304372 1041.26851375694 1041.27508455308 1041.28165543215 1041.28822639415 1041.29479743909 1041.30136856695 1041.30793977776 1041.3145110715 1041.32108244817 1041.32765390779 1041.33422545035 1041.34079707585 1041.3473687843 1041.35394057569 1041.36051245003 1041.36708440732 1041.37365644756 1041.38022857076 1041.3868007769 1041.39337306601 1041.39994543807 1041.40651789309 1041.41309043107 1041.41966305201 1041.42623575597 1041.4328085429 1088.77842159412 1088.78560682014 1088.79279195134 1088.79997622919 1088.80716060185 1088.81434506932 1088.82152963161 1088.82871428871 1088.83589904063 1088.84308388737 1088.85026882893 1088.85745386531 1088.86463899652 1088.87182422254 1088.87900954338 1098.11077768719 1098.11808662634 1098.12539546821 1098.13270343459 1098.14001149825 1098.14731965918 1098.15462791738 1098.16193627285 1098.1692447256 1098.17655327563 1098.18386192294 1098.19117066753 1098.19847950941 1098.20578844857 1098.21309748502 1098.22040661877 1098.2277158498 1098.23502517813 1098.24233460375 1098.24964412667 1098.2569537469 1098.26426346442 1098.27157327925 1098.27888319132 1098.28619320068 1111.22207084412 1111.22955537549 1111.23703980607 1111.2445233295 1111.25200695373 1111.25949067876 1111.26697450458 1111.27445843121 1111.28194245863 1111.28942658687 1111.29691081591 1111.30439514576 1111.31187957642 1111.31936410789 1111.32684874018 1111.33433347329 1111.34181830722 1111.34930324196 1111.35678827748 1112.24072870492 1112.2482269659 1112.25572512581 1112.26322237607 1112.27071972739 1112.27821717979 1112.28571473327 1112.29321238783 1112.30071014346 1112.30820800018 1112.31570595798 1112.32320401687 1112.33070217685 1112.33820043792 1112.34569880008 1112.35319726328 1112.36069582756 1112.41318860905 1112.42068798226 1112.42818745657 1112.43568703201 1112.44318670856 1112.45068648624 1112.45818636504 1112.46568634496 "
    "1112.47318642601 1112.48068660819 1112.48818689151 1112.49568727595 1112.50318776154 1112.56319306158 1112.57069567152 1112.57819818028 1112.58569977849 1112.59320147786 1112.60070327839 1112.60820518009 1112.61570718295 1112.62320928699 1112.63071149219 1112.63821379856 1112.64571620611 1112.65321871484 1112.66072132475 1112.66822403575 1112.67572684791 1114.24603599637 1114.25356132196 1114.26108654592 1114.26861085524 1114.27613526618 1114.28365977874 1114.29118439293 1114.29870910874 1114.30623392618 1114.31375884525 1114.32128386596 1114.32880898829 1114.33633421227 1114.34385953786 1114.35138496508 1115.2400973368 1115.24763609676 1115.25517475482 1115.2627124958 1115.27025033867 1115.27778828344 1115.28532633011 1115.29286447867 1115.30040272913 1115.3079410815 1115.31547953577 1115.32301809195 1115.33055675004 1115.33809551004 1115.34563437195 1115.35317333572 1115.36071240139 1130.2660914334 1130.27383472389 1130.2815779083 1130.28932013803 1130.29706247383 1130.30480491569 1130.31254746363 1130.32029011764 1130.32803287773 1130.33577574389 1130.34351871613 1130.35126179446 1130.35900497886 1130.36674826935 1130.37449166592 1147.64679973146 1147.65478301943 1147.66276619636 1147.67074837394 1147.67873066254 1147.68671306219 1147.69469557288 1147.70267819461 1147.71066092738 1147.7186437712 1147.72662672607 1147.73460979199 1147.74259296897 1147.750576257 1147.75855965609 1147.76654316625 1147.77452678746 1147.78251051974 1147.79049436308 1182.96770337032 1182.97618566576 1182.98466783959 1182.99314891893 1183.00163011987 1183.01011144242 1183.01859288659 1183.02707445237 1183.03555613976 1183.04403794878 1183.05251987942 1183.06100193168 1183.06948410557 1183.07796640108 1183.08644881825 1183.09493135705 1183.15430985772 1183.16279482975 1183.1712796801 1183.17976343539 1183.18824731234 1183.19673131095 1183.20521543123 1183.21369967318 1183.22218403681 1183.23066852212 1183.2391531291 1183.24763785777 1183.25612270812 1183.26460768015 1183.27309277388 "
    "1183.28157798921 1183.29006332621 1183.66353599748 1183.67202827551 1183.68052043171 1183.68901149146 1183.69750267303 1183.70599397643 1183.71448540165 1183.7229769487 1183.73146861758 1183.7399604083 1183.74845232085 1183.75694435525 1183.76543651148 1183.77392878956 1183.78242118948 1183.79091371124 1188.25781635104 1188.26637468698 1188.27493289966 1188.28349000304 1188.29204722968 1188.30060457956 1188.30916205269 1188.31771964907 1188.32627736871 1188.3348352116 1188.34339317776 1188.35195126718 1188.36050947987 1188.36906781581 1188.37762627501 1209.73149100685 1209.74036149156 1209.74923184622 1209.75810103042 1209.76697034466 1209.77583978896 1209.78470936331 1209.79357906772 1209.80244890218 1209.81131886671 1209.82018896131 1209.82905918597 1209.83792954071 1209.84680002542 1209.85567064018 1209.87341226042 1209.88228326555 1209.89115440077 1209.90002566609 1209.9088970615 1209.917768587 1209.92664024261 1209.93551202832 1209.94438394413 1209.95325599005 1209.96212816609 1209.97100047225 1209.97987290852 1214.97790357742 1214.98685117584 1214.99579864251 1215.00474492341 1215.01369133607 1215.02263788047 1215.03158455663 1215.04053136455 1215.04947830422 1215.05842537566 1215.06737257887 1215.07631991384 1215.08526738058 1215.0942149791 1215.10316270939 1215.11211057146 1215.12105856523 1215.13000669076 1240.40464902433 1240.41397508362 1240.4233010027 1240.43262565993 1240.44195045736 1240.45127539499 1240.46060047282 1240.46992569085 1240.47925104909 1240.48857654754 1240.4979021862 1240.50722796507 1240.51655388417 1240.52587994349 1240.53520614303 1240.5445324828 1240.55385896272 1240.56318558285 1243.03032547186 1243.03969105933 1243.04905650569 1243.05842068214 1243.06778499968 1243.0771494583 1243.08651405802 1243.09587879883 1243.10524368075 1243.11460870376 1243.12397386788 1243.13333917311 1243.14270461945 1243.15207020691 1243.16143593548 1243.17080180517 1243.18016781599 1243.18953396794 1243.198900261 1243.20826669518 1250.92705947029 "
    "1250.93654444262 1250.94602927114 1250.95551280543 1250.96499648351 1250.97448030538 1250.98396427106 1250.99344838053 1251.00293263381 1251.0124170309 1251.0219015718 1251.03138625652 1251.04087108505 1251.05035605741 1251.05984117355 1251.0693264335 1261.29199699524 1261.30163981508 1261.31128248752 1261.32092383336 1261.33056532659 1261.34020696722 1261.34984875525 1261.35949069069 1261.36913277353 1261.37877500379 1261.38841738147 1261.39805990657 1261.40770257909 1261.41734539893 1261.42698836617 1261.92862266474 1261.93827522226 1261.94792763215 1261.95757871339 1261.96722994224 1261.97688131873 1261.98653284283 1261.99618451457 1262.00583633394 1262.01548830095 1262.02514041559 1262.03479267788 1262.04444508782 1262.05409764541 1262.06375035065 1262.07340320354 1262.08305620408 1262.09270935227 1262.30511272825 1262.31477104675 1262.32442921749 1262.33408605841 1262.34374304707 1262.35340018349 1262.36305746766 1262.3727148996 1262.3823724793 1262.39203020678 1262.40168808202 1262.41134610504 1262.42100427584 1262.43066259442 1262.44032106079 1262.44997967483 1262.45963843663 1263.26182796013 1263.27150092584 1263.28117374346 1263.29084522825 1263.30051686113 1263.31018864211 1263.31986057118 1263.32953264835 1263.33920487361 1263.34887724699 1263.35854976847 1263.36822243806 1263.37789525577 1263.3875682216 1263.39724133555 1263.40691459763 1263.41658800777 1263.42626156602 1265.29603237936 1265.30573652557 1265.31544052296 1265.32514318102 1265.33484598788 1265.34454894355 1265.35425204803 1265.36395530132 1265.37365870343 1265.38336225437 1265.39306595413 1265.40276980271 1265.41247380013 1265.42217794639 1265.43188224148 1265.4415866854 1273.44964695491 1273.45947658402 1273.46930606141 1273.47913417338 1273.48896243705 1273.49879085242 1273.5086194195 1273.51844813829 1273.5282770088 1273.53810603102 1273.54793520496 1273.55776453063 1273.56759400803 1273.57742363715 1273.58725341802 1273.59708335062 1273.60691343496 1273.61674367105 1273.62657405888 "
    "1273.6364045985 1273.64623528987 1281.30097667712 1281.31092789888 1281.32087896611 1281.33082864257 1281.34077847355 1281.35072845906 1281.3606785991 1281.37062889368 1281.38057934279 1281.39052994644 1281.40048070464 1281.41043161738 1281.42038268468 1281.43033390653 1281.44028528294 1281.45023681392 1281.46018849946 1281.47014033957 1281.48009233426 1281.49004448347 1281.49999678724 1293.14970519514 1293.1598413324 1293.16997731079 1293.18011185941 1293.19024656688 1293.2003814332 1293.21051645839 1293.22065164243 1293.23078698534 1293.24092248711 1293.25105814776 1293.26119396729 1293.27132994569 1293.28146608298 1293.29160237905 1293.30173883398 1409.27988966716 1409.29192829595 1409.30396671911 1409.31600329167 1409.32804006984 1409.34007705362 1409.35211424301 1409.36415163802 1409.37618923866 1409.38822704493 1409.40026505684 1409.4123032744 1409.4243416976 1409.43638032645 1409.44841916087 1409.46045820092 1439.78778750238 1439.80035305206 1439.81291838247 1439.82548173949 1439.83804531576 1439.85060911129 1439.86317312607 1439.87573736013 1439.88830181346 1439.90086648606 1439.91343137795 1439.92599648913 1439.93856181961 1439.95112736929 1439.96369313824 1439.97625912687 1439.98882533458 1440.00139176163 1440.013958408 1440.0265252737 1440.03909235875 1440.05165966315 1440.0642271869 1440.07679493 1440.08936289247 1440.10193107432 1440.11449947547 1440.12706809597 1456.37108237404 1456.38393907986 1456.39679555874 1456.40964999523 1456.42250465864 1456.43535954896 1456.44821466621 1456.46107001039 1456.47392558151 1456.48678137957 1456.49963740459 1456.51249365655 1456.52535013548 1456.53820684138 1456.55106377425 1456.5639209341 1456.57677832093 1456.58963593471 1456.60249377546 1469.47025906961 1469.48334811809 1469.49643693345 1469.5095236508 1469.52261060125 1469.5356977848 1469.54878520145 1469.56187285121 1469.57496073409 1469.58804885009 1469.60113719922 1469.61422578149 1469.6273145969 1469.64040364545 1469.65349292705 1469.66658244177 "
    "1477.44348519436 1477.45671668448 1477.46994793765 1477.48317705841 1477.49640641608 1477.50963601066 1477.52286584217 1477.53609591059 1477.54932621596 1477.56255675826 1477.5757875375 1477.58901855369 1477.60224980685 1477.61548129696 1477.62871302405 1477.64194498811 1477.65517718916 1477.6684096272 1477.68164230223 1477.69487521426 1477.7081083633 1477.72134174936 1477.73457537235 1477.74780923233 1478.88680339341 1478.90006075078 1478.91331787051 1478.9265728516 1478.93982807029 1478.9530835266 1478.96633922051 1478.97959515204 1478.99285132121 1479.006107728 1479.01936437244 1479.03262125452 1479.04587837426 1479.05913573163 1479.07239332664 1480.14704316047 1480.16032312453 1480.17360285036 1480.18688043216 1480.20015825217 1480.2134363104 1480.22671460685 1480.23999314153 1480.25327191444 1480.2665509256 1480.279830175 1480.29310966266 1480.30638938858 1480.31966935276 1480.33294955522 1480.34622999596 1480.35951067499 1480.37279159231 1480.38607274793 1480.39935414185 1480.41263577409 1480.42591764464 1480.43919975341 1480.45248210047 1480.70488674232 1480.71817671946 1480.73146645809 1480.74475405022 1480.75804188082 1480.77132994991 1480.78461825749 1480.79790680357 1480.81119558816 1480.82448461126 1480.83777387287 1480.85106337301 1480.86435311168 1480.87764308888 1480.89093330463 1480.90422375893 1480.91751445178 1480.9308053832 1480.94409655318 1480.95738796174 1480.97067960888 1480.983971494 1480.99726361894 1481.01055598187 1481.0238485834 1481.03714142355 1481.05043450231 1481.06372781971 1481.07702137574 1481.09031517027 1481.1036092034 1481.31634094436 1481.32964190116 1481.34294261915 1481.35624118796 1481.36953999554 1481.38283904191 1481.39613832706 1481.409437851 1481.42273761375 1481.4360376153 1481.44933785567 1481.46263833486 1481.47593905287 1481.48924000971 1481.50254120539 1481.51584263992 1481.5291443133 1481.54244622554 1481.55574837664 1481.56905076662 1481.58235339547 1481.5956562632 1481.60895936983 1481.62226271535 "
    "1481.63556629978 1481.64887012311 1481.66217418536 1481.67547848654 1481.68878302651 1481.70208780537 1482.34099304957 1482.35431241572 1482.36763154258 1482.38094851586 1482.39426572841 1482.40758318025 1482.42090087136 1482.43421880177 1482.44753697147 1482.46085538047 1482.47417402879 1482.48749291642 1482.50081204337 1482.51413140965 1482.52745101526 1482.54077086022 1482.5540909444 1482.56741126789 1493.5982780897 1493.61180054861 1493.62532276273 1493.63884277381 1493.65236302966 1493.66588353027 1493.67940427566 1493.69292526583 1493.70644650079 1493.71996798055 1493.73348970511 1493.74701167448 1493.76053388867 1493.77405634768 1493.78757905144 1493.801102 1511.56275146435 1511.57660120391 1511.59045068974 1511.60429789207 1511.6181453481 1511.63199305785 1511.64584102131 1511.65968923849 1511.6735377094 1511.68738643405 1511.70123541244 1511.71508464459 1511.72893413049 1511.74278387005 1511.75663386334 1599.95476419777 1599.97027768381 1599.98579147069 1600.00130555844",

     "0 0 0 0 0 0 0 0 56.580329059165 222.670531230651 384.428314386826 483.544970105578 520.020498386908 493.854899230815 405.048172637299 253.600318606361 80.6321002809041 0 0 0 0 0 0 0 0 63.1937789027786 177.170824740039 287.593692521671 365.067335897948 393.750113818473 373.642026283247 304.743073292268 187.053254845537 68.2775071150773 0 0 0 0 0 0 0 0 0 26.5531008704837 64.2443677639905 115.98666236006 147.825064207846 159.759573307349 151.790189658567 123.916913261502 76.139744116154 33.749000104713 0 0 0 51.7119753110659 82.9031363178244 101.554580012679 107.666306395631 101.238315466678 82.2706072258227 50.7631816730632 6.71603880840022 0 0 0 0 0 0 0 30.1075875875833 70.2224843129689 97.0448626538256 110.574722610153 110.812064181952 97.7568873692226 71.4091921719637 31.7689785901761 0 0 0 0 0 0 0 0 18.3294783372145 58.8736362412815 110.537404378255 156.846788810961 179.944579437896 179.83077625906 156.505379274453 109.968388484075 60.0197602385408 18.9203823774288 0 0 0 0 0 0 0 8.58646017576987 41.2356907771184 64.3686342394991 77.985290562912 82.0856597473572 76.6697417928345 61.737536699344 37.2890444668856 3.32426509545953 0 0 0 0 0 0 0 0 78.9325434900386 191.263742620295 293.355350485493 369.501770161804 395.790015125052 372.220085375237 298.791980912358 180.992891289415 67.186402469804 1.06252827677693 0 0 0 0 0 0 0 0.0625048728533582 38.1302716092908 65.7740289648097 82.99377693941 89.7895155330917 86.1612447458548 72.1089645776994 47.6326750286254 0 0 0 0 464.834393836957 1182.28302428772 1901.39633271189 2402.71116385649 2585.80436190803 2441.13485483023 1968.70264262308 1253.9916804387 526.546510994295 23.8594603638548 0 0 0 0 0 0 0 0 0 0 78.7486744416065 320.65786394595 583.556565647081 752.05728398392 820.575446424507 789.111052968842 657.664103616924 426.88182441338 165.292091778664 0 0 0 0 0 0 0 0 0 39.6674667038284 97.8364408266294 137.002481847376 157.165589766069 158.325764582707 140.483006297292 103.637314909822 47.7886904202975 0 0 0 0 0 0 0 0 "
    "20.1155565879839 84.6860871570649 135.944271594494 166.382412072384 176.000508590734 164.798561149544 132.776569748814 79.9345343885444 15.8504547617096 0 0 0 0 0 0 0 0 0 0 0 878.523046533544 3533.54161768915 6597.61115654365 8946.62553775672 10018.5698880638 9907.26689265325 8573.87583987363 6006.3995425351 2960.21581124259 513.821274692918 0 0 0 0 0 0 0 0 0 0 0 0 421.945560197452 1134.6227427307 1824.51103569689 2237.41520996805 2374.5619220867 2300.36824263282 2021.34070677857 1530.49420521698 996.809708032853 641.61360705538 528.468407406396 531.361696612307 464.464233398438 260.778715547148 68.9924579611467 0 0 0 0 0 0 0 0 0 134.609378556827 578.260282929961 1074.93768168274 1446.2596667452 1636.63645465558 1632.36158176236 1423.41207736356 1010.5181634365 540.379547048004 196.247308477655 84.5798738208401 150.894825933141 250.318398606805 276.0162302653 258.330770141317 212.850712062596 145.902348124897 75.0209929993102 20.4909287743912 0 0 0 0 0 0 0 0 0 300.845798021152 1114.43657888844 2054.2882292065 2782.39238530939 3116.96538908276 3058.00724052661 2605.51793964093 1808.21684723968 876.364110417578 130.946627387912 0 0 0 0 0 0 0 0 76.3418424023892 283.125607506101 489.762458000984 616.219671645087 662.497248438411 628.595188380955 514.51349147272 320.252157713706 108.831177042359 0 0 0 0 0 0 0 0 15.9746526260199 124.960080446897 241.25387989391 318.133682322113 352.504830989527 344.36732589615 293.721167041983 200.566354427026 76.4160180080742 0 0 0 0 0 0 0 0 0 0 406.708752185315 1334.78267514956 2349.32185360213 3068.03144605232 3393.7700774364 3335.58019052075 2852.29924267322 1989.01304146293 995.7183964158 227.016740278764 0 0 0 0 0 0 0 0 0 0 0.0546699648414517 39.6806581581667 90.1680477115657 123.724541724145 140.350140195904 140.044843126844 122.808650516963 88.6415623662632 37.5435786747432 0 0 0 0 0 0 0 0 64.1342712260068 274.122147282242 516.021753413416 708.081059275807 801.952577390871 794.773707143077 686.544448532425 477.264801558915 "
    "232.671458708934 39.340255239349 0 0 0 0 0 0 0 0 0 30.4287526235159 87.8759740015845 129.18958679057 151.813565340909 155.747909652603 140.992619725652 107.547695560055 55.4131371558129 8.86281480766951 0 0 0 0 0 0 0 0 27.558765687031 68.0522128018466 118.710231007396 149.457779891008 160.294859452681 151.221469692417 122.237610610215 73.3432822060752 31.594597520806 0.815041032982236 0 0 0 0 0 0 0 147.065229082441 816.937306508595 1594.57035205192 2160.73973186644 2445.81752099524 2447.96061400656 2138.26428169304 1516.72852405468 741.546437830359 123.28685957902 0 0 0 0 0 0 0 0 0 5.37730891443355 37.952812568291 86.8506389342265 119.270008149403 135.210920213819 134.673375127477 117.657372890375 84.1629135025131 34.1899969638923 4.06605423080336 0 0 0 0 0 0 0 2.63267410385011 193.022110518875 447.13469210538 680.1333845801 842.849257711486 921.179299058892 891.052504390547 736.307160597581 484.707327498145 236.76334361541 74.5047025880612 9.88939145672835 0 0 0 0 0 0 0 0 0 78.5846299035843 199.159299908262 280.700094903266 323.207014888595 326.680059864249 291.119229830228 216.524524786533 102.895944733164 0 0 0 0 0 0 0 7.39269724314586 48.1607391428559 77.2501943806113 94.6610629564122 100.393344870258 94.4470401221501 76.8221487120871 47.5186706400696 6.53660590609747 0 0 0 0 0 0 2.38687507255929 42.7141680950885 71.8261903349336 89.7229417920946 96.4044224665714 91.8706323583642 76.1215714674729 49.1572397938974 10.9776373376379 0 0 0 0 0 0 0 460.239607235212 2862.44145405376 5839.56022704509 8350.2375135444 9678.68241274107 9810.33116694097 8739.8425216497 6417.89346263681 3472.16898931045 923.290802073089 0 0 0 0 0 0 0 0 0 0 1.21281717651646 35.0232140601098 82.6014301148883 114.369752328157 130.328180699915 130.476715230164 114.815355918902 83.3441027661303 36.0629557718486 1.2077191759656 0 0 0 0 0 0 0 20.2247096419612 67.9158100403834 127.542260656823 164.980780185797 180.231368627302 173.294025981341 144.168752247913 92.8555474270181 40.8839086074638 0 0 "
    "0 3.75304439518002 40.7344921618909 92.7082375124063 127.176010238541 144.137810340295 143.593637817667 125.54349267066 89.9873748992707 36.925284503501 2.6634972845757 0 0 0 0 0 0 0 222.069063342257 922.071941242353 1699.46145309769 2332.56524558612 2762.37139650714 2932.97623868645 2749.76402172453 2154.12462155358 1371.75909907557 694.588988973267 296.186114686908 127.10528834772 26.9340466052504 0 0 0 0 0 0 0 0 14.0997288843967 411.915607016681 938.814124758705 1326.40101534615 1542.15077277052 1612.96328429464 1521.26588977022 1249.39873911895 824.933991154313 413.748029802229 184.349373237237 151.395683946587 170.435887939169 89.7732302081057 11.6400089930822 0 0 0 0 0 0 0 0 75.4495806927448 198.667384149867 320.344301059252 391.667397238992 412.636672689087 383.252127409537 303.513761400343 173.421574661504 51.7569392633328 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 218.289064349549 1375.4185408301 2853.53691716405 4111.87394234184 4773.71754000293 4820.43625567954 4323.88157973923 3212.97951537801 1724.93808477797 413.467460863518 0 0 0 0 0 0 0 0 13.9193490479653 49.4962683902197 74.3885564559544 77.2845681641762 73.7332380245892 77.1295705586323 94.8237774900066 130.334876178306 164.777472613853 195.814271726809 221.110580764451 218.01382962029 179.423323624618 112.770667122794 46.6491851806641 0 0 0 0 84.9664134490185 453.04162996021 855.94201873566 1203.17425622473 1482.54422644413 1635.17299298195 1581.35360550603 1295.91611948436 868.001328226013 480.103207746029 236.811169284206 107.43062451058 6.90438675602574 0 0 0 0 0 0 0 0 0 55.7104535225111 151.168876487892 227.233838772718 269.679472845473 278.505778706157 253.71275635477 195.300405791312 104.652852234029 19.144869113024 0 0 0 0 0 138.891268643466 437.569434248206 699.524413351135 853.877060434479 933.274479934942 940.569107482483 871.230297026378 683.531829620574 450.146854142764 283.595072570659 224.223552712749 210.192749877076 141.173638190423 42.4980949277366 0 0 0 0 0 0 0 "
    "0.0432223162173031 41.1795508466956 101.05418726781 141.259691856402 161.796064612471 162.663305536017 143.86141462704 105.39039188554 47.2502373115166 2.99908920323652 0 0 0 0 0 0 4.2043330763881 48.799060670368 98.2071964290593 130.261364845685 144.961565920245 142.30779965274 122.300066043169 84.9383650915329 30.2226967978311 0 0 0 0 0 0 0 3.56522918914582 42.772335025814 70.9899717033048 88.2181392216182 94.4568375807542 89.7060667807128 73.9658268214939 47.2361177030977 9.516939425524 0 0 0 0 0 0 0 58.821031512636 207.741213356143 342.149165226863 422.50411240371 448.806054886682 421.054992675781 339.250925771006 203.393854172358 59.3580422212472 0 0 0 0 0 0 0 0 32.48157773318 60.2129703334996 77.9906898978709 85.8147364262936 83.6851099187679 71.6018103752938 49.5648377958712 17.5741921805002 0 0 0 0 0 0 0 0 0 968.603915661365 2653.86673578293 4283.40980807218 5263.356996763 5634.95406894639 5356.74031134474 4403.79027562709 2835.16697596837 1198.53091476903 99.3317592238491 0 0 43.7005128304719 0 0 0 0 0 0 0 1.07703294731796 43.1776158259465 73.6865398344738 92.6038049728999 99.9294112412247 95.6633586394482 79.8056471675704 52.3562768255914 13.3152476135112 0 0 0 0 0 0 0 0 224.974633561426 768.975833314839 1200.82574775892 1532.35896891703 1810.51670186503 1924.64049008954 1765.30956647113 1346.65247705989 823.656264369583 415.831654084035 232.806001107454 153.075705930625 0 0 0 0 0 0 0 0 31.07674932591 83.1869365274211 118.594620960298 137.29980262454 139.302481520148 124.602657647122 93.2003310054611 45.095501595166 3.1810702877445 0 0 0 0 0 0 0 0 58.0700804525877 349.994400949189 694.454611611533 968.727648150394 1112.31297817986 1149.25511354389 1085.70508424274 904.114671578219 602.249157458752 322.46461700226 170.141715665519 129.989040312511 109.655052345116 57.0866252836925 0 0 0 0 0 0 0 0 31.1422953216623 144.076980697525 276.947856236171 361.346737308102 397.273623913318 384.728516051819 323.711413723606 214.222316928677 90.7740647820605 0 0 0 0 0 "
    "0 0 16.8304083052771 57.6761780852205 86.1866616913767 102.361859123746 106.201770382328 97.7063954671224 76.87573437813 43.7097871153504 0 0 0 0 0 0 0 0 41.0256652120666 94.135655756597 129.498184310806 147.113250874695 138.344459373634 85.9153107329683 0 0 129.488300492435 527.067957062265 1000.05021941356 1346.99716801855 1496.12085985304 1459.02060509173 1235.69640373461 847.979145859227 382.422087413726 19.9891446698237 0 0 0 0 0 0 0 7.44465210387754 47.4026937418051 91.2424360510909 119.32425972465 131.648164762484 128.214151164591 109.022218930971 74.0723680616259 23.3645985565541 0 0 0 0 0 0 31.1665401858884 103.860189549017 146.554329114083 195.753168030497 253.418050841574 299.427352514023 300.171697585455 255.651086055871 180.101849749372 121.966266054096 92.4298811336774 53.3473170353815 0 0 0 0 0 0 0 2.16977021188442 58.7684953240524 128.064489653616 173.783125977416 195.924404295452 194.488324607725 169.474886914233 120.884091214978 48.7159375099592 0 0 0 0 0 0 0 9.11328484239557 45.9480907377941 72.0695525127136 87.4776701671539 92.172443701115 86.153873114597 69.4219584075999 41.9766995801237 3.81809663216825 0 0 0 0 0 0 0 39.051860533672 87.2874872878993 119.282621797148 135.037264061419 134.551414080711 117.825071855025 84.8582373843604 35.6509106687177 0 0 0 0 0 0 0 1.69602361647959 44.8811960642711 76.1225670234307 95.4201364939586 102.773904475855 98.1838709691188 81.6500359737512 53.1723994897518 12.7509615171205 0 0 0 0 0 0 3.8020184212353 39.4493619478666 85.0018297742297 141.991383977148 175.708218518949 186.152333399633 164.603114272609 118.034558027219 73.7157701256669 71.4067476357057 90.1063530839683 108.46793982588 125.35972406703 139.403204751181 123.020032691511 89.9415597270974 40.1677858579408 0 0 0 0 0 0 0 0 27.1206040815874 111.052126157534 187.706427158454 234.152603967484 250.390656584626 236.420585009879 192.242389243244 117.856069284719 40.2592313539731 0 0 0 0 0 0 0 0 0 0 398.852037585421 1062.65146567605 1700.46363133429 "
    "2084.80266327403 2196.2757965657 2034.88303120931 1626.55308137907 981.359526805391 326.033995870667 0 0 0 0 0 0 0 0 7.16578375542911 46.4870872942161 91.6829358080884 120.81335876038 133.878356151092 130.877927980223 111.812074247774 75.0577634442381 0 0 0 107.782782281195 222.248625641936 305.267269534665 430.256208939986 573.133296513057 651.057089105353 632.035175883687 520.170219830422 378.181396342102 270.606431974398 189.369573846563 59.2234124670495 0 0 0 0 0 0 0 0 0 89.7750522995884 203.418093061114 282.425017492477 343.024862578421 380.616778820545 366.947697352696 302.017618174875 189.785982963367 83.2391572965611 27.3657364211717 16.5044280365631 7.73395881563912 0 0 0 0 0 0 0 24.6662371797717 177.35019753196 363.077968108348 504.323164613097 574.146720014808 572.548634313481 499.528907509117 355.087539601715 172.380371378296 20.8220308388308 0 0 0 0 0 0 0 3.13301499017747 41.5384418336385 83.126995593518 110.088259325717 122.422233030235 120.128916707072 103.208310356229 71.6604139777053 25.4852275715008 0 0 0 0 0 0 0 0 4.18438116042486 81.6340404590526 184.237271609006 288.975303952233 380.977933941465 443.93454189345 454.637123232399 400.925354324021 294.161514886887 183.3917595212 96.5255568711075 38.7303105778906 3.02359535199502 0 0 0 0 0 0 0 0 15.0726765452566 72.8836913208862 156.47641812838 271.243299079664 405.814256681429 531.454790306536 626.386107011275 674.981889062272 666.860740714974 593.166164869473 478.423894886648 339.627820706312 203.89971884703 97.5393991181344 25.2512227305165 0 0 0 0 0 0 0 0 0 159.195879031451 755.611733461039 1465.07687498862 2027.56122992811 2300.46812599022 2283.79756317494 1977.54954148228 1395.66622732736 694.27564102564 113.818217671001 0 0 0 0 0 0 0 0 87.9490083280976 276.782974634415 469.754560990767 633.069600138631 707.098015062737 691.839805763085 587.294972239675 393.463514492506 175.767283477428 27.5048187896088 0 0 0 0 0 0 0 3.83732277752358 48.604770473667 80.8521452150145 100.579447001566 "
    "107.786675833322 102.473831710282 84.640914632446 54.2879245998142 11.4148616123866 0 0 0 0 0 0 0 62.0859234505322 237.157430582113 409.419941117436 539.981749456802 596.533654735361 579.075656953114 487.60775611006 322.1299522062 134.395098635089 1.91269422411075 0 0 0 0 0 0 0 0 40.6763852348416 115.908585270524 176.182268369448 210.213658046056 218.002754300347 199.549557132321 154.854066541979 83.9162825293197 15.7817960441252 0 0 0 0 0 0 0 0 28.7568318471486 73.109018890452 103.132771560918 118.828089858546 120.194973783337 107.233423335291 79.9434385144072 38.3250193206859 0 0 0 0 0 0 0 0 10.6625377948467 74.9142424754607 165.494804649086 287.059236113008 434.534418741862 586.533972964698 710.76455329237 776.748612695085 785.413608506566 762.271802782179 673.909408747178 535.384800197362 377.341590721291 233.20957295878 120.30560103552 40.7944522315249 0 0 0 0 0 0 0 0 38.6563572739117 364.499308837322 781.749915489784 1139.17763080019 1328.35192757275 1349.27280580748 1201.94026550435 886.354306663389 471.473510457642 106.703597915757 0 0 0 0 0 0 0 7.73662188336564 48.980887032889 78.4115988635795 96.0287573754371 99.1956425380041 58.2084386509894 14.7314589351486 35.9568292577783 146.482631265422 324.900631208798 495.755628430204 599.271237851301 616.05365328133 557.826909169728 424.591005516497 223.010984620848 41.2635390986374 0 0 0 0 0 0 0 0 28.9825461149772 104.503168955272 170.980321283941 210.469236680678 222.969915145483 208.482356678356 167.006561279297 98.5425289483059 33.3136386471194 0 0 0 0 0 0 0 0 22.164983540426 89.3156778117716 114.606955041419 123.795334182419 152.155981637381 213.065699721828 304.57126085686 413.880444648938 530.896991294025 649.506209615783 751.232561018084 791.851777190095 731.249636919071 617.617943112389 476.905889764533 335.457150617124 213.174913526415 121.290352347848 58.6050446339144 15.4890085500438 0 0 0 0 0 0 0 0 0 55.1470522224764 205.248684756406 376.77187196247 488.647291312407 533.91258901316 512.567765064729 "
    "424.612819467113 293.639329923616 130.501937048141 0 0 0 0 0 0 0 0 0 26.7308857524312 65.3755704439604 108.690081367404 163.069601739203 191.674607319154 194.505098107256 171.561074103509 122.842535307913 75.0868885956166 33.9400274103338 4.43001554618073 0 0 0 10.86665411818 58.5051887707833 112.448902299076 146.961878565364 162.044117569646 157.695619311922 133.916383792192 90.7064110104576 28.0657009667171 0 0 0 0 0 0 0 0 32.0124449474273 78.0469590122606 109.04468587951 125.005625549174 125.929778021255 111.817143295751 82.6677213726623 38.4815122519896 0 0 0 0 0 0 0 0 21.1402150756551 75.9409963612234 167.425308725495 296.82683870898 446.085191099794 580.561820503715 653.153247682087 651.881193752333 581.633140403908 467.109662569486 320.388051813299 173.048924763998 61.2694148350429 0 0 0 0 0 0 0 0 0 10.2529036870924 93.6242285952978 209.564040141784 337.962966172011 458.582199736908 556.476431466483 624.809225051275 650.47037362052 613.96121717333 525.526058170345 419.746564353818 311.244555208789 205.813153282468 109.199933672285 30.0832366943358 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3.41523369208915 51.458328851731 97.5781555531465 127.097920379994 140.017623332275 136.337264409988 116.056843613133 79.1763609417113 25.6958163957218 0 0 0 0 0 0 0 0 0 372.079539336803 1016.65002743737 1610.38992558548 1968.29416128306 2116.70497867611 2003.57856608215 1621.14932115817 1010.35877731074 390.808202498998 0 0 0 0 0 0 0 0 0 0 0 100.46006906505 412.467642261711 749.729029230862 983.569686533968 1084.13748617106 1051.43242814213 885.45451244719 586.203739086232 241.127440268065 0 0 0 0 0 0 0 0 1.07279875784213 17.2450552987052 25.2870257539905 52.7916675203054 164.1861986636 393.581850847719 686.799061488438 924.798064260772 1022.84418130088 1011.00502476548 888.903006209083 663.630723077379 372.76392970941 101.44183605701 0 0 0 0 0 0 0 0 0 14.1457899044721 87.5922147310697 154.796218231841 196.667849382876 213.207108184174 204.413994635735 170.28850873756 "
    "110.830650489647 32.5873545399913 0 0 0 0 0 0 0 11.6920036547112 72.4842579092458 121.835492789884 152.031258963205 163.071556429207 154.956385187892 127.685745239258 81.259636583306 15.6780592200361 0 0 0 0 0 0 0 6.13225404254762 52.6391649223986 85.9729387687915 106.133575581726 113.121075361203 106.935438107222 87.5766638197822 55.0447524988846 9.33970414452897 0 0 0 0 0 0 0 148.167932897181 1388.05229731206 2976.45391205474 4342.85406750232 5088.76170669236 5186.18815488304 4635.13341207438 3435.59747826636 1853.88035789792 453.450956331267 0 0 0 0 0 0 0 0 6.66626976030965 48.3212128041229 92.3405437691783 120.513208633814 132.83920739803 129.318540061826 109.951206625203 74.7372070881592 23.6765414506961 0 0 0 38.1889706769468 89.7086560798414 123.988314968723 141.027947343591 140.827553204445 123.387132551287 88.7066853841146 36.7862117029292 5.33883748799218 0 0 0 0 0 0 0 0 145.464155005964 904.990516822656 1823.29311600265 2567.20284845668 2993.22855389646 3050.41713783958 2718.43636651028 2003.11355619275 1081.64283706203 290.874158098981 0 0 0 0 0 0 0 0 0 3.10649507251377 40.5222100389031 87.2688733080883 117.987425690764 132.677867186931 131.340197796588 101.866811685629 0 0 0 453.972310348548 1151.65821340423 1659.45029988323 1962.0662062496 2075.50547580675 1963.25049610627 1577.71579897154 947.284497916838 350.211003656987 29.6131019503359 4.44898613349534 62.1006770989833 0 0 0 0 0 0 0 0 0 49.7262262019801 222.611733603311 426.196186376897 593.853597325324 676.474096231528 674.057683095511 586.604357917271 414.114120696809 196.391473516718 34.5097690751222 0 0 0 0 0 0 0 0 103.047914731753 393.530483432584 693.196257051056 909.36366969111 1011.89433523325 987.981005012852 837.623679029915 560.82235728444 238.223779389352 13.6118697942272 0 0 0 0 0 0 0 0 0 26.0728362468016 167.871154927429 343.088860749643 480.963335619662 549.937720203177 550.012014500189 481.186218510697 343.460332234701 172.628680604877 27.9800269564826 0 0 0 0 0 0 0 0 "
    "17.0064636799561 96.9148907072338 178.180039946016 229.163176174208 249.864299391811 240.283409598824 200.420506795247 130.275590981081 54.1559029603616 0 0 0 0 0 0 0 0 26.4056763193268 101.508346877732 187.251913537512 270.682010712879 313.730347924577 316.396925172606 278.681742456965 200.584799777656 103.746263908617 30.8895239841132 0 0 0 0 0 0 0 0 64.0352733407543 159.398966329081 271.666252509698 392.393694826495 453.049673369437 453.634188138522 394.147239133751 274.588826355123 164.708285814121 66.5432133174443 0 0 0 0 0 0 0 0 122.841370340272 440.753407155995 764.413820066652 991.46218178489 1106.4972962066 1081.54964345652 916.619223534644 611.706036440976 273.045237685695 29.2376758424273 0 0 0 0 0 0 0 0 0 32.7690956809304 145.477944683084 250.423947598829 314.793448921684 338.58644865165 321.802946788726 264.442943332912 166.506438284209 50.6765287883908 0 0 0 0 0 0 0 0 0 135.516833183093 324.403155062304 500.465067261027 608.838382712055 638.082379961347 588.197059008903 459.182419854722 263.389066007032 80.6505240771598 0 0 0 0 0 0 0 0 0 19.3995503601216 63.5382819542518 122.552791675488 185.422363636933 219.297602549022 224.178508411754 200.065081225131 146.957320989151 88.6727182526132 35.8050960727504 0 0 0 0 0 0 0 0 460.788375605515 2508.82573025932 4939.40949439558 6874.84518169413 7854.2086463697 7844.62770020099 6846.10234318801 4858.63257533074 2423.29035892796 417.804882840934 0 0 0 0 0 0 0 0 6.64380953417508 48.4820306239984 92.7635744535006 121.113971843586 133.533222794255 130.021327305507 110.578285377342 75.2040970097611 23.8987622027631 0 0 0 0 0 0 0 0 27.6298641391568 83.0580266850257 115.464066512101 37.8512631929836 0 22.0332041564798 604.300217421739 1634.0828638677 2794.83638185443 3678.08531007567 4095.16125367349 4042.49495730811 3462.76448528583 2414.8137783593 1200.11309547691 242.642732100053 0 0 0 0 0 0 0 0 0 0 0 0 546.056452717815 1428.50190147987 2286.81531305913 2881.15280571073 3136.63219578172 2986.54705867456 "
    "2466.7301779438 1619.59712301045 713.12902775122 79.1337964607008 0 0 0 0 0 0 0 0 0 34.9362717208327 100.422996432075 163.706364878408 184.575098033274 118.461565208879 57.8737510200977 145.435167859484 441.347950506323 878.652717536982 1285.74163576495 1563.3104759163 1679.0391052175 1578.95694755786 1254.90524003889 757.932619037051 282.530123944049 0 0 0 0 0 0 0 0 0 0 54.757898148401 225.022785320149 420.95868432105 584.424901255361 663.931591540784 659.478755177318 571.066392164964 398.694502503722 198.302844494373 38.6952030564243 0 0 0 0 0 0 0 0 37.6310254788343 91.9962408248083 128.656494354035 147.611786066513 148.862115962244 132.407484041227 98.2478903034627 46.3833347489505 0 0 0 0 0 0 0 0 18.9048317151187 198.336802378123 422.811895090383 613.581958406178 719.790485977849 726.548520246031 642.251383570247 484.06224465537 292.224921344322 135.10041439172 59.6607853460419 61.9697238948796 89.3677225535289 95.3564121984381 70.4656856865873 29.3031057433371 0 0 0 0 0 0 0 0 72.8596847285201 212.536288459262 338.325475341512 411.71925393129 432.717624228595 401.320586233428 317.528139945788 181.340285365676 48.5047272013061 0 0 0 0 0 0 0 12.1944489023346 61.7805279284924 125.775940830613 167.273470756335 186.273117705659 182.774881678584 156.77876267511 108.284760695237 37.2928757389665 0 0 0 0 0 0 0 0 31.5884733755828 64.2396407760941 75.6103801949598 96.2984707349944 131.180901587426 144.882042518029 137.401893526802 108.740454613746 66.8975819763326 47.100210798926 45.6210350623498 18.1080942931986 0 0 0 0 0 0 0 59.5816587790465 230.652348302739 415.425899905758 539.240583833281 590.577039456312 569.435266774851 475.815265788899 309.717036498454 126.052253634224 0 0 0 0 0 0 0 0 0 10.5455197065304 95.027884814567 194.582224456858 268.992840391217 305.658122029338 304.578069371221 265.752682416867 189.181961166275 87.617764417386 6.73598624276111 0 0 0 0 0 0 0 0 34.2775186747659 83.0839139498197 115.811670761286 132.460789109166 133.031268993458 "
    "117.523110414163 85.9363133712805 38.270877864811 2.03294948764621 0 0 0 0 0 0 0 20.7361541250091 81.5174369900932 154.642954330622 200.954109529793 220.450902587606 213.133333504061 179.001402279158 118.055108912897 44.9286549174702 0 0 0 0 0 0 0 0 0 0 1175.60362883881 3271.92094097715 5387.48495444289 6823.74224682784 7341.90300841412 6941.96723920174 5636.75586620374 3570.57116556907 1421.33291220462 0 0 0 0 0 0 29.8677362117457 86.4321563649567 125.192885000945 146.14992211971 149.303267721252 134.652921805571 102.198884372667 51.9411554225396 5.534518724277 0 0 0 0 0 0 1.1979221797489 35.0771644432228 76.6001009996676 120.550541911092 175.31891704995 202.830915651121 203.086537714605 176.085783240401 121.828652228509 72.7811578070367 33.579322370338 5.68504724747096 0 0 0 0 0 0 4.42587041966007 50.6183175751658 83.8689246188789 104.1776915508 97.624278639858 0 0 0 293.806318767698 1531.72592845997 3113.91667207304 4485.32607118122 5215.02744166946 5290.92615197811 4693.0773122294 3456.66844785464 1881.78746381284 507.838819597151 0 0 0 0 0 0 0 0 0 0 16.6549093606585 826.522035825502 1951.18283984489 2989.31958633814 3672.84738735386 3921.07225779998 3671.40922841603 2918.28798762679 1812.09725724512 728.92954992192 33.9887777119525 0 0 0 0 0 0 0 0 0 0 110.527367367332 616.008396104221 1220.04424607782 1706.55481085077 1974.33393909659 1990.12611869332 1753.93134964096 1265.74963193951 652.991835765351 147.028315048396 0 0 0 0 0 0 0 0 10.3992913163904 53.5146969526243 84.1045300677107 102.16879066165 107.707478734441 100.720594286085 81.2081373165816 49.1701078259306 4.6065058141321 0 0 0 0 0 98.8977144681492 360.265585163535 663.662392356181 889.575583042245 993.066799492827 972.307493160935 827.297664046567 558.037312149725 257.568803267046 32.6369105696957 0 0 0 0 0 0 0 0 0 0 42.4608933597734 170.069903998386 315.626871851497 437.516836455374 500.697514318364 499.846322155221 434.963259965946 306.346736490032 156.92121702252 36.2476489727313 0 0 0 0 0 0 0 0 0 "
    "43.6224250348853 163.79768311116 288.72156416175 365.728610663425 394.818822616186 375.992200020032 309.248742874964 194.58845118098 70.5408987832236 0 0 0 0 0 0 0 0 86.8159599393121 189.236274025657 256.906277743253 289.8259710921 287.995354072197 251.414426683546 180.083188926145 74.0016407999958 0 0 0 0 0 0 0 3.58734956043303 54.2839598755737 105.717722290324 138.868190952114 153.735365860946 150.319247016818 128.619834419731 88.6371280696843 30.3711279666785 0 0 0 0 0 0 0 6.53100639289909 54.638961898697 89.1233437633738 109.984151986929 117.221386569363 110.835047510676 90.8251348108679 57.1916484699383 9.93458848788743 0 0 0 0 0 0 0 33.0584345819788 89.8032842960668 153.045886842243 211.905966378592 239.720644579623 236.489921445335 202.213796975729 136.892271170805 73.3374977022896 22.7568971504976 0 0 0 0 0 0 0 0 43.5407071413695 105.970289074736 147.912516667293 169.367389919041 170.33490882998 150.815073400111 110.807883629432 50.3133395179445 0 0 0 0 0 0 0 0 0 439.979557206302 1593.18936367079 2864.44089364005 3808.5717510588 4218.42350544963 4095.0809859696 3467.86154526931 2376.6609459368 1130.37587718475 180.175223610618 0 0 2.78281863197032 56.6858717556045 19.5213488598804 0 0 0 0 0 0 0 0 48.8985675731739 116.403459633425 161.595425870313 184.474466283838 185.040580874001 163.2937696408 119.234032584237 52.861369704311 0.982750383568241 0 0 0 0 0 0 0 0 0 572.618193299544 1482.56456253289 2360.8765608068 2888.98916366313 3051.81250579748 2865.50242625405 2306.41330532253 1434.12906310607 559.849272472383 0 0 0 3.82009201227643 0.0351890439475344 23.9372966561839 78.5652297226698 112.290927984775 125.369835415642 123.415201253824 106.427025499321 74.4053081521342 27.3500492122623 0 0 0 0 0 0 0 3.73985980551834 41.9761580176009 90.6421347309103 122.64819634711 137.994342866199 136.680574288179 118.706890613049 84.0732918408088 32.7797779714588 0 0 0 0 0 0 0 0 34.9017970300777 0 0 25.3335784698695 488.467605164001 1185.1892574995 1867.74335716265 "
    "2236.29618394403 2349.87733601746 2240.18993827624 1872.10920114228 1217.61335921565 572.977511354815 173.248479847585 73.2865812928526 148.958372067183 203.796443805828 120.851101321774 61.7425951479753 27.9106073268365 0 0 0 0 0 0 0 0 0 82.145107313747 491.328872396118 1030.8879131326 1528.11916000971 1825.66690152398 1882.67061919099 1684.03670258067 1273.26038092055 764.558522293341 318.300070880454 50.5069618136172 0 47.7651298540734 103.141921107864 97.1473306153483 60.2800752510836 8.70475573417472 0 0 0 0 0 0 0 0 135.72455047394 373.705488049345 605.551220020215 746.781713668006 790.691992130592 737.282055407972 586.551903500146 351.21649991549 113.944046411759 0 0 0 56.0116909356107 113.78442023573 148.902358759811 164.018024826939 159.131418437113 134.242539590333 89.3513882865995 34.6311245009059 0 0 0 0 0 0 0 1.09717974184829 33.8876750385844 82.443207783021 144.746127717701 182.603932271748 196.016621445165 184.984195237949 141.623164214732 65.6447947397654 14.2843073064629 14.4086759340512 83.5553553654597 200.424144753765 312.000301583386 362.631992509037 367.42833942689 326.389342336944 239.515001239199 126.733025539727 27.9169846114579 0 0 0 0 0 0 0 5.43441178470781 36.2007669657817 88.0934995282226 122.808615090964 140.346113654006 140.705995217348 123.888259780991 89.8929073449337 38.7199379091774 5.41438385934538 0 0 0 0 0 0 0 12.2051578334995 58.4683967003456 116.123161013588 171.554837562543 219.707123905351 264.606686856641 306.959975200378 333.05881637182 333.980071203414 307.091727588005 265.867696090734 214.468648843832 152.384756910773 83.6223921342329 22.9342934134957 0 0 0 0 0 0 0 2.00747534834138 37.0035123669462 85.0002777170746 116.903416133427 132.712927616004 132.428812164805 116.05106977983 83.5797004610788 35.014704208552 1.67665384643838 0 0 0 0 0 0 0 31.9877546617201 89.6903783624823 157.836704280827 212.945307911693 237.737069012124 232.21198758212 196.370063621681 130.211297130807 66.228009239499 15.754650409405 0 0 0 0 0 0 0 "
    "0 19.4335710930101 77.7787673701217 143.266821161017 184.282042638961 200.824431803954 177.589369020262 129.232415935098 39.1077921051521 0 103.277397529229 403.399420678199 779.05466815086 1058.02409778942 1186.84561438216 1164.63961870242 991.406110750212 705.831767938076 346.862274987992 48.2918126744268 0 0 0 0 0 0 0 0 0 0 0 111.694128823448 478.956572099167 965.545141153404 1395.27832241103 1630.84791237713 1649.73058452473 1483.09285709408 1132.82607271066 652.912126163224 201.674341873133 0 0 0 0 0 0 0 0 0 58.2692925157521 326.163037991468 648.937007166011 923.369327714115 1087.33221168785 1125.05208834846 1037.2384348338 827.047219087471 527.668778781846 259.675303710368 105.296841067867 57.4812887409631 50.2044671332086 33.8363268303149 5.83775109066549 0 0 0 0 0 0 0 0 20.7610042189663 160.111334456153 365.708504025475 582.877028885421 750.612373654381 828.934899568002 796.694322812808 659.553058864354 454.625751628743 237.582098936423 68.3212800992953 0 0 0 0 0 0 0 0 0 0 72.4361492592694 210.604772394354 371.857622195513 501.792503196877 571.7057313719 566.310499747039 485.606808322293 346.468812778002 188.414271570308 57.1387147347688 0 0 0 0 0 33.8347077269653 115.724736282598 211.518525806063 276.303507771525 303.451049662415 292.96115147873 244.833813220471 159.069034887638 71.9798505378491 3.57355803376301 0 0 0 0 0 0 0 8.88527001867766 52.1853731595553 82.9961748812305 101.317675183703 107.149874066973 100.492771531041 81.3463675759055 49.7106622015679 5.58565540802778 0 0 0 0 0 0 0 46.5639350731056 118.0017206152 184.744858001496 223.133591409608 233.167920839537 210.202434939938 152.603542905865 79.7044675600279 37.2742177256337 49.482688957161 105.424342193248 152.039699954586 177.630247991958 172.252105143798 145.26517481237 96.6694569976735 38.2075192822721 0 0 0 0 0 0 0 0 0 47.3773529479554 149.003386028441 280.008940049818 394.866506189733 450.797308683951 447.801347532473 385.878622735297 284.323781509221 160.371151228329 46.6382443087917 0 0 "
    "0 0 0 0 0 0 32.1853336432041 137.235301055552 249.065328175649 318.93877661645 346.855646377955 332.815937460164 276.819649863076 178.866783586693 64.4540293233378 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.175211624109881 36.808372301933 94.9106612483383 134.141732098062 154.501584851103 155.990219507462 138.607636067139 102.353834530135 47.2288148964481 5.60245344966724 0 0 0 0 0 0 16.4139954893738 66.1098476312098 101.073073593887 121.303673377404 126.801646981762 117.56699440696 93.5997156529993 54.8998107198791 1.46727960759947 0 0 0 0 0 0 0 20.9757988847497 68.7749943233036 121.414741711739 153.883093418219 166.180049442745 158.305609785316 130.259774445932 82.0425434245931 27.3536630554911 0 0 0 0 0 0 0 9.94722930979337 53.5163274733893 84.4565742332619 102.767969589411 108.450513541837 101.50420609054 81.9290472355201 49.7250369767765 4.89217531430972 0 0 0 0 0 0 0.377568705098561 34.3604172571 82.2648068941557 145.42450587844 220.847678124488 290.617175620197 316.74618889513 299.234717949287 238.082762782668 172.353093891988 104.303450720015 41.8205796532975 0 0 0 0 0 0 0 0 35.5342825153769 84.0008679369946 116.430232370372 132.822375815509 133.177298272406 117.494999741063 85.7754802214793 38.0187397136554 0 0 0 0 0 0 0 0 38.9181557324105 114.448235963052 172.316959087665 204.780573811565 211.83908013475 193.492478057221 149.740767578979 80.5839487000223 13.4373319043424 0 0 0 0 0 0 0 4.86540343100099 44.0732968915036 91.9156244451349 123.163177347961 137.815955599983 135.873959201199 117.337188151611 82.2056424512174 30.4793221000191 0 0 0 0 0 0 0 4.22522666237575 45.396380871326 74.9973363276129 93.0280930312364 99.4886509821966 94.3790101804934 77.6991706261268 49.4491323190969 9.62889525940363 0 0 0 0 0 0 0 40.5989118811689 70.6051973285097 89.3582179640835 96.8579737878902 93.10446479993 78.0976910002027 51.8376523887084 14.3243489654471 0 0 0 0 8.29099005141177 53.3153146597055 85.4326674454695 104.643048408704 110.946457549409 104.342894867584 "
    "84.8323603632288 52.4148540363445 7.09037588693046 0 0 0 0 0 0 0 36.7837149880149 110.515281837303 197.405697518017 280.228906769297 321.327862897397 320.702565902319 278.353015784061 194.279212542625 107.633946131993 35.0922806390793 0 0 0 0 0 0 0 0 11.181934561207 66.5535750311293 132.926311181698 193.598643305141 225.454097827831 228.49267474977 202.714374070957 148.119195791391 79.8519263989999 20.0969424659001 0 0 0 0 0 0 0 0 26.8832586328465 82.2074864883244 150.792332326893 216.506510416667 271.510048321633 308.951690567123 301.589426747569 249.423256862969 182.937186465675 115.717427713888 59.510684460193 20.2191065363672 0 0 0 0 0 0 0 0 33.3414653786969 88.5367014069103 125.962790180198 145.619731698559 147.507525961994 131.626172970503 97.9756727240859 46.5560252227427 4.23358150740044 0 0 0 0 0 0 3.42657886851917 49.2175829338304 82.2248101579003 102.448260540729 109.887934082316 104.543830782661 86.4159506417653 55.5042936596281 11.8088598362493 0 0 0 0 0 0 0 41.4243658105811 115.63928578339 195.435300031186 248.845515964748 268.815589175636 255.345519663849 208.435307429387 128.084952472251 54.1913456060947 0.875803914103443 0 0 0 0 0 0 0 0 24.761390668251 74.4035534980969 123.045459204898 152.032808601717 161.365601688554 151.043838465408 121.06751893228 71.43664308917 23.6194370509861 0 0 0 0 0 0 0 0 22.684071467473 64.11917398804 119.834146103937 184.603234030984 220.044432135451 226.157740417338 202.943158876646 150.400687513374 88.758111380197 39.9298217346618 2.92701546906874 0 0 0 0 0 0 0 41.5713966209572 97.8711381392045 135.46978176446 154.367327496722 154.563775335992 136.05912528227 98.8533773355551 42.9465314958479 1.35647984929293 0 0 0 0 0 0 0 32.0626013340093 108.388358447379 200.436403110033 291.819774280895 369.480541771664 419.080530446726 425.607973467776 367.363782940489 279.528182272033 189.263289622771 112.669824240091 54.5868527783657 13.7881280147667 0 0 0 0 0 0 0 0 30.1614983832086 65.1483249619847 99.1833115868914 "
    "144.374720148829 207.260092817542 275.048872941024 329.039319445203 328.940659458543 300.835668212606 257.118857537116 197.292504584039 119.454253652435 42.4089856625714 0 0 0 0 0 0 0 0 29.1680765218669 78.4953168677839 111.985978631151 129.640061811967 131.457566410234 117.43849242595 87.5828398591154 41.8906087097309 3.86938721983576 0 0 0 0 0 0 0.733101122307076 37.8550097770069 86.428971368394 118.700183077014 134.668644902867 134.334356845954 117.697318906273 84.757531083825 35.5149933786102 1.52220203604172 0 0 0 0 0 0 8.45292350573416 57.6043649953562 92.7026826373902 113.747876431836 120.739946378694 113.678892477965 92.5647147296469 57.3974131337412 8.17698769024754 0 0 0 0 2.88802385663652 47.6229379649484 79.9122747319005 99.7560341574927 107.154216241725 102.106820984598 84.6138483861108 54.6752984462639 12.2911711650572 0 0 0 0 0 0 0 27.1472777964629 78.1575689071263 152.04203028112 235.461428342165 288.063381239528 300.96931055598 274.179216291521 207.69309844615 138.90055413235 67.1743435448421 8.97549975557477 0 0 0 0 0 0 0 0.490160499697275 39.383944424716 99.3751896500311 139.780186366368 160.598934573727 161.831434272108 143.477685461511 105.537688141936 48.0114423133832 4.88861130223127 0 0 0 0 0 0 0 43.2303805762515 112.882085342229 186.096194891941 229.470023770988 238.730800744259 208.196183389161 159.905899403534 116.345568143404 119.021454995607 144.759078481536 174.434771273242 200.157532912035 205.807727911534 172.670081967796 113.958844271573 40.4746310005099 0 0 0 0 0 0 0 4.06773141714247 50.091531606821 83.2273392043748 103.475154209804 110.834976623108 105.306806444288 86.8906436733433 55.5864883102737 11.3943403550794 0 0 0 0 0 0 0 36.5373672094101 99.7522864708534 169.776291391511 239.747220410612 300.184570348069 341.12941018129 355.282575451689 336.62260287625 310.935578424058 295.540268833543 268.401703058701 226.387737852154 174.909043638856 122.462230051036 72.734347221179 29.9801699765079 0 0 0 0 0 0 0 0.828471968501871 "
    "42.9976859637352 69.5927338500124 76.9957351862412 86.8404873223294 99.4744415994569 118.87400985042 154.355532025958 200.103215499914 255.699726202549 311.510108645424 345.340151735675 337.403262265079 323.865469161169 333.398563731801 355.556257519133 382.298637052238 397.818908229019 388.252807759461 341.887449571303 256.354957384941 151.610405128319 58.3127978842853 0 0 0 0 0 0 0 0 0 10.4152255113864 58.9387213789222 123.947577452048 174.638978437944 200.231006648991 200.723662085189 176.116944746538 126.410854633038 48.0447526055894 0 0 9.17944005152552 101.584808420746 219.497905846798 340.809218044325 408.92100656505 422.895657199246 382.733169946915 288.433544808057 176.096600619229 70.4678693295636 0 0 0 0 0 0 0 0 0 81.0412529365167 199.116906937464 335.935875241295 460.614439068419 517.985780089052 508.049898303195 430.806793710847 286.256466312009 156.341014088451 52.1927834535257 0 0 0 0 0 0 0 2.98129105290054 39.1958800273619 90.367176687245 124.39129780945 141.268243393976 140.998013440823 123.580607949993 89.0160269214835 37.3042703552957 1.76990887835313 0 0 0 0 0 0 8.45487029958158 52.7493535110723 84.3351914554765 103.212384132794 109.380931543026 102.840833686171 83.5920905622291 51.6347021712012 6.96866851308684 0 0 0 0 0 0 0"
    }
};

const size_t testDataSize = sizeof(testData) / sizeof(TestData);


vector<double> parseDoubleArray(const string& doubleArray)
{
    vector<double> doubleVector;
    vector<string> tokens;
    bal::split(tokens, doubleArray, bal::is_space(), bal::token_compress_on);
    if (!tokens.empty() && !tokens[0].empty())
        for (size_t i=0; i < tokens.size(); ++i)
            doubleVector.push_back(max(0.0, lexical_cast<double>(tokens[i])));
    return doubleVector;
}


void test()
{
    // test that invalid value exceptions are thrown

    // order too low
    /*unit_assert_throws_what(SavitzkyGolaySmoother(1, 15), runtime_error, \
        "[SavitzkyGolaySmoother::ctor()] Invalid value for polynomial order; valid range is [2, 20]");

    // order too high
    unit_assert_throws_what(SavitzkyGolaySmoother(21, 15), runtime_error, \
        "[SavitzkyGolaySmoother::ctor()] Invalid value for polynomial order; valid range is [2, 20]");

    // window size too small
    unit_assert_throws_what(SavitzkyGolaySmoother(2, 3), runtime_error, \
        "[SavitzkyGolaySmoother::ctor()] Invalid value for window size; value must be odd and in range [5, infinity)");

    // window size isn't odd
    unit_assert_throws_what(SavitzkyGolaySmoother(2, 6), runtime_error, \
        "[SavitzkyGolaySmoother::ctor()] Invalid value for window size; value must be odd and in range [5, infinity)");
*/
    SavitzkyGolaySmoother(2, 100001); // window size is valid up to numeric limits

    /*if (os_)
    {
        *os_ << "Unsmoothed data (" << testY.size() << "):\t";
        copy(testY.begin(), testY.end(), ostream_iterator<double>(*os_, "\t"));
        *os_ << endl;
    }*/

    /*if (os_)
    {
        *os_ << "Smoothed data (" << smoothData.size() << "):\t";
        copy(smoothData.begin(), smoothData.end(), ostream_iterator<double>(*os_, "\t"));
        *os_ << endl;
    }*/

    for (size_t i=0; i < testDataSize; ++i)
    {
        const TestData& data = testData[i];
        
        vector<double> xRaw = parseDoubleArray(data.xRaw);
        vector<double> yRaw = parseDoubleArray(data.yRaw);
        vector<double> targetSmoothedX = parseDoubleArray(data.xSmoothed);
        vector<double> targetSmoothedY = parseDoubleArray(data.ySmoothed);

        // sanity checks
        unit_assert(xRaw.size() == yRaw.size());
        unit_assert(targetSmoothedX.size() == targetSmoothedY.size());

        SavitzkyGolaySmoother smoother(data.polynomialOrder, data.windowSize);
        vector<double> smoothedX, smoothedY;
        smoother.smooth(xRaw, yRaw, smoothedX, smoothedY);

        unit_assert(smoothedX.size() == targetSmoothedX.size());
        unit_assert(smoothedY.size() == targetSmoothedY.size());

        for (size_t j=0; j < smoothedY.size(); ++j)
            unit_assert_equal(smoothedY[j], targetSmoothedY[j], 1e-5);
    }
}


int main(int argc, char* argv[])
{
    TEST_PROLOG(argc, argv)

    try
    {
        if (argc>1 && !strcmp(argv[1],"-v")) os_ = &cout;
        test();
    }
    catch (exception& e)
    {
        TEST_FAILED(e.what())
    }
    catch (...)
    {
        TEST_FAILED("Caught unknown exception.")
    }

    TEST_EPILOG
}
