C
C   Copyright (c) 1997 Silvano Bonazzola
C
C    This file is part of LORENE.
C
C    LORENE is free software; you can redistribute it and/or modify
C    it under the terms of the GNU General Public License as published by
C    the Free Software Foundation; either version 2 of the License, or
C    (at your option) any later version.
C
C    LORENE is distributed in the hope that it will be useful,
C    but WITHOUT ANY WARRANTY; without even the implied warranty of
C    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C    GNU General Public License for more details.
C
C    You should have received a copy of the GNU General Public License
C    along with LORENE; if not, write to the Free Software
C    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
C
C
	SUBROUTINE TRAXE1S(N1,NFIG,IFF1,IFF2,XX,CC)
C
C		ROUTINE SERVANT AU DESSIN D'UNE FAMILLE DES COURBES
C		EN FONCTION D'UN PARAMETRE. 
C
C		EN ENTREE:
C
C	N1=	NOMBRE DES DEGRES DE LIBERTE (N1=	N+1)
C	IF1,IF2=PARAMETRES QUI DEFINISSENT LE NOMBRES DE FIGURES QU'ON VEUT
C		AVOIR SUR L'ECRAN. (VOIR LA DOC DE PGBEGIN)
C
C		IF1,IF2 QUELCONQUE: UN DESSIN DANS TOUT L'ECRAN
C		IF1=1,IF2=2 L'ECRAN EST DIVISEE EN 2 EN y ET IL-Y-A 2 DESSIN
C			    SUR L'ECRAN
C		IF1=2,IF2=1 L'ECRAN EST DIVISE EN 2 EN x ET IL-Y-A 3 DESSIN
C			    SUR L'ECRAN
C		IF1=2 IF2=2 L'ECRAN EST DIVISE EN 4 ET IL-Y-A 4 DESSIN
C			    SUR L'ECRAN. LE RAPPORT ENTRE LA DIMENSION
C	                    VERTICALE ET HORIZONTALE DE L' IMAGE EST LA MEME
C			    QUE POUR IF1=1,IF2=1
C
C	NFIG=	NOMBRE DES COURBES DE LA FAMILLE.
C	X(L)=	VECTEUR DEFINISSANT LES ABSCISSES. (MAX(L)=NDESS)
C	CC   =	VECTEUR CONTENANT LES VALEURS DE LA JTH
C		COURBE.
C
C
C $Id: traxe1s.f,v 1.2 2012/03/30 12:12:44 j_novak Exp $
C $Log: traxe1s.f,v $
C Revision 1.2  2012/03/30 12:12:44  j_novak
C Cleaning of fortran files
C
C Revision 1.1.1.1  2001/11/20 15:19:30  e_gourgoulhon
C LORENE
C
c Revision 1.2  1997/10/21  12:57:14  eric
c Modif nom des routines PGPLOT up-to-date.
c
C Revision 1.1  1997/10/21 12:34:21  eric
C Initial revision
C
C
C $Header: /cvsroot/Lorene/F77/Source/Poisson2d/traxe1s.f,v 1.2 2012/03/30 12:12:44 j_novak Exp $
C
C
	character*120 header
	data header/'$Header: /cvsroot/Lorene/F77/Source/Poisson2d/traxe1s.f,v 1.2 2012/03/30 12:12:44 j_novak Exp $'/

	REAL*8	XX,CC

	DIMENSION XX(*),CC(*),YDES(1025,25),XD(1025,25),XDES(1025)
	DIMENSION YY(1025)

	data	init/0/
	save	init,ydes,xd,j,n

	NDIM=1025
	IF(N1.GT.NDIM) THEN
C
	PRINT*,'DIMENSIONS INSUFFISANTES DANS LA ROUTINE TRAXE0S.'
	CALL EXIT
	ENDIF
C
	IF1=IFF1
	IF2=IFF2
	IF(IFF1.NE.1.AND.IFF1.NE.2) IF1=1
	IF(IFF2.NE.1.AND.IFF2.NE.2) IF2=1
	NFIG1=NFIG+1
	IF(INIT.EQ.31415) GO TO 3
	J=0
	n = n1 !!!!!
	CALL PGBEGIN(1,'?',IF1,IF2)
	IF(IDIV.EQ.9.OR.IDIV.EQ.99) CALL PGSLW(3)	
	INIT=31415
3	CONTINUE
	J=J+1
	MARDES=0
	MARAX=0
	IF(NFIG.LT.25) GO TO 10
  200	FORMAT(10X,'NOMBRE DES COURBES=',I3,'  IL DOIT ETRE'
     ,	,'INFERIEUR A 10.')
	RETURN
  10	CONTINUE
	YMAX=-1.D+33
	YMIN=1.D+33
	ANORM=1
 104	FORMAT(1X,20I4)
	DO 13 L=1,N1
	YDES(L,J)=CC(L)
	XD(L,J)=XX(L)
  13	CONTINUE
	IF(J.LT.NFIG) RETURN
	DO 14 JJ=1,NFIG
	DO 8 L=1,N1
	IF(YDES(L,JJ).GT.YMAX) YMAX=YDES(L,JJ)
	IF(YDES(L,JJ).LT.YMIN) YMIN=YDES(L,JJ)
  8	CONTINUE
  14	CONTINUE
	IF(YMIN.GT.0.)YMIN=0
	ANORM=YMAX-YMIN
  	DX=(XX(N)-XX(1))/NFIG*1.5
  100	FORMAT(1X,'TRA',10E12.4)
  101	FORMAT(1X,'TR')
C
	IF(IND.EQ.0) GO TO 9
	DO 5 JL=1,NFIG
	DO 4 L=1,N1
	YT=YDES(L,JL)
	IF(YT.GT.YMAX) YMAX=YT
	IF(YT.LT.YMIN) YMIN=YT
  4	CONTINUE
  5	CONTINUE
	DY=(YMAX-YMIN)*.4/NFIG
	DO 7 JL=1,NFIG
	DO 6 L=1,N
	YDES(L,JL)=YDES(L,JL)+DY*(JL-1)
	XD(L,JL)=XX(L)+DX*(JL-1)
  6	CONTINUE
	XD(JL,NFIG1)=XD(1,JL)
	YDES(JL,NFIG1)=DY*(JL-1)
  7	CONTINUE
C
  9	CONTINUE
	IF(IND.EQ.0) NFIG1=NFIG
	XMIN=XX(1)
	XMAX=XX(N1)
	DY=(YMAX-YMIN)*0.05
	CALL PGSCH(1.375)
	CALL PGENV(XMIN,XMAX,YMIN-DY,YMAX+DY,0,0)
C	CALL PGADVANCE
C	CALL PGVSTAND
C	CALL PGWINDOW(XMIN,XMAX,YMIN-DY,YMAX+DY)
C	CALL PGBOX('BCTN',0.,11,'BCNST',0.,0)
C
	DO 2 JJ=1,NFIG1
	DO 15 L=1,N1
	XDES(L)=XD(L,JJ)
	YY(L)=YDES(L,JJ)
  15	CONTINUE
	XIMIN=XDES(1)
	XMAX=XDES(N1)
	CALL PGLINE(N1,XDES,YY)
	DO L=1,N1
	YY(L)=0
	ENDDO
	CALL PGLINE(N1,XDES,YY)
  2	CONTINUE
	J=0
	RETURN
	END
C
