// generated by Fast Light User Interface Designer (fluid) version 1.0107f

#include "WidgetPDial.h"
#include <cstdio>
#include <iostream>
#include <cmath>
#include <string>
#include <FL/Fl_Tooltip.H>
#include <FL/fl_draw.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Menu_Window.H>
#include "../Misc/Util.h"
//Copyright (c) 2003-2005 Nasca Octavian Paul
//License: GNU GPL version 2 or later

using namespace std;

class TipWin:public Fl_Menu_Window
{
    public:
        TipWin();
        void draw();
        void showValue(float f);
        void setText(const char *c);
        void showText();
    private:
        void redraw();
        const char *getStr() const;
        string tip;
        string text;
        bool   textmode;
};

TipWin::TipWin():Fl_Menu_Window(1, 1)
{
    set_override();
    end();
}

void TipWin::draw()
{
    //setup window
    draw_box(FL_BORDER_BOX, 0, 0, w(), h(), Fl_Color(175));
    fl_color(Fl_Tooltip::textcolor());
    fl_font(labelfont(), labelsize());

    //Draw the current string
    fl_draw(getStr(), 3, 3, w() - 6, h() - 6,
            Fl_Align(FL_ALIGN_LEFT | FL_ALIGN_WRAP));
}

void TipWin::showValue(float f)
{
    //convert the value to a string
    char tmp[10];
    snprintf(tmp, 9, "%.2f", f);
    tip = tmp;

    textmode = false;
    redraw();
    show();
}

void TipWin::setText(const char *c)
{
    text     = c;
    textmode = true;
    redraw();
}

void TipWin::showText()
{
    if(!text.empty()) {
        textmode = true;
        redraw();
        show();
    }
}

void TipWin::redraw()
{
    // Recalc size of window
    fl_font(labelfont(), labelsize());
    int W = 0, H = 0;
    fl_measure(getStr(), W, H, 0);
    //provide a bit of extra space
    W += 8;
    H += 4;
    size(W, H);
    Fl_Menu_Window::redraw();
}

const char *TipWin::getStr() const
{
    return (textmode ? text : tip).c_str();
}

//static int numobj = 0;

WidgetPDial::WidgetPDial(int x, int y, int w, int h, const char *label)
    :Fl_Dial(x, y, w, h, label), oldvalue(0.0f), pos(false), textset(false)
{
    //cout << "[" << label << "] There are now " << ++numobj << endl;
    Fl_Group *save = Fl_Group::current();
    tipwin = new TipWin();
    tipwin->hide();
    Fl_Group::current(save);
}

WidgetPDial::~WidgetPDial()
{
    //cout << "There are now " << --numobj << endl;
    delete tipwin;
}

int WidgetPDial::handle(int event)
{
//#ifdef NTK_GUI
//    return Fl_Dial::handle( event );
//#else
    double dragsize, min = minimum(), max = maximum();
    int    my;

    switch(event) {
        case FL_PUSH:
            oldvalue = value();
        case FL_DRAG:
            getPos();
            my = -(Fl::event_y() - y() - h() / 2);

            dragsize = 200.0f;
            if(Fl::event_state(FL_BUTTON1) == 0)
                dragsize *= 10;

            value(limit(oldvalue + my / dragsize * (max - min), min, max));
            tipwin->showValue(value());
            value_damage();
            if(this->when() != 0)
                do_callback();
            return 1;
        case FL_MOUSEWHEEL:
            if (Fl::belowmouse() != this)
                return 1;
            my = - Fl::event_dy();

            dragsize = 200.0f;
            if(Fl::event_state(FL_CTRL) != 0)
                dragsize *= 10;

            value(limit(value() + my / dragsize * (max - min), min, max));
            tipwin->showValue(value());
            value_damage();
            if(this->when() != 0)
                do_callback();
            return 1;
        case FL_ENTER:
            getPos();
            tipwin->showText();
            return 1;
        case FL_HIDE:
        case FL_LEAVE:
            tipwin->hide();
            resetPos();
            break;
        case FL_RELEASE:
            tipwin->hide();
            resetPos();
            if(this->when() == 0)
                do_callback();
            return 1;
            break;
    }
    return 0;
//#endif
}

void WidgetPDial::draw()
{
#ifdef NTK_GUI
    box( FL_NO_BOX );

    Fl_Dial::draw();
    
    return;
#else
    const int cx = x(), cy = y(), sx = w(), sy = h();
    const double a1 = angle1(), a2 = angle2();
    const double val = (value() - minimum()) / (maximum() - minimum());
    // even radius produces less artifacts if no antialiasing is avail
    const int rad = (sx > sy ? sy : sx) &~1;

    /* clears the button background */
    pdialcolor(160, 160, 160);
    fl_pie(cx - 2, cy - 2, rad + 4, rad + 4, 0, 360);

    /* dark outline */
    fl_color(60, 60, 60);
    fl_pie(cx - 1, cy - 1, rad + 2, rad + 2, 0, 360);

    /* Draws the button faceplate, min/max */
    pdialcolor(110, 110, 115);
    fl_pie(cx, cy, rad, rad, 270 - a2, 270 - a1);

    /* knob center */
    if (rad > 8) {
        pdialcolor(140, 140, 145);
        fl_pie(cx + 4, cy + 4, rad - 8, rad - 8, 0, 360);
    }

    /* value circle */
    double a = -(a2 - a1) * val - a1;
    fl_line_style(0, 2, 0);
    pdialcolor(0, 200, 0);
    fl_arc(cx + 1, cy + 1, rad - 2, rad - 2, a - 90, a1 - 180);
    fl_line_style(0);

    /* draw value line */
    int ll = rad/4;
    if (ll < 2) ll = 2;

    fl_push_matrix();

    fl_translate(cx + rad / 2, cy + rad / 2);
    fl_rotate(a - 90.0f);

    fl_translate(rad / 2, 0);

    fl_begin_polygon();
    pdialcolor(0, 0, 0);
    fl_vertex(-ll, 0);
    fl_vertex(0, 0);
    fl_end_polygon();

    fl_pop_matrix();

#endif
}

void WidgetPDial::pdialcolor(int r, int g, int b)
{
    if(active_r())
        fl_color(r, g, b);
    else
        fl_color(160 - (160 - r) / 3, 160 - (160 - b) / 3, 160 - (160 - b) / 3);
}

void WidgetPDial::tooltip(const char *c)
{
    tipwin->setText(c);
    textset = true;
}

void WidgetPDial::getPos()
{
    if(!pos) {
        tipwin->position(Fl::event_x_root(), Fl::event_y_root() + 20);
        pos = true;
    }
}

void WidgetPDial::resetPos()
{
    pos = false;
}
