
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextCursor.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTextCursor>
#include <QImage>
#include <QTextBlock>
#include <QTextBlockFormat>
#include <QTextCharFormat>
#include <QTextDocument>
#include <QTextDocumentFragment>
#include <QTextFrame>
#include <QTextFrameFormat>
#include <QTextImageFormat>
#include <QTextList>
#include <QTextListFormat>
#include <QTextTable>
#include <QTextTableFormat>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextCursor

//  Constructor QTextCursor::QTextCursor()


static void _init_ctor_QTextCursor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTextCursor> ();
}

static void _call_ctor_QTextCursor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextCursor *> (new QTextCursor ());
}


//  Constructor QTextCursor::QTextCursor(QTextDocument *document)


static void _init_ctor_QTextCursor_1955 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("document");
  decl->add_arg<QTextDocument * > (argspec_0);
  decl->set_return_new<QTextCursor> ();
}

static void _call_ctor_QTextCursor_1955 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextDocument *arg1 = gsi::arg_reader<QTextDocument * >() (args, heap);
  ret.write<QTextCursor *> (new QTextCursor (arg1));
}


//  Constructor QTextCursor::QTextCursor(QTextFrame *frame)


static void _init_ctor_QTextCursor_1615 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frame");
  decl->add_arg<QTextFrame * > (argspec_0);
  decl->set_return_new<QTextCursor> ();
}

static void _call_ctor_QTextCursor_1615 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextFrame *arg1 = gsi::arg_reader<QTextFrame * >() (args, heap);
  ret.write<QTextCursor *> (new QTextCursor (arg1));
}


//  Constructor QTextCursor::QTextCursor(const QTextBlock &block)


static void _init_ctor_QTextCursor_2306 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return_new<QTextCursor> ();
}

static void _call_ctor_QTextCursor_2306 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlock &arg1 = gsi::arg_reader<const QTextBlock & >() (args, heap);
  ret.write<QTextCursor *> (new QTextCursor (arg1));
}


//  Constructor QTextCursor::QTextCursor(const QTextCursor &cursor)


static void _init_ctor_QTextCursor_2453 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return_new<QTextCursor> ();
}

static void _call_ctor_QTextCursor_2453 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  ret.write<QTextCursor *> (new QTextCursor (arg1));
}


// int QTextCursor::anchor()


static void _init_f_anchor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_anchor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextCursor *)cls)->anchor ());
}


// bool QTextCursor::atBlockEnd()


static void _init_f_atBlockEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atBlockEnd_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCursor *)cls)->atBlockEnd ());
}


// bool QTextCursor::atBlockStart()


static void _init_f_atBlockStart_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atBlockStart_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCursor *)cls)->atBlockStart ());
}


// bool QTextCursor::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCursor *)cls)->atEnd ());
}


// bool QTextCursor::atStart()


static void _init_f_atStart_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atStart_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCursor *)cls)->atStart ());
}


// void QTextCursor::beginEditBlock()


static void _init_f_beginEditBlock_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_beginEditBlock_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->beginEditBlock ();
}


// QTextBlock QTextCursor::block()


static void _init_f_block_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlock > ();
}

static void _call_f_block_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextBlock > ((QTextBlock)((QTextCursor *)cls)->block ());
}


// QTextCharFormat QTextCursor::blockCharFormat()


static void _init_f_blockCharFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCharFormat > ();
}

static void _call_f_blockCharFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextCharFormat > ((QTextCharFormat)((QTextCursor *)cls)->blockCharFormat ());
}


// QTextBlockFormat QTextCursor::blockFormat()


static void _init_f_blockFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlockFormat > ();
}

static void _call_f_blockFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextBlockFormat > ((QTextBlockFormat)((QTextCursor *)cls)->blockFormat ());
}


// int QTextCursor::blockNumber()


static void _init_f_blockNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_blockNumber_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextCursor *)cls)->blockNumber ());
}


// QTextCharFormat QTextCursor::charFormat()


static void _init_f_charFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCharFormat > ();
}

static void _call_f_charFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextCharFormat > ((QTextCharFormat)((QTextCursor *)cls)->charFormat ());
}


// void QTextCursor::clearSelection()


static void _init_f_clearSelection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearSelection_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->clearSelection ();
}


// int QTextCursor::columnNumber()


static void _init_f_columnNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_columnNumber_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextCursor *)cls)->columnNumber ());
}


// QTextList *QTextCursor::createList(const QTextListFormat &format)


static void _init_f_createList_2844 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextListFormat & > (argspec_0);
  decl->set_return<QTextList * > ();
}

static void _call_f_createList_2844 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextListFormat &arg1 = gsi::arg_reader<const QTextListFormat & >() (args, heap);
  ret.write<QTextList * > ((QTextList *)((QTextCursor *)cls)->createList (arg1));
}


// QTextList *QTextCursor::createList(QTextListFormat::Style style)


static void _init_f_createList_2612 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<QTextListFormat::Style>::target_type & > (argspec_0);
  decl->set_return<QTextList * > ();
}

static void _call_f_createList_2612 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextListFormat::Style>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTextListFormat::Style>::target_type & >() (args, heap);
  ret.write<QTextList * > ((QTextList *)((QTextCursor *)cls)->createList (qt_gsi::QtToCppAdaptor<QTextListFormat::Style>(arg1).cref()));
}


// QTextFrame *QTextCursor::currentFrame()


static void _init_f_currentFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextFrame * > ();
}

static void _call_f_currentFrame_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextFrame * > ((QTextFrame *)((QTextCursor *)cls)->currentFrame ());
}


// QTextList *QTextCursor::currentList()


static void _init_f_currentList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextList * > ();
}

static void _call_f_currentList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextList * > ((QTextList *)((QTextCursor *)cls)->currentList ());
}


// QTextTable *QTextCursor::currentTable()


static void _init_f_currentTable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextTable * > ();
}

static void _call_f_currentTable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextTable * > ((QTextTable *)((QTextCursor *)cls)->currentTable ());
}


// void QTextCursor::deleteChar()


static void _init_f_deleteChar_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_deleteChar_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->deleteChar ();
}


// void QTextCursor::deletePreviousChar()


static void _init_f_deletePreviousChar_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_deletePreviousChar_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->deletePreviousChar ();
}


// QTextDocument *QTextCursor::document()


static void _init_f_document_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextDocument * > ();
}

static void _call_f_document_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextDocument * > ((QTextDocument *)((QTextCursor *)cls)->document ());
}


// void QTextCursor::endEditBlock()


static void _init_f_endEditBlock_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_endEditBlock_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->endEditBlock ();
}


// bool QTextCursor::hasComplexSelection()


static void _init_f_hasComplexSelection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasComplexSelection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCursor *)cls)->hasComplexSelection ());
}


// bool QTextCursor::hasSelection()


static void _init_f_hasSelection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasSelection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCursor *)cls)->hasSelection ());
}


// void QTextCursor::insertBlock()


static void _init_f_insertBlock_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_insertBlock_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->insertBlock ();
}


// void QTextCursor::insertBlock(const QTextBlockFormat &format)


static void _init_f_insertBlock_2923 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextBlockFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertBlock_2923 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlockFormat &arg1 = gsi::arg_reader<const QTextBlockFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->insertBlock (arg1);
}


// void QTextCursor::insertBlock(const QTextBlockFormat &format, const QTextCharFormat &charFormat)


static void _init_f_insertBlock_5629 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextBlockFormat & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("charFormat");
  decl->add_arg<const QTextCharFormat & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertBlock_5629 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlockFormat &arg1 = gsi::arg_reader<const QTextBlockFormat & >() (args, heap);
  const QTextCharFormat &arg2 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->insertBlock (arg1, arg2);
}


// void QTextCursor::insertFragment(const QTextDocumentFragment &fragment)


static void _init_f_insertFragment_3466 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fragment");
  decl->add_arg<const QTextDocumentFragment & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertFragment_3466 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextDocumentFragment &arg1 = gsi::arg_reader<const QTextDocumentFragment & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->insertFragment (arg1);
}


// QTextFrame *QTextCursor::insertFrame(const QTextFrameFormat &format)


static void _init_f_insertFrame_2923 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextFrameFormat & > (argspec_0);
  decl->set_return<QTextFrame * > ();
}

static void _call_f_insertFrame_2923 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextFrameFormat &arg1 = gsi::arg_reader<const QTextFrameFormat & >() (args, heap);
  ret.write<QTextFrame * > ((QTextFrame *)((QTextCursor *)cls)->insertFrame (arg1));
}


// void QTextCursor::insertHtml(const QString &html)


static void _init_f_insertHtml_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("html");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertHtml_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->insertHtml (arg1);
}


// void QTextCursor::insertImage(const QTextImageFormat &format, QTextFrameFormat::Position alignment)


static void _init_f_insertImage_5822 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextImageFormat & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QTextFrameFormat::Position>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertImage_5822 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextImageFormat &arg1 = gsi::arg_reader<const QTextImageFormat & >() (args, heap);
  const qt_gsi::Converter<QTextFrameFormat::Position>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QTextFrameFormat::Position>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->insertImage (arg1, qt_gsi::QtToCppAdaptor<QTextFrameFormat::Position>(arg2).cref());
}


// void QTextCursor::insertImage(const QTextImageFormat &format)


static void _init_f_insertImage_2915 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextImageFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertImage_2915 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextImageFormat &arg1 = gsi::arg_reader<const QTextImageFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->insertImage (arg1);
}


// void QTextCursor::insertImage(const QString &name)


static void _init_f_insertImage_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertImage_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->insertImage (arg1);
}


// void QTextCursor::insertImage(const QImage &image, const QString &name)


static void _init_f_insertImage_3794 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<const QImage & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertImage_3794 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImage &arg1 = gsi::arg_reader<const QImage & >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->insertImage (arg1, arg2);
}


// QTextList *QTextCursor::insertList(const QTextListFormat &format)


static void _init_f_insertList_2844 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextListFormat & > (argspec_0);
  decl->set_return<QTextList * > ();
}

static void _call_f_insertList_2844 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextListFormat &arg1 = gsi::arg_reader<const QTextListFormat & >() (args, heap);
  ret.write<QTextList * > ((QTextList *)((QTextCursor *)cls)->insertList (arg1));
}


// QTextList *QTextCursor::insertList(QTextListFormat::Style style)


static void _init_f_insertList_2612 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<QTextListFormat::Style>::target_type & > (argspec_0);
  decl->set_return<QTextList * > ();
}

static void _call_f_insertList_2612 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextListFormat::Style>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTextListFormat::Style>::target_type & >() (args, heap);
  ret.write<QTextList * > ((QTextList *)((QTextCursor *)cls)->insertList (qt_gsi::QtToCppAdaptor<QTextListFormat::Style>(arg1).cref()));
}


// QTextTable *QTextCursor::insertTable(int rows, int cols, const QTextTableFormat &format)


static void _init_f_insertTable_4238 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rows");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cols");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format");
  decl->add_arg<const QTextTableFormat & > (argspec_2);
  decl->set_return<QTextTable * > ();
}

static void _call_f_insertTable_4238 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QTextTableFormat &arg3 = gsi::arg_reader<const QTextTableFormat & >() (args, heap);
  ret.write<QTextTable * > ((QTextTable *)((QTextCursor *)cls)->insertTable (arg1, arg2, arg3));
}


// QTextTable *QTextCursor::insertTable(int rows, int cols)


static void _init_f_insertTable_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rows");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cols");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QTextTable * > ();
}

static void _call_f_insertTable_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTextTable * > ((QTextTable *)((QTextCursor *)cls)->insertTable (arg1, arg2));
}


// void QTextCursor::insertText(const QString &text)


static void _init_f_insertText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->insertText (arg1);
}


// void QTextCursor::insertText(const QString &text, const QTextCharFormat &format)


static void _init_f_insertText_4731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertText_4731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QTextCharFormat &arg2 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->insertText (arg1, arg2);
}


// bool QTextCursor::isCopyOf(const QTextCursor &other)


static void _init_f_isCopyOf_c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isCopyOf_c2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  ret.write<bool > ((bool)((QTextCursor *)cls)->isCopyOf (arg1));
}


// bool QTextCursor::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCursor *)cls)->isNull ());
}


// void QTextCursor::joinPreviousEditBlock()


static void _init_f_joinPreviousEditBlock_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_joinPreviousEditBlock_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->joinPreviousEditBlock ();
}


// void QTextCursor::mergeBlockCharFormat(const QTextCharFormat &modifier)


static void _init_f_mergeBlockCharFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("modifier");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mergeBlockCharFormat_2814 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCharFormat &arg1 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->mergeBlockCharFormat (arg1);
}


// void QTextCursor::mergeBlockFormat(const QTextBlockFormat &modifier)


static void _init_f_mergeBlockFormat_2923 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("modifier");
  decl->add_arg<const QTextBlockFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mergeBlockFormat_2923 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlockFormat &arg1 = gsi::arg_reader<const QTextBlockFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->mergeBlockFormat (arg1);
}


// void QTextCursor::mergeCharFormat(const QTextCharFormat &modifier)


static void _init_f_mergeCharFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("modifier");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mergeCharFormat_2814 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCharFormat &arg1 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->mergeCharFormat (arg1);
}


// bool QTextCursor::movePosition(QTextCursor::MoveOperation op, QTextCursor::MoveMode, int n)


static void _init_f_movePosition_6083 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("op");
  decl->add_arg<const qt_gsi::Converter<QTextCursor::MoveOperation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2", true, "QTextCursor::MoveAnchor");
  decl->add_arg<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_movePosition_6083 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextCursor::MoveOperation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTextCursor::MoveOperation>::target_type & >() (args, heap);
  const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QTextCursor::MoveMode>(heap, QTextCursor::MoveAnchor), heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  ret.write<bool > ((bool)((QTextCursor *)cls)->movePosition (qt_gsi::QtToCppAdaptor<QTextCursor::MoveOperation>(arg1).cref(), qt_gsi::QtToCppAdaptor<QTextCursor::MoveMode>(arg2).cref(), arg3));
}


// bool QTextCursor::operator!=(const QTextCursor &rhs)


static void _init_f_operator_excl__eq__c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  ret.write<bool > ((bool)((QTextCursor *)cls)->operator!= (arg1));
}


// bool QTextCursor::operator<(const QTextCursor &rhs)


static void _init_f_operator_lt__c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__c2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  ret.write<bool > ((bool)((QTextCursor *)cls)->operator< (arg1));
}


// bool QTextCursor::operator<=(const QTextCursor &rhs)


static void _init_f_operator_lt__eq__c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__eq__c2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  ret.write<bool > ((bool)((QTextCursor *)cls)->operator<= (arg1));
}


// QTextCursor &QTextCursor::operator=(const QTextCursor &other)


static void _init_f_operator_eq__2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<QTextCursor & > ();
}

static void _call_f_operator_eq__2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  ret.write<QTextCursor & > ((QTextCursor &)((QTextCursor *)cls)->operator= (arg1));
}


// bool QTextCursor::operator==(const QTextCursor &rhs)


static void _init_f_operator_eq__eq__c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  ret.write<bool > ((bool)((QTextCursor *)cls)->operator== (arg1));
}


// bool QTextCursor::operator>(const QTextCursor &rhs)


static void _init_f_operator_gt__c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_gt__c2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  ret.write<bool > ((bool)((QTextCursor *)cls)->operator> (arg1));
}


// bool QTextCursor::operator>=(const QTextCursor &rhs)


static void _init_f_operator_gt__eq__c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_gt__eq__c2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  ret.write<bool > ((bool)((QTextCursor *)cls)->operator>= (arg1));
}


// int QTextCursor::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextCursor *)cls)->position ());
}


// void QTextCursor::removeSelectedText()


static void _init_f_removeSelectedText_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_removeSelectedText_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->removeSelectedText ();
}


// void QTextCursor::select(QTextCursor::SelectionType selection)


static void _init_f_select_3044 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const qt_gsi::Converter<QTextCursor::SelectionType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_select_3044 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextCursor::SelectionType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTextCursor::SelectionType>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->select (qt_gsi::QtToCppAdaptor<QTextCursor::SelectionType>(arg1).cref());
}


// void QTextCursor::selectedTableCells(int *firstRow, int *numRows, int *firstColumn, int *numColumns)


static void _init_f_selectedTableCells_c3488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("firstRow");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("numRows");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("firstColumn");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("numColumns");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_selectedTableCells_c3488 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int *arg1 = gsi::arg_reader<int * >() (args, heap);
  int *arg2 = gsi::arg_reader<int * >() (args, heap);
  int *arg3 = gsi::arg_reader<int * >() (args, heap);
  int *arg4 = gsi::arg_reader<int * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->selectedTableCells (arg1, arg2, arg3, arg4);
}


// QString QTextCursor::selectedText()


static void _init_f_selectedText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_selectedText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextCursor *)cls)->selectedText ());
}


// QTextDocumentFragment QTextCursor::selection()


static void _init_f_selection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextDocumentFragment > ();
}

static void _call_f_selection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextDocumentFragment > ((QTextDocumentFragment)((QTextCursor *)cls)->selection ());
}


// int QTextCursor::selectionEnd()


static void _init_f_selectionEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_selectionEnd_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextCursor *)cls)->selectionEnd ());
}


// int QTextCursor::selectionStart()


static void _init_f_selectionStart_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_selectionStart_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextCursor *)cls)->selectionStart ());
}


// void QTextCursor::setBlockCharFormat(const QTextCharFormat &format)


static void _init_f_setBlockCharFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBlockCharFormat_2814 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCharFormat &arg1 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->setBlockCharFormat (arg1);
}


// void QTextCursor::setBlockFormat(const QTextBlockFormat &format)


static void _init_f_setBlockFormat_2923 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextBlockFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBlockFormat_2923 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlockFormat &arg1 = gsi::arg_reader<const QTextBlockFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->setBlockFormat (arg1);
}


// void QTextCursor::setCharFormat(const QTextCharFormat &format)


static void _init_f_setCharFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCharFormat_2814 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCharFormat &arg1 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->setCharFormat (arg1);
}


// void QTextCursor::setPosition(int pos, QTextCursor::MoveMode mode)


static void _init_f_setPosition_3147 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QTextCursor::MoveAnchor");
  decl->add_arg<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPosition_3147 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QTextCursor::MoveMode>(heap, QTextCursor::MoveAnchor), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->setPosition (arg1, qt_gsi::QtToCppAdaptor<QTextCursor::MoveMode>(arg2).cref());
}


// void QTextCursor::setVisualNavigation(bool b)


static void _init_f_setVisualNavigation_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisualNavigation_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCursor *)cls)->setVisualNavigation (arg1);
}


// bool QTextCursor::visualNavigation()


static void _init_f_visualNavigation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_visualNavigation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCursor *)cls)->visualNavigation ());
}



namespace gsi
{

static gsi::Methods methods_QTextCursor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextCursor::QTextCursor()\nThis method creates an object of class QTextCursor.", &_init_ctor_QTextCursor_0, &_call_ctor_QTextCursor_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextCursor::QTextCursor(QTextDocument *document)\nThis method creates an object of class QTextCursor.", &_init_ctor_QTextCursor_1955, &_call_ctor_QTextCursor_1955);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextCursor::QTextCursor(QTextFrame *frame)\nThis method creates an object of class QTextCursor.", &_init_ctor_QTextCursor_1615, &_call_ctor_QTextCursor_1615);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextCursor::QTextCursor(const QTextBlock &block)\nThis method creates an object of class QTextCursor.", &_init_ctor_QTextCursor_2306, &_call_ctor_QTextCursor_2306);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextCursor::QTextCursor(const QTextCursor &cursor)\nThis method creates an object of class QTextCursor.", &_init_ctor_QTextCursor_2453, &_call_ctor_QTextCursor_2453);
  methods += new qt_gsi::GenericMethod ("anchor", "@brief Method int QTextCursor::anchor()\n", true, &_init_f_anchor_c0, &_call_f_anchor_c0);
  methods += new qt_gsi::GenericMethod ("atBlockEnd", "@brief Method bool QTextCursor::atBlockEnd()\n", true, &_init_f_atBlockEnd_c0, &_call_f_atBlockEnd_c0);
  methods += new qt_gsi::GenericMethod ("atBlockStart", "@brief Method bool QTextCursor::atBlockStart()\n", true, &_init_f_atBlockStart_c0, &_call_f_atBlockStart_c0);
  methods += new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QTextCursor::atEnd()\n", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
  methods += new qt_gsi::GenericMethod ("atStart", "@brief Method bool QTextCursor::atStart()\n", true, &_init_f_atStart_c0, &_call_f_atStart_c0);
  methods += new qt_gsi::GenericMethod ("beginEditBlock", "@brief Method void QTextCursor::beginEditBlock()\n", false, &_init_f_beginEditBlock_0, &_call_f_beginEditBlock_0);
  methods += new qt_gsi::GenericMethod ("block", "@brief Method QTextBlock QTextCursor::block()\n", true, &_init_f_block_c0, &_call_f_block_c0);
  methods += new qt_gsi::GenericMethod (":blockCharFormat", "@brief Method QTextCharFormat QTextCursor::blockCharFormat()\n", true, &_init_f_blockCharFormat_c0, &_call_f_blockCharFormat_c0);
  methods += new qt_gsi::GenericMethod (":blockFormat", "@brief Method QTextBlockFormat QTextCursor::blockFormat()\n", true, &_init_f_blockFormat_c0, &_call_f_blockFormat_c0);
  methods += new qt_gsi::GenericMethod ("blockNumber", "@brief Method int QTextCursor::blockNumber()\n", true, &_init_f_blockNumber_c0, &_call_f_blockNumber_c0);
  methods += new qt_gsi::GenericMethod (":charFormat", "@brief Method QTextCharFormat QTextCursor::charFormat()\n", true, &_init_f_charFormat_c0, &_call_f_charFormat_c0);
  methods += new qt_gsi::GenericMethod ("clearSelection", "@brief Method void QTextCursor::clearSelection()\n", false, &_init_f_clearSelection_0, &_call_f_clearSelection_0);
  methods += new qt_gsi::GenericMethod ("columnNumber", "@brief Method int QTextCursor::columnNumber()\n", true, &_init_f_columnNumber_c0, &_call_f_columnNumber_c0);
  methods += new qt_gsi::GenericMethod ("createList", "@brief Method QTextList *QTextCursor::createList(const QTextListFormat &format)\n", false, &_init_f_createList_2844, &_call_f_createList_2844);
  methods += new qt_gsi::GenericMethod ("createList", "@brief Method QTextList *QTextCursor::createList(QTextListFormat::Style style)\n", false, &_init_f_createList_2612, &_call_f_createList_2612);
  methods += new qt_gsi::GenericMethod ("currentFrame", "@brief Method QTextFrame *QTextCursor::currentFrame()\n", true, &_init_f_currentFrame_c0, &_call_f_currentFrame_c0);
  methods += new qt_gsi::GenericMethod ("currentList", "@brief Method QTextList *QTextCursor::currentList()\n", true, &_init_f_currentList_c0, &_call_f_currentList_c0);
  methods += new qt_gsi::GenericMethod ("currentTable", "@brief Method QTextTable *QTextCursor::currentTable()\n", true, &_init_f_currentTable_c0, &_call_f_currentTable_c0);
  methods += new qt_gsi::GenericMethod ("deleteChar", "@brief Method void QTextCursor::deleteChar()\n", false, &_init_f_deleteChar_0, &_call_f_deleteChar_0);
  methods += new qt_gsi::GenericMethod ("deletePreviousChar", "@brief Method void QTextCursor::deletePreviousChar()\n", false, &_init_f_deletePreviousChar_0, &_call_f_deletePreviousChar_0);
  methods += new qt_gsi::GenericMethod ("document", "@brief Method QTextDocument *QTextCursor::document()\n", true, &_init_f_document_c0, &_call_f_document_c0);
  methods += new qt_gsi::GenericMethod ("endEditBlock", "@brief Method void QTextCursor::endEditBlock()\n", false, &_init_f_endEditBlock_0, &_call_f_endEditBlock_0);
  methods += new qt_gsi::GenericMethod ("hasComplexSelection", "@brief Method bool QTextCursor::hasComplexSelection()\n", true, &_init_f_hasComplexSelection_c0, &_call_f_hasComplexSelection_c0);
  methods += new qt_gsi::GenericMethod ("hasSelection", "@brief Method bool QTextCursor::hasSelection()\n", true, &_init_f_hasSelection_c0, &_call_f_hasSelection_c0);
  methods += new qt_gsi::GenericMethod ("insertBlock", "@brief Method void QTextCursor::insertBlock()\n", false, &_init_f_insertBlock_0, &_call_f_insertBlock_0);
  methods += new qt_gsi::GenericMethod ("insertBlock", "@brief Method void QTextCursor::insertBlock(const QTextBlockFormat &format)\n", false, &_init_f_insertBlock_2923, &_call_f_insertBlock_2923);
  methods += new qt_gsi::GenericMethod ("insertBlock", "@brief Method void QTextCursor::insertBlock(const QTextBlockFormat &format, const QTextCharFormat &charFormat)\n", false, &_init_f_insertBlock_5629, &_call_f_insertBlock_5629);
  methods += new qt_gsi::GenericMethod ("insertFragment", "@brief Method void QTextCursor::insertFragment(const QTextDocumentFragment &fragment)\n", false, &_init_f_insertFragment_3466, &_call_f_insertFragment_3466);
  methods += new qt_gsi::GenericMethod ("insertFrame", "@brief Method QTextFrame *QTextCursor::insertFrame(const QTextFrameFormat &format)\n", false, &_init_f_insertFrame_2923, &_call_f_insertFrame_2923);
  methods += new qt_gsi::GenericMethod ("insertHtml", "@brief Method void QTextCursor::insertHtml(const QString &html)\n", false, &_init_f_insertHtml_2025, &_call_f_insertHtml_2025);
  methods += new qt_gsi::GenericMethod ("insertImage", "@brief Method void QTextCursor::insertImage(const QTextImageFormat &format, QTextFrameFormat::Position alignment)\n", false, &_init_f_insertImage_5822, &_call_f_insertImage_5822);
  methods += new qt_gsi::GenericMethod ("insertImage", "@brief Method void QTextCursor::insertImage(const QTextImageFormat &format)\n", false, &_init_f_insertImage_2915, &_call_f_insertImage_2915);
  methods += new qt_gsi::GenericMethod ("insertImage", "@brief Method void QTextCursor::insertImage(const QString &name)\n", false, &_init_f_insertImage_2025, &_call_f_insertImage_2025);
  methods += new qt_gsi::GenericMethod ("insertImage", "@brief Method void QTextCursor::insertImage(const QImage &image, const QString &name)\n", false, &_init_f_insertImage_3794, &_call_f_insertImage_3794);
  methods += new qt_gsi::GenericMethod ("insertList", "@brief Method QTextList *QTextCursor::insertList(const QTextListFormat &format)\n", false, &_init_f_insertList_2844, &_call_f_insertList_2844);
  methods += new qt_gsi::GenericMethod ("insertList", "@brief Method QTextList *QTextCursor::insertList(QTextListFormat::Style style)\n", false, &_init_f_insertList_2612, &_call_f_insertList_2612);
  methods += new qt_gsi::GenericMethod ("insertTable", "@brief Method QTextTable *QTextCursor::insertTable(int rows, int cols, const QTextTableFormat &format)\n", false, &_init_f_insertTable_4238, &_call_f_insertTable_4238);
  methods += new qt_gsi::GenericMethod ("insertTable", "@brief Method QTextTable *QTextCursor::insertTable(int rows, int cols)\n", false, &_init_f_insertTable_1426, &_call_f_insertTable_1426);
  methods += new qt_gsi::GenericMethod ("insertText", "@brief Method void QTextCursor::insertText(const QString &text)\n", false, &_init_f_insertText_2025, &_call_f_insertText_2025);
  methods += new qt_gsi::GenericMethod ("insertText", "@brief Method void QTextCursor::insertText(const QString &text, const QTextCharFormat &format)\n", false, &_init_f_insertText_4731, &_call_f_insertText_4731);
  methods += new qt_gsi::GenericMethod ("isCopyOf?", "@brief Method bool QTextCursor::isCopyOf(const QTextCursor &other)\n", true, &_init_f_isCopyOf_c2453, &_call_f_isCopyOf_c2453);
  methods += new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QTextCursor::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
  methods += new qt_gsi::GenericMethod ("joinPreviousEditBlock", "@brief Method void QTextCursor::joinPreviousEditBlock()\n", false, &_init_f_joinPreviousEditBlock_0, &_call_f_joinPreviousEditBlock_0);
  methods += new qt_gsi::GenericMethod ("mergeBlockCharFormat", "@brief Method void QTextCursor::mergeBlockCharFormat(const QTextCharFormat &modifier)\n", false, &_init_f_mergeBlockCharFormat_2814, &_call_f_mergeBlockCharFormat_2814);
  methods += new qt_gsi::GenericMethod ("mergeBlockFormat", "@brief Method void QTextCursor::mergeBlockFormat(const QTextBlockFormat &modifier)\n", false, &_init_f_mergeBlockFormat_2923, &_call_f_mergeBlockFormat_2923);
  methods += new qt_gsi::GenericMethod ("mergeCharFormat", "@brief Method void QTextCursor::mergeCharFormat(const QTextCharFormat &modifier)\n", false, &_init_f_mergeCharFormat_2814, &_call_f_mergeCharFormat_2814);
  methods += new qt_gsi::GenericMethod ("movePosition", "@brief Method bool QTextCursor::movePosition(QTextCursor::MoveOperation op, QTextCursor::MoveMode, int n)\n", false, &_init_f_movePosition_6083, &_call_f_movePosition_6083);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QTextCursor::operator!=(const QTextCursor &rhs)\n", true, &_init_f_operator_excl__eq__c2453, &_call_f_operator_excl__eq__c2453);
  methods += new qt_gsi::GenericMethod ("<", "@brief Method bool QTextCursor::operator<(const QTextCursor &rhs)\n", true, &_init_f_operator_lt__c2453, &_call_f_operator_lt__c2453);
  methods += new qt_gsi::GenericMethod ("<=", "@brief Method bool QTextCursor::operator<=(const QTextCursor &rhs)\n", true, &_init_f_operator_lt__eq__c2453, &_call_f_operator_lt__eq__c2453);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QTextCursor &QTextCursor::operator=(const QTextCursor &other)\n", false, &_init_f_operator_eq__2453, &_call_f_operator_eq__2453);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QTextCursor::operator==(const QTextCursor &rhs)\n", true, &_init_f_operator_eq__eq__c2453, &_call_f_operator_eq__eq__c2453);
  methods += new qt_gsi::GenericMethod (">", "@brief Method bool QTextCursor::operator>(const QTextCursor &rhs)\n", true, &_init_f_operator_gt__c2453, &_call_f_operator_gt__c2453);
  methods += new qt_gsi::GenericMethod (">=", "@brief Method bool QTextCursor::operator>=(const QTextCursor &rhs)\n", true, &_init_f_operator_gt__eq__c2453, &_call_f_operator_gt__eq__c2453);
  methods += new qt_gsi::GenericMethod (":position", "@brief Method int QTextCursor::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
  methods += new qt_gsi::GenericMethod ("removeSelectedText", "@brief Method void QTextCursor::removeSelectedText()\n", false, &_init_f_removeSelectedText_0, &_call_f_removeSelectedText_0);
  methods += new qt_gsi::GenericMethod ("select", "@brief Method void QTextCursor::select(QTextCursor::SelectionType selection)\n", false, &_init_f_select_3044, &_call_f_select_3044);
  methods += new qt_gsi::GenericMethod ("selectedTableCells", "@brief Method void QTextCursor::selectedTableCells(int *firstRow, int *numRows, int *firstColumn, int *numColumns)\n", true, &_init_f_selectedTableCells_c3488, &_call_f_selectedTableCells_c3488);
  methods += new qt_gsi::GenericMethod ("selectedText", "@brief Method QString QTextCursor::selectedText()\n", true, &_init_f_selectedText_c0, &_call_f_selectedText_c0);
  methods += new qt_gsi::GenericMethod ("selection", "@brief Method QTextDocumentFragment QTextCursor::selection()\n", true, &_init_f_selection_c0, &_call_f_selection_c0);
  methods += new qt_gsi::GenericMethod ("selectionEnd", "@brief Method int QTextCursor::selectionEnd()\n", true, &_init_f_selectionEnd_c0, &_call_f_selectionEnd_c0);
  methods += new qt_gsi::GenericMethod ("selectionStart", "@brief Method int QTextCursor::selectionStart()\n", true, &_init_f_selectionStart_c0, &_call_f_selectionStart_c0);
  methods += new qt_gsi::GenericMethod ("setBlockCharFormat|blockCharFormat=", "@brief Method void QTextCursor::setBlockCharFormat(const QTextCharFormat &format)\n", false, &_init_f_setBlockCharFormat_2814, &_call_f_setBlockCharFormat_2814);
  methods += new qt_gsi::GenericMethod ("setBlockFormat|blockFormat=", "@brief Method void QTextCursor::setBlockFormat(const QTextBlockFormat &format)\n", false, &_init_f_setBlockFormat_2923, &_call_f_setBlockFormat_2923);
  methods += new qt_gsi::GenericMethod ("setCharFormat|charFormat=", "@brief Method void QTextCursor::setCharFormat(const QTextCharFormat &format)\n", false, &_init_f_setCharFormat_2814, &_call_f_setCharFormat_2814);
  methods += new qt_gsi::GenericMethod ("setPosition", "@brief Method void QTextCursor::setPosition(int pos, QTextCursor::MoveMode mode)\n", false, &_init_f_setPosition_3147, &_call_f_setPosition_3147);
  methods += new qt_gsi::GenericMethod ("setVisualNavigation|visualNavigation=", "@brief Method void QTextCursor::setVisualNavigation(bool b)\n", false, &_init_f_setVisualNavigation_864, &_call_f_setVisualNavigation_864);
  methods += new qt_gsi::GenericMethod (":visualNavigation", "@brief Method bool QTextCursor::visualNavigation()\n", true, &_init_f_visualNavigation_c0, &_call_f_visualNavigation_c0);
  return methods;
}

gsi::Class<QTextCursor> decl_QTextCursor ("QtGui", "QTextCursor",
  methods_QTextCursor (),
  "@qt\n@brief Binding of QTextCursor");


GSI_QTGUI_PUBLIC gsi::Class<QTextCursor> &qtdecl_QTextCursor () { return decl_QTextCursor; }

}


//  Implementation of the enum wrapper class for QTextCursor::MoveMode
namespace qt_gsi
{

static gsi::Enum<QTextCursor::MoveMode> decl_QTextCursor_MoveMode_Enum ("QtGui", "QTextCursor_MoveMode",
    gsi::enum_const ("MoveAnchor", QTextCursor::MoveAnchor, "@brief Enum constant QTextCursor::MoveAnchor") +
    gsi::enum_const ("KeepAnchor", QTextCursor::KeepAnchor, "@brief Enum constant QTextCursor::KeepAnchor"),
  "@qt\n@brief This class represents the QTextCursor::MoveMode enum");

static gsi::QFlagsClass<QTextCursor::MoveMode > decl_QTextCursor_MoveMode_Enums ("QtGui", "QTextCursor_QFlags_MoveMode",
  "@qt\n@brief This class represents the QFlags<QTextCursor::MoveMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextCursor> inject_QTextCursor_MoveMode_Enum_in_parent (decl_QTextCursor_MoveMode_Enum.defs ());
static gsi::ClassExt<QTextCursor> decl_QTextCursor_MoveMode_Enum_as_child (decl_QTextCursor_MoveMode_Enum, "MoveMode");
static gsi::ClassExt<QTextCursor> decl_QTextCursor_MoveMode_Enums_as_child (decl_QTextCursor_MoveMode_Enums, "QFlags_MoveMode");

}


//  Implementation of the enum wrapper class for QTextCursor::MoveOperation
namespace qt_gsi
{

static gsi::Enum<QTextCursor::MoveOperation> decl_QTextCursor_MoveOperation_Enum ("QtGui", "QTextCursor_MoveOperation",
    gsi::enum_const ("NoMove", QTextCursor::NoMove, "@brief Enum constant QTextCursor::NoMove") +
    gsi::enum_const ("Start", QTextCursor::Start, "@brief Enum constant QTextCursor::Start") +
    gsi::enum_const ("Up", QTextCursor::Up, "@brief Enum constant QTextCursor::Up") +
    gsi::enum_const ("StartOfLine", QTextCursor::StartOfLine, "@brief Enum constant QTextCursor::StartOfLine") +
    gsi::enum_const ("StartOfBlock", QTextCursor::StartOfBlock, "@brief Enum constant QTextCursor::StartOfBlock") +
    gsi::enum_const ("StartOfWord", QTextCursor::StartOfWord, "@brief Enum constant QTextCursor::StartOfWord") +
    gsi::enum_const ("PreviousBlock", QTextCursor::PreviousBlock, "@brief Enum constant QTextCursor::PreviousBlock") +
    gsi::enum_const ("PreviousCharacter", QTextCursor::PreviousCharacter, "@brief Enum constant QTextCursor::PreviousCharacter") +
    gsi::enum_const ("PreviousWord", QTextCursor::PreviousWord, "@brief Enum constant QTextCursor::PreviousWord") +
    gsi::enum_const ("Left", QTextCursor::Left, "@brief Enum constant QTextCursor::Left") +
    gsi::enum_const ("WordLeft", QTextCursor::WordLeft, "@brief Enum constant QTextCursor::WordLeft") +
    gsi::enum_const ("End", QTextCursor::End, "@brief Enum constant QTextCursor::End") +
    gsi::enum_const ("Down", QTextCursor::Down, "@brief Enum constant QTextCursor::Down") +
    gsi::enum_const ("EndOfLine", QTextCursor::EndOfLine, "@brief Enum constant QTextCursor::EndOfLine") +
    gsi::enum_const ("EndOfWord", QTextCursor::EndOfWord, "@brief Enum constant QTextCursor::EndOfWord") +
    gsi::enum_const ("EndOfBlock", QTextCursor::EndOfBlock, "@brief Enum constant QTextCursor::EndOfBlock") +
    gsi::enum_const ("NextBlock", QTextCursor::NextBlock, "@brief Enum constant QTextCursor::NextBlock") +
    gsi::enum_const ("NextCharacter", QTextCursor::NextCharacter, "@brief Enum constant QTextCursor::NextCharacter") +
    gsi::enum_const ("NextWord", QTextCursor::NextWord, "@brief Enum constant QTextCursor::NextWord") +
    gsi::enum_const ("Right", QTextCursor::Right, "@brief Enum constant QTextCursor::Right") +
    gsi::enum_const ("WordRight", QTextCursor::WordRight, "@brief Enum constant QTextCursor::WordRight") +
    gsi::enum_const ("NextCell", QTextCursor::NextCell, "@brief Enum constant QTextCursor::NextCell") +
    gsi::enum_const ("PreviousCell", QTextCursor::PreviousCell, "@brief Enum constant QTextCursor::PreviousCell") +
    gsi::enum_const ("NextRow", QTextCursor::NextRow, "@brief Enum constant QTextCursor::NextRow") +
    gsi::enum_const ("PreviousRow", QTextCursor::PreviousRow, "@brief Enum constant QTextCursor::PreviousRow"),
  "@qt\n@brief This class represents the QTextCursor::MoveOperation enum");

static gsi::QFlagsClass<QTextCursor::MoveOperation > decl_QTextCursor_MoveOperation_Enums ("QtGui", "QTextCursor_QFlags_MoveOperation",
  "@qt\n@brief This class represents the QFlags<QTextCursor::MoveOperation> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextCursor> inject_QTextCursor_MoveOperation_Enum_in_parent (decl_QTextCursor_MoveOperation_Enum.defs ());
static gsi::ClassExt<QTextCursor> decl_QTextCursor_MoveOperation_Enum_as_child (decl_QTextCursor_MoveOperation_Enum, "MoveOperation");
static gsi::ClassExt<QTextCursor> decl_QTextCursor_MoveOperation_Enums_as_child (decl_QTextCursor_MoveOperation_Enums, "QFlags_MoveOperation");

}


//  Implementation of the enum wrapper class for QTextCursor::SelectionType
namespace qt_gsi
{

static gsi::Enum<QTextCursor::SelectionType> decl_QTextCursor_SelectionType_Enum ("QtGui", "QTextCursor_SelectionType",
    gsi::enum_const ("WordUnderCursor", QTextCursor::WordUnderCursor, "@brief Enum constant QTextCursor::WordUnderCursor") +
    gsi::enum_const ("LineUnderCursor", QTextCursor::LineUnderCursor, "@brief Enum constant QTextCursor::LineUnderCursor") +
    gsi::enum_const ("BlockUnderCursor", QTextCursor::BlockUnderCursor, "@brief Enum constant QTextCursor::BlockUnderCursor") +
    gsi::enum_const ("Document", QTextCursor::Document, "@brief Enum constant QTextCursor::Document"),
  "@qt\n@brief This class represents the QTextCursor::SelectionType enum");

static gsi::QFlagsClass<QTextCursor::SelectionType > decl_QTextCursor_SelectionType_Enums ("QtGui", "QTextCursor_QFlags_SelectionType",
  "@qt\n@brief This class represents the QFlags<QTextCursor::SelectionType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextCursor> inject_QTextCursor_SelectionType_Enum_in_parent (decl_QTextCursor_SelectionType_Enum.defs ());
static gsi::ClassExt<QTextCursor> decl_QTextCursor_SelectionType_Enum_as_child (decl_QTextCursor_SelectionType_Enum, "SelectionType");
static gsi::ClassExt<QTextCursor> decl_QTextCursor_SelectionType_Enums_as_child (decl_QTextCursor_SelectionType_Enums, "QFlags_SelectionType");

}

