/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc.pict;

import com.kreative.rsrc.pict.ColorSpec;
import com.kreative.rsrc.pict.ColorTable;
import com.kreative.rsrc.pict.PICTInstruction;
import com.kreative.rsrc.pict.PixMap;
import com.kreative.rsrc.pict.Point;
import com.kreative.rsrc.pict.Polygon;
import com.kreative.rsrc.pict.RGBColor;
import com.kreative.rsrc.pict.Rect;
import com.kreative.rsrc.pict.Region;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;

public class PICTUtilities {
    public static final int[] COLORS_8BIT = new int[]{-1, -52, -103, -154, -205, -256, -13057, -13108, -13159, -13210, -13261, -13312, -26113, -26164, -26215, -26266, -26317, -26368, -39169, -39220, -39271, -39322, -39373, -39424, -52225, -52276, -52327, -52378, -52429, -52480, -65281, -65332, -65383, -65434, -65485, -65536, -3342337, -3342388, -3342439, -3342490, -3342541, -3342592, -3355393, -3355444, -3355495, -3355546, -3355597, -3355648, -3368449, -3368500, -3368551, -3368602, -3368653, -3368704, -3381505, -3381556, -3381607, -3381658, -3381709, -3381760, -3394561, -3394612, -3394663, -3394714, -3394765, -3394816, -3407617, -3407668, -3407719, -3407770, -3407821, -3407872, -6684673, -6684724, -6684775, -6684826, -6684877, -6684928, -6697729, -6697780, -6697831, -6697882, -6697933, -6697984, -6710785, -6710836, -6710887, -6710938, -6710989, -6711040, -6723841, -6723892, -6723943, -6723994, -6724045, -6724096, -6736897, -6736948, -6736999, -6737050, -6737101, -6737152, -6749953, -6750004, -6750055, -6750106, -6750157, -6750208, -10027009, -10027060, -10027111, -10027162, -10027213, -10027264, -10040065, -10040116, -10040167, -10040218, -10040269, -10040320, -10053121, -10053172, -10053223, -10053274, -10053325, -10053376, -10066177, -10066228, -10066279, -10066330, -10066381, -10066432, -10079233, -10079284, -10079335, -10079386, -10079437, -10079488, -10092289, -10092340, -10092391, -10092442, -10092493, -10092544, -13369345, -13369396, -13369447, -13369498, -13369549, -13369600, -13382401, -13382452, -13382503, -13382554, -13382605, -13382656, -13395457, -13395508, -13395559, -13395610, -13395661, -13395712, -13408513, -13408564, -13408615, -13408666, -13408717, -13408768, -13421569, -13421620, -13421671, -13421722, -13421773, -13421824, -13434625, -13434676, -13434727, -13434778, -13434829, -13434880, -16711681, -16711732, -16711783, -16711834, -16711885, -16711936, -16724737, -16724788, -16724839, -16724890, -16724941, -16724992, -16737793, -16737844, -16737895, -16737946, -16737997, -16738048, -16750849, -16750900, -16750951, -16751002, -16751053, -16751104, -16763905, -16763956, -16764007, -16764058, -16764109, -16764160, -16776961, -16777012, -16777063, -16777114, -16777165, -1179648, -2293760, -4521984, -5636096, -7864320, -8978432, -11206656, -12320768, -14548992, -15663104, -16716288, -16720640, -16729344, -16733696, -16742400, -16746752, -16755456, -16759808, -16768512, -16772864, -16776978, -16776995, -16777029, -16777046, -16777080, -16777097, -16777131, -16777148, -16777182, -16777199, -1118482, -2236963, -4473925, -5592406, -7829368, -8947849, -11184811, -12303292, -14540254, -15658735, -16777216};
    public static final int[] COLORS_4BIT = new int[]{-1, -199931, -39677, -2291449, -849787, -12123995, -16777004, -16602133, -14698476, -16751342, -11129595, -7245510, -4144960, -8355712, -12566464, -16777216};
    public static final int[] COLORS_2BIT = new int[]{-1, -8355712, -3355393, -16777216};
    public static final int[] COLORS_1BIT = new int[]{-1, -16777216};
    private static final char[] MACROMAN;

    static {
        char[] cArray = new char[256];
        cArray[1] = '\u0001';
        cArray[2] = 2;
        cArray[3] = 3;
        cArray[4] = 4;
        cArray[5] = 5;
        cArray[6] = 6;
        cArray[7] = 7;
        cArray[8] = 8;
        cArray[9] = 9;
        cArray[10] = 10;
        cArray[11] = 11;
        cArray[12] = 12;
        cArray[13] = 13;
        cArray[14] = 14;
        cArray[15] = 15;
        cArray[16] = 16;
        cArray[17] = 17;
        cArray[18] = 18;
        cArray[19] = 19;
        cArray[20] = 20;
        cArray[21] = 21;
        cArray[22] = 22;
        cArray[23] = 23;
        cArray[24] = 24;
        cArray[25] = 25;
        cArray[26] = 26;
        cArray[27] = 27;
        cArray[28] = 28;
        cArray[29] = 29;
        cArray[30] = 30;
        cArray[31] = 31;
        cArray[32] = 32;
        cArray[33] = 33;
        cArray[34] = 34;
        cArray[35] = 35;
        cArray[36] = 36;
        cArray[37] = 37;
        cArray[38] = 38;
        cArray[39] = 39;
        cArray[40] = 40;
        cArray[41] = 41;
        cArray[42] = 42;
        cArray[43] = 43;
        cArray[44] = 44;
        cArray[45] = 45;
        cArray[46] = 46;
        cArray[47] = 47;
        cArray[48] = 48;
        cArray[49] = 49;
        cArray[50] = 50;
        cArray[51] = 51;
        cArray[52] = 52;
        cArray[53] = 53;
        cArray[54] = 54;
        cArray[55] = 55;
        cArray[56] = 56;
        cArray[57] = 57;
        cArray[58] = 58;
        cArray[59] = 59;
        cArray[60] = 60;
        cArray[61] = 61;
        cArray[62] = 62;
        cArray[63] = 63;
        cArray[64] = 64;
        cArray[65] = 65;
        cArray[66] = 66;
        cArray[67] = 67;
        cArray[68] = 68;
        cArray[69] = 69;
        cArray[70] = 70;
        cArray[71] = 71;
        cArray[72] = 72;
        cArray[73] = 73;
        cArray[74] = 74;
        cArray[75] = 75;
        cArray[76] = 76;
        cArray[77] = 77;
        cArray[78] = 78;
        cArray[79] = 79;
        cArray[80] = 80;
        cArray[81] = 81;
        cArray[82] = 82;
        cArray[83] = 83;
        cArray[84] = 84;
        cArray[85] = 85;
        cArray[86] = 86;
        cArray[87] = 87;
        cArray[88] = 88;
        cArray[89] = 89;
        cArray[90] = 90;
        cArray[91] = 91;
        cArray[92] = 92;
        cArray[93] = 93;
        cArray[94] = 94;
        cArray[95] = 95;
        cArray[96] = 96;
        cArray[97] = 97;
        cArray[98] = 98;
        cArray[99] = 99;
        cArray[100] = 100;
        cArray[101] = 101;
        cArray[102] = 102;
        cArray[103] = 103;
        cArray[104] = 104;
        cArray[105] = 105;
        cArray[106] = 106;
        cArray[107] = 107;
        cArray[108] = 108;
        cArray[109] = 109;
        cArray[110] = 110;
        cArray[111] = 111;
        cArray[112] = 112;
        cArray[113] = 113;
        cArray[114] = 114;
        cArray[115] = 115;
        cArray[116] = 116;
        cArray[117] = 117;
        cArray[118] = 118;
        cArray[119] = 119;
        cArray[120] = 120;
        cArray[121] = 121;
        cArray[122] = 122;
        cArray[123] = 123;
        cArray[124] = 124;
        cArray[125] = 125;
        cArray[126] = 126;
        cArray[127] = 127;
        cArray[128] = 196;
        cArray[129] = 197;
        cArray[130] = 199;
        cArray[131] = 201;
        cArray[132] = 209;
        cArray[133] = 214;
        cArray[134] = 220;
        cArray[135] = 225;
        cArray[136] = 224;
        cArray[137] = 226;
        cArray[138] = 228;
        cArray[139] = 227;
        cArray[140] = 229;
        cArray[141] = 231;
        cArray[142] = 233;
        cArray[143] = 232;
        cArray[144] = 234;
        cArray[145] = 235;
        cArray[146] = 237;
        cArray[147] = 236;
        cArray[148] = 238;
        cArray[149] = 239;
        cArray[150] = 241;
        cArray[151] = 243;
        cArray[152] = 242;
        cArray[153] = 244;
        cArray[154] = 246;
        cArray[155] = 245;
        cArray[156] = 250;
        cArray[157] = 249;
        cArray[158] = 251;
        cArray[159] = 252;
        cArray[160] = 8224;
        cArray[161] = 176;
        cArray[162] = 162;
        cArray[163] = 163;
        cArray[164] = 167;
        cArray[165] = 8226;
        cArray[166] = 182;
        cArray[167] = 223;
        cArray[168] = 174;
        cArray[169] = 169;
        cArray[170] = 8482;
        cArray[171] = 180;
        cArray[172] = 168;
        cArray[173] = 8800;
        cArray[174] = 198;
        cArray[175] = 216;
        cArray[176] = 8734;
        cArray[177] = 177;
        cArray[178] = 8804;
        cArray[179] = 8805;
        cArray[180] = 165;
        cArray[181] = 181;
        cArray[182] = 8706;
        cArray[183] = 8721;
        cArray[184] = 8719;
        cArray[185] = 960;
        cArray[186] = 8747;
        cArray[187] = 170;
        cArray[188] = 186;
        cArray[189] = 937;
        cArray[190] = 230;
        cArray[191] = 248;
        cArray[192] = 191;
        cArray[193] = 161;
        cArray[194] = 172;
        cArray[195] = 8730;
        cArray[196] = 402;
        cArray[197] = 8776;
        cArray[198] = 8710;
        cArray[199] = 171;
        cArray[200] = 187;
        cArray[201] = 8230;
        cArray[202] = 160;
        cArray[203] = 192;
        cArray[204] = 195;
        cArray[205] = 213;
        cArray[206] = 338;
        cArray[207] = 339;
        cArray[208] = 8211;
        cArray[209] = 8212;
        cArray[210] = 8220;
        cArray[211] = 8221;
        cArray[212] = 8216;
        cArray[213] = 8217;
        cArray[214] = 247;
        cArray[215] = 9674;
        cArray[216] = 255;
        cArray[217] = 376;
        cArray[218] = 8260;
        cArray[219] = 8364;
        cArray[220] = 8249;
        cArray[221] = 8250;
        cArray[222] = 64257;
        cArray[223] = 64258;
        cArray[224] = 8225;
        cArray[225] = 183;
        cArray[226] = 8218;
        cArray[227] = 8222;
        cArray[228] = 8240;
        cArray[229] = 194;
        cArray[230] = 202;
        cArray[231] = 193;
        cArray[232] = 203;
        cArray[233] = 200;
        cArray[234] = 205;
        cArray[235] = 206;
        cArray[236] = 207;
        cArray[237] = 204;
        cArray[238] = 211;
        cArray[239] = 212;
        cArray[240] = 63743;
        cArray[241] = 210;
        cArray[242] = 218;
        cArray[243] = 219;
        cArray[244] = 217;
        cArray[245] = 305;
        cArray[246] = 710;
        cArray[247] = 732;
        cArray[248] = 175;
        cArray[249] = 728;
        cArray[250] = 729;
        cArray[251] = 730;
        cArray[252] = 184;
        cArray[253] = 733;
        cArray[254] = 731;
        cArray[255] = 711;
        MACROMAN = cArray;
    }

    private PICTUtilities() {
    }

    public static byte[] makeByteArray(Object ... objs) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Byte) {
                dos.writeByte(((Byte)o).byteValue());
            } else if (o instanceof Short) {
                dos.writeShort(((Short)o).shortValue());
            } else if (o instanceof Integer) {
                dos.writeInt((Integer)o);
            } else if (o instanceof Long) {
                dos.writeLong((Long)o);
            } else if (o instanceof Float) {
                dos.writeFloat(((Float)o).floatValue());
            } else if (o instanceof Double) {
                dos.writeDouble((Double)o);
            } else if (o instanceof Boolean) {
                dos.writeBoolean((Boolean)o);
            } else if (o instanceof Character) {
                dos.writeChar(((Character)o).charValue());
            } else if (o instanceof String) {
                dos.writeInt(((String)o).length());
                dos.writeChars((String)o);
            } else if (o instanceof StringBuffer) {
                dos.writeInt(o.toString().length());
                dos.writeChars(o.toString());
            } else if (o instanceof byte[]) {
                dos.writeInt(((byte[])o).length);
                dos.write((byte[])o);
            } else if (o instanceof ColorSpec) {
                ((ColorSpec)o).write(dos);
            } else if (o instanceof ColorTable) {
                ((ColorTable)o).write(dos);
            } else if (o instanceof PixMap) {
                ((PixMap)o).write(dos, true);
            } else if (o instanceof Point) {
                ((Point)o).write(dos);
            } else if (o instanceof Polygon) {
                ((Polygon)o).write(dos);
            } else if (o instanceof Rect) {
                ((Rect)o).write(dos);
            } else if (o instanceof Region) {
                ((Region)o).write(dos);
            } else if (o instanceof RGBColor) {
                ((RGBColor)o).write(dos);
            }
            ++n2;
        }
        dos.close();
        bos.close();
        return bos.toByteArray();
    }

    public static Object[] unmakeByteArray(byte[] data, Class<?> ... classes) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bis);
        Vector<Object> objs = new Vector<Object>();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            StringBuffer sb;
            Class<?> c = classArray[n2];
            if (c == Byte.TYPE || c == Byte.class) {
                objs.add(dis.readByte());
            } else if (c == Short.TYPE || c == Short.class) {
                objs.add(dis.readShort());
            } else if (c == Integer.TYPE || c == Integer.class) {
                objs.add(dis.readInt());
            } else if (c == Long.TYPE || c == Long.class) {
                objs.add(dis.readLong());
            } else if (c == Float.TYPE || c == Float.class) {
                objs.add(Float.valueOf(dis.readFloat()));
            } else if (c == Double.TYPE || c == Double.class) {
                objs.add(dis.readDouble());
            } else if (c == Boolean.TYPE || c == Boolean.class) {
                objs.add(dis.readBoolean());
            } else if (c == Character.TYPE || c == Character.class) {
                objs.add(Character.valueOf(dis.readChar()));
            } else if (c == String.class) {
                int len = dis.readInt();
                sb = new StringBuffer(len);
                while (len-- > 0) {
                    sb.append(dis.readChar());
                }
                objs.add(sb.toString());
            } else if (c == StringBuffer.class) {
                int len = dis.readInt();
                sb = new StringBuffer(len);
                while (len-- > 0) {
                    sb.append(dis.readChar());
                }
                objs.add(sb);
            } else if (c == byte[].class) {
                byte[] d = new byte[dis.readInt()];
                dis.readFully(d);
                objs.add(d);
            } else if (c == ColorSpec.class) {
                objs.add(ColorSpec.read(dis));
            } else if (c == ColorTable.class) {
                objs.add(ColorTable.read(dis));
            } else if (c == PixMap.class) {
                objs.add(PixMap.read(dis, true));
            } else if (c == Point.class) {
                objs.add(Point.read(dis));
            } else if (c == Polygon.class) {
                objs.add(Polygon.read(dis));
            } else if (c == Rect.class) {
                objs.add(Rect.read(dis));
            } else if (c == Region.class) {
                objs.add(Region.read(dis));
            } else if (c == RGBColor.class) {
                objs.add(RGBColor.read(dis));
            }
            ++n2;
        }
        dis.close();
        bis.close();
        return objs.toArray(new Object[0]);
    }

    public static byte[] packBits(byte[] data) {
        byte[] runs = new byte[data.length * 2];
        int runsPtr = 0;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (runsPtr >= 2 && runs[runsPtr - 1] == b && runs[runsPtr - 2] < 127) {
                int n3 = runsPtr - 2;
                runs[n3] = (byte)(runs[n3] + 1);
            } else {
                runs[runsPtr++] = 1;
                runs[runsPtr++] = b;
            }
            ++n2;
        }
        byte[] comp = new byte[data.length * 2];
        int compPtr = 0;
        int compCntPtr = 0;
        int i = 0;
        while (i < runsPtr) {
            byte cnt = runs[i];
            byte b = runs[i + 1];
            if (cnt > 1) {
                comp[compPtr++] = (byte)(-cnt + 1);
                comp[compPtr++] = b;
                compCntPtr = compPtr;
            } else if (compCntPtr == compPtr || comp[compCntPtr] >= 127) {
                comp[compPtr++] = 0;
                comp[compPtr++] = b;
            } else {
                int n4 = compCntPtr;
                comp[n4] = (byte)(comp[n4] + 1);
                comp[compPtr++] = b;
            }
            i += 2;
        }
        byte[] fin = new byte[compPtr];
        int i2 = 0;
        while (i2 < compPtr) {
            fin[i2] = comp[i2];
            ++i2;
        }
        return fin;
    }

    public static byte[] unpackBits(byte[] data) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int dataPtr = 0;
        while (dataPtr < data.length) {
            int count;
            byte v;
            if ((v = data[dataPtr++]) < 0) {
                count = -v + 1;
                byte d = data[dataPtr++];
                while (count-- > 0) {
                    bos.write(d);
                }
                continue;
            }
            count = v + 1;
            while (count-- > 0) {
                bos.write(data[dataPtr++]);
            }
        }
        return bos.toByteArray();
    }

    public static PICTInstruction makeBitsRect(int x, int y, BufferedImage img, int matte, float hRes, float vRes) {
        int w = img.getWidth();
        int h = img.getHeight();
        int[] pixels = new int[w * h];
        img.getRGB(0, 0, w, h, pixels, 0, w);
        HashSet<Integer> colors = new HashSet<Integer>();
        int i = 0;
        while (i < pixels.length) {
            if (pixels[i] >= 0) {
                pixels[i] = matte | 0xFF000000;
            } else {
                int n = i;
                pixels[n] = pixels[n] | 0xFF000000;
            }
            colors.add(pixels[i] | 0xFF000000);
            ++i;
        }
        if (colors.size() <= 256) {
            PixMap pm = new PixMap();
            pm.baseAddr = 0;
            pm.rowBytes = w | 0x8000;
            while ((pm.rowBytes & 3) != 0) {
                ++pm.rowBytes;
            }
            pm.bounds = new Rect(x, y, w, h);
            pm.pmVersion = 0;
            pm.packType = 0;
            pm.packSize = 0;
            pm.hRes = hRes;
            pm.vRes = vRes;
            pm.pixelType = 0;
            pm.pixelSize = 8;
            pm.cmpCount = 1;
            pm.cmpSize = 8;
            pm.planeBytes = 0;
            pm.pmTable = 0;
            pm.pmReserved = 0;
            ColorTable ct = new ColorTable();
            ct.ctSeed = 0;
            ct.ctFlags = 0;
            ct.ctSize = colors.size() - 1;
            Integer[] ca = colors.toArray(new Integer[0]);
            Arrays.sort(ca, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o2.compareTo(o1);
                }
            });
            Integer[] integerArray = ca;
            int n = ca.length;
            int n2 = 0;
            while (n2 < n) {
                int c = integerArray[n2];
                ct.ctTable.add(new ColorSpec(c));
                ++n2;
            }
            BufferedImage pdi = new BufferedImage(w, h, 13, ct.toIndexColorModel(8));
            pdi.setRGB(0, 0, w, h, pixels, 0, w);
            byte[] pddata = ((DataBufferByte)pdi.getData().getDataBuffer()).getData();
            ByteArrayOutputStream pdb = new ByteArrayOutputStream();
            DataOutputStream pdd = new DataOutputStream(pdb);
            try {
                byte[] pdscanline = new byte[pm.rowBytes & Short.MAX_VALUE];
                if ((pm.rowBytes & Short.MAX_VALUE) < 8) {
                    int ly = 0;
                    int pddy = 0;
                    while (ly < h) {
                        int lx = 0;
                        int pddx = pddy;
                        while (lx < w) {
                            pdscanline[lx] = pddata[pddx];
                            ++lx;
                            ++pddx;
                        }
                        pdd.write(pdscanline);
                        ++ly;
                        pddy += w;
                    }
                } else if ((pm.rowBytes & Short.MAX_VALUE) > 250) {
                    int ly = 0;
                    int pddy = 0;
                    while (ly < h) {
                        int lx = 0;
                        int pddx = pddy;
                        while (lx < w) {
                            pdscanline[lx] = pddata[pddx];
                            ++lx;
                            ++pddx;
                        }
                        byte[] csl = PICTUtilities.packBits(pdscanline);
                        pdd.writeShort(csl.length);
                        pdd.write(csl);
                        ++ly;
                        pddy += w;
                    }
                } else {
                    int ly = 0;
                    int pddy = 0;
                    while (ly < h) {
                        int lx = 0;
                        int pddx = pddy;
                        while (lx < w) {
                            pdscanline[lx] = pddata[pddx];
                            ++lx;
                            ++pddx;
                        }
                        byte[] csl = PICTUtilities.packBits(pdscanline);
                        pdd.writeByte(csl.length);
                        pdd.write(csl);
                        ++ly;
                        pddy += w;
                    }
                }
                pdd.close();
                pdb.close();
            }
            catch (IOException pdscanline) {
                // empty catch block
            }
            byte[] pd = pdb.toByteArray();
            return new PICTInstruction.PackBitsRect(pm, ct, pm.bounds, pm.bounds, 0, pd);
        }
        PixMap pm = new PixMap();
        pm.baseAddr = 0;
        pm.rowBytes = w * 4 | 0x8000;
        pm.bounds = new Rect(x, y, w, h);
        pm.pmVersion = 0;
        pm.packType = 4;
        pm.packSize = 0;
        pm.hRes = hRes;
        pm.vRes = vRes;
        pm.pixelType = 16;
        pm.pixelSize = 32;
        pm.cmpCount = 3;
        pm.cmpSize = 8;
        pm.planeBytes = 0;
        pm.pmTable = 0;
        pm.pmReserved = 0;
        ByteArrayOutputStream pdb = new ByteArrayOutputStream();
        DataOutputStream pdd = new DataOutputStream(pdb);
        try {
            byte[] pdscanline = new byte[w * 3];
            if ((pm.rowBytes & Short.MAX_VALUE) < 8) {
                int ly = 0;
                int pddy = 0;
                while (ly < h) {
                    int lx = 0;
                    int pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx] = (byte)(pixels[pddx] >>> 16 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    lx = 0;
                    pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx + w] = (byte)(pixels[pddx] >>> 8 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    lx = 0;
                    pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx + w + w] = (byte)(pixels[pddx] >>> 0 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    pdd.write(pdscanline);
                    ++ly;
                    pddy += w;
                }
            } else if ((pm.rowBytes & Short.MAX_VALUE) > 250) {
                int ly = 0;
                int pddy = 0;
                while (ly < h) {
                    int lx = 0;
                    int pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx] = (byte)(pixels[pddx] >>> 16 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    lx = 0;
                    pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx + w] = (byte)(pixels[pddx] >>> 8 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    lx = 0;
                    pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx + w + w] = (byte)(pixels[pddx] >>> 0 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    byte[] csl = PICTUtilities.packBits(pdscanline);
                    pdd.writeShort(csl.length);
                    pdd.write(csl);
                    ++ly;
                    pddy += w;
                }
            } else {
                int ly = 0;
                int pddy = 0;
                while (ly < h) {
                    int lx = 0;
                    int pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx] = (byte)(pixels[pddx] >>> 16 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    lx = 0;
                    pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx + w] = (byte)(pixels[pddx] >>> 8 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    lx = 0;
                    pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx + w + w] = (byte)(pixels[pddx] >>> 0 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    byte[] csl = PICTUtilities.packBits(pdscanline);
                    pdd.writeByte(csl.length);
                    pdd.write(csl);
                    ++ly;
                    pddy += w;
                }
            }
            pdd.close();
            pdb.close();
        }
        catch (IOException pdscanline) {
            // empty catch block
        }
        byte[] pd = pdb.toByteArray();
        pm.packSize = pd.length;
        return new PICTInstruction.DirectBitsRect(pm, pm.bounds, pm.bounds, 0, pd);
    }

    public static PICTInstruction makeBitsRgn(int x, int y, BufferedImage img, int matte, float hRes, float vRes) {
        int w = img.getWidth();
        int h = img.getHeight();
        int[] pixels = new int[w * h];
        img.getRGB(0, 0, w, h, pixels, 0, w);
        Region rgn = Region.fromAlpha(x, y, w, h, pixels, 0, w);
        int i = 0;
        while (i < pixels.length) {
            if (pixels[i] >= 0) {
                pixels[i] = matte | 0xFF000000;
            } else {
                int n = i;
                pixels[n] = pixels[n] | 0xFF000000;
            }
            ++i;
        }
        PixMap pm = new PixMap();
        pm.baseAddr = 0;
        pm.rowBytes = w * 4 | 0x8000;
        pm.bounds = new Rect(x, y, w, h);
        pm.pmVersion = 0;
        pm.packType = 4;
        pm.packSize = 0;
        pm.hRes = hRes;
        pm.vRes = vRes;
        pm.pixelType = 16;
        pm.pixelSize = 32;
        pm.cmpCount = 3;
        pm.cmpSize = 8;
        pm.planeBytes = 0;
        pm.pmTable = 0;
        pm.pmReserved = 0;
        ByteArrayOutputStream pdb = new ByteArrayOutputStream();
        DataOutputStream pdd = new DataOutputStream(pdb);
        try {
            byte[] pdscanline = new byte[w * 3];
            if ((pm.rowBytes & Short.MAX_VALUE) < 8) {
                int ly = 0;
                int pddy = 0;
                while (ly < h) {
                    int lx = 0;
                    int pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx] = (byte)(pixels[pddx] >>> 16 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    lx = 0;
                    pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx + w] = (byte)(pixels[pddx] >>> 8 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    lx = 0;
                    pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx + w + w] = (byte)(pixels[pddx] >>> 0 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    pdd.write(pdscanline);
                    ++ly;
                    pddy += w;
                }
            } else if ((pm.rowBytes & Short.MAX_VALUE) > 250) {
                int ly = 0;
                int pddy = 0;
                while (ly < h) {
                    int lx = 0;
                    int pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx] = (byte)(pixels[pddx] >>> 16 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    lx = 0;
                    pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx + w] = (byte)(pixels[pddx] >>> 8 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    lx = 0;
                    pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx + w + w] = (byte)(pixels[pddx] >>> 0 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    byte[] csl = PICTUtilities.packBits(pdscanline);
                    pdd.writeShort(csl.length);
                    pdd.write(csl);
                    ++ly;
                    pddy += w;
                }
            } else {
                int ly = 0;
                int pddy = 0;
                while (ly < h) {
                    int lx = 0;
                    int pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx] = (byte)(pixels[pddx] >>> 16 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    lx = 0;
                    pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx + w] = (byte)(pixels[pddx] >>> 8 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    lx = 0;
                    pddx = pddy;
                    while (lx < w) {
                        pdscanline[lx + w + w] = (byte)(pixels[pddx] >>> 0 & 0xFF);
                        ++lx;
                        ++pddx;
                    }
                    byte[] csl = PICTUtilities.packBits(pdscanline);
                    pdd.writeByte(csl.length);
                    pdd.write(csl);
                    ++ly;
                    pddy += w;
                }
            }
            pdd.close();
            pdb.close();
        }
        catch (IOException pdscanline) {
            // empty catch block
        }
        byte[] pd = pdb.toByteArray();
        pm.packSize = pd.length;
        return new PICTInstruction.DirectBitsRgn(pm, pm.bounds, pm.bounds, 0, rgn, pd);
    }

    public static BufferedImage pixmapToImage(PixMap pm, ColorTable ct, byte[] data, int bg, int fg, boolean pixpat, boolean packed) {
        int b;
        int g;
        int r;
        int[] colors;
        if ((pm.packType != 0 || packed) && pm.packType != 1 && (pm.rowBytes & Short.MAX_VALUE) >= 8) {
            if (pm.packType == 2) {
                byte[] ndata = new byte[data.length * 4 / 3];
                int di = 0;
                int ndi = 0;
                while (di < data.length && ndi < ndata.length) {
                    ndata[ndi + 0] = 0;
                    ndata[ndi + 1] = data[di + 0];
                    ndata[ndi + 2] = data[di + 1];
                    ndata[ndi + 3] = data[di + 2];
                    di += 3;
                    ndi += 4;
                }
                data = ndata;
            } else {
                int nsli;
                int sli;
                byte[] nscanline;
                byte[] scanline;
                int y;
                DataOutputStream dout;
                ByteArrayInputStream bin;
                if ((pm.rowBytes & Short.MAX_VALUE) > 250) {
                    try {
                        bin = new ByteArrayInputStream(data);
                        DataInputStream din = new DataInputStream(bin);
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        dout = new DataOutputStream(bout);
                        y = pm.bounds.top;
                        while (y < pm.bounds.bottom) {
                            scanline = new byte[din.readUnsignedShort()];
                            din.readFully(scanline);
                            scanline = PICTUtilities.unpackBits(scanline);
                            if (pm.packType == 4) {
                                if (pm.cmpCount == 4) {
                                    nscanline = new byte[scanline.length];
                                    sli = 0;
                                    nsli = 0;
                                    while (nsli < nscanline.length) {
                                        nscanline[nsli] = scanline[sli];
                                        nsli += 4;
                                        ++sli;
                                    }
                                    nsli = 1;
                                    while (nsli < nscanline.length) {
                                        nscanline[nsli] = scanline[sli];
                                        nsli += 4;
                                        ++sli;
                                    }
                                    nsli = 2;
                                    while (nsli < nscanline.length) {
                                        nscanline[nsli] = scanline[sli];
                                        nsli += 4;
                                        ++sli;
                                    }
                                    nsli = 3;
                                    while (nsli < nscanline.length) {
                                        nscanline[nsli] = scanline[sli];
                                        nsli += 4;
                                        ++sli;
                                    }
                                    scanline = nscanline;
                                } else if (pm.cmpCount == 3) {
                                    nscanline = new byte[scanline.length * 4 / 3];
                                    sli = 0;
                                    nsli = 0;
                                    while (nsli < nscanline.length) {
                                        nscanline[nsli] = 0;
                                        nsli += 4;
                                    }
                                    nsli = 1;
                                    while (nsli < nscanline.length) {
                                        nscanline[nsli] = scanline[sli];
                                        nsli += 4;
                                        ++sli;
                                    }
                                    nsli = 2;
                                    while (nsli < nscanline.length) {
                                        nscanline[nsli] = scanline[sli];
                                        nsli += 4;
                                        ++sli;
                                    }
                                    nsli = 3;
                                    while (nsli < nscanline.length) {
                                        nscanline[nsli] = scanline[sli];
                                        nsli += 4;
                                        ++sli;
                                    }
                                    scanline = nscanline;
                                }
                            }
                            dout.write(scanline);
                            ++y;
                        }
                        dout.close();
                        bout.close();
                        din.close();
                        bin.close();
                        data = bout.toByteArray();
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                }
                try {
                    bin = new ByteArrayInputStream(data);
                    DataInputStream din = new DataInputStream(bin);
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    dout = new DataOutputStream(bout);
                    y = pm.bounds.top;
                    while (y < pm.bounds.bottom) {
                        scanline = new byte[din.readUnsignedByte()];
                        din.readFully(scanline);
                        scanline = PICTUtilities.unpackBits(scanline);
                        if (pm.packType == 4) {
                            if (pm.cmpCount == 4) {
                                nscanline = new byte[scanline.length];
                                sli = 0;
                                nsli = 0;
                                while (nsli < nscanline.length) {
                                    nscanline[nsli] = scanline[sli];
                                    nsli += 4;
                                    ++sli;
                                }
                                nsli = 1;
                                while (nsli < nscanline.length) {
                                    nscanline[nsli] = scanline[sli];
                                    nsli += 4;
                                    ++sli;
                                }
                                nsli = 2;
                                while (nsli < nscanline.length) {
                                    nscanline[nsli] = scanline[sli];
                                    nsli += 4;
                                    ++sli;
                                }
                                nsli = 3;
                                while (nsli < nscanline.length) {
                                    nscanline[nsli] = scanline[sli];
                                    nsli += 4;
                                    ++sli;
                                }
                                scanline = nscanline;
                            } else if (pm.cmpCount == 3) {
                                nscanline = new byte[scanline.length * 4 / 3];
                                sli = 0;
                                nsli = 0;
                                while (nsli < nscanline.length) {
                                    nscanline[nsli] = 0;
                                    nsli += 4;
                                }
                                nsli = 1;
                                while (nsli < nscanline.length) {
                                    nscanline[nsli] = scanline[sli];
                                    nsli += 4;
                                    ++sli;
                                }
                                nsli = 2;
                                while (nsli < nscanline.length) {
                                    nscanline[nsli] = scanline[sli];
                                    nsli += 4;
                                    ++sli;
                                }
                                nsli = 3;
                                while (nsli < nscanline.length) {
                                    nscanline[nsli] = scanline[sli];
                                    nsli += 4;
                                    ++sli;
                                }
                                scanline = nscanline;
                            }
                        }
                        dout.write(scanline);
                        ++y;
                    }
                    dout.close();
                    bout.close();
                    din.close();
                    bin.close();
                    data = bout.toByteArray();
                }
                catch (IOException ioe) {
                    return null;
                }
            }
        }
        if (ct != null) {
            colors = ct.toIntArray();
            if (colors.length < 1 << pm.pixelSize) {
                int[] newcolors = new int[1 << pm.pixelSize];
                int i = 0;
                while (i < colors.length) {
                    newcolors[i] = colors[i];
                    ++i;
                }
                int k = newcolors.length - colors.length - 1;
                if (k == 0) {
                    int i2 = colors.length;
                    while (i2 < newcolors.length) {
                        newcolors[i2] = fg;
                        ++i2;
                    }
                } else {
                    int bga = bg >>> 24 & 0xFF;
                    int bgr = bg >>> 16 & 0xFF;
                    int bgg = bg >>> 8 & 0xFF;
                    int bgb = bg >>> 0 & 0xFF;
                    int fga = fg >>> 24 & 0xFF;
                    int fgr = fg >>> 16 & 0xFF;
                    int fgg = fg >>> 8 & 0xFF;
                    int fgb = fg >>> 0 & 0xFF;
                    int i3 = colors.length;
                    int j = 0;
                    while (i3 < newcolors.length) {
                        int a = bga + (fga - bga) * j / k;
                        int r2 = bgr + (fgr - bgr) * j / k;
                        int g2 = bgg + (fgg - bgg) * j / k;
                        int b2 = bgb + (fgb - bgb) * j / k;
                        newcolors[i3] = a << 24 | r2 << 16 | g2 << 8 | b2 << 0;
                        ++i3;
                        ++j;
                    }
                }
                colors = newcolors;
            }
        } else if (pixpat) {
            colors = new int[1 << pm.pixelSize];
            int k = colors.length - 1;
            int bga = bg >>> 24 & 0xFF;
            int bgr = bg >>> 16 & 0xFF;
            int bgg = bg >>> 8 & 0xFF;
            int bgb = bg >>> 0 & 0xFF;
            int fga = fg >>> 24 & 0xFF;
            int fgr = fg >>> 16 & 0xFF;
            int fgg = fg >>> 8 & 0xFF;
            int fgb = fg >>> 0 & 0xFF;
            int i = 0;
            while (i < colors.length) {
                int a = bga + (fga - bga) * i / k;
                r = bgr + (fgr - bgr) * i / k;
                g = bgg + (fgg - bgg) * i / k;
                b = bgb + (fgb - bgb) * i / k;
                colors[i] = a << 24 | r << 16 | g << 8 | b << 0;
                ++i;
            }
        } else {
            colors = pm.pixelSize <= 1 ? COLORS_1BIT : (pm.pixelSize <= 2 ? COLORS_2BIT : (pm.pixelSize <= 4 ? COLORS_4BIT : COLORS_8BIT));
        }
        int w = pm.bounds.right - pm.bounds.left;
        int h = pm.bounds.bottom - pm.bounds.top;
        int bw = (pm.rowBytes & Short.MAX_VALUE) * 8 / pm.pixelSize;
        int[] pixels = new int[bw * h];
        switch (pm.pixelSize) {
            case 32: {
                int dx;
                int px;
                int lx;
                int ly = 0;
                int py = 0;
                int dy = 0;
                while (ly < h && py < pixels.length && dy < data.length) {
                    lx = 0;
                    px = py;
                    dx = dy;
                    while (lx < w && px < pixels.length && dx < data.length) {
                        pixels[px] = pm.cmpCount == 4 ? (data[dx + 0] & 0xFF) << 24 | (data[dx + 1] & 0xFF) << 16 | (data[dx + 2] & 0xFF) << 8 | data[dx + 3] & 0xFF : 0xFF000000 | (data[dx + 1] & 0xFF) << 16 | (data[dx + 2] & 0xFF) << 8 | data[dx + 3] & 0xFF;
                        ++lx;
                        ++px;
                        dx += 4;
                    }
                    ++ly;
                    py += bw;
                    dy += pm.rowBytes & Short.MAX_VALUE;
                }
                break;
            }
            case 16: {
                int dx;
                int px;
                int lx;
                int ly = 0;
                int py = 0;
                int dy = 0;
                while (ly < h && py < pixels.length && dy < data.length) {
                    lx = 0;
                    px = py;
                    dx = dy;
                    while (lx < w && px < pixels.length && dx < data.length) {
                        int sh = (data[dx + 0] & 0xFF) << 8 | data[dx + 1] & 0xFF;
                        r = (sh >>> 10 & 0x1F) * 255 / 31;
                        g = (sh >>> 5 & 0x1F) * 255 / 31;
                        b = (sh & 0x1F) * 255 / 31;
                        pixels[px] = 0xFF000000 | r << 16 | g << 8 | b;
                        ++lx;
                        ++px;
                        dx += 2;
                    }
                    ++ly;
                    py += bw;
                    dy += pm.rowBytes & Short.MAX_VALUE;
                }
                break;
            }
            case 8: {
                int dx;
                int px;
                int lx;
                int ly = 0;
                int py = 0;
                int dy = 0;
                while (ly < h && py < pixels.length && dy < data.length) {
                    lx = 0;
                    px = py;
                    dx = dy;
                    while (lx < w && px < pixels.length && dx < data.length) {
                        pixels[px] = colors[data[dx] & 0xFF];
                        ++lx;
                        ++px;
                        ++dx;
                    }
                    ++ly;
                    py += bw;
                    dy += pm.rowBytes & Short.MAX_VALUE;
                }
                break;
            }
            case 4: {
                int dx;
                int px;
                int lx;
                int ly = 0;
                int py = 0;
                int dy = 0;
                while (ly < h && py < pixels.length && dy < data.length) {
                    lx = 0;
                    px = py;
                    dx = dy;
                    while (lx < w && px < pixels.length && dx < data.length) {
                        pixels[px] = colors[data[dx] >>> 4 & 0xF];
                        pixels[px + 1] = colors[data[dx] & 0xF];
                        ++lx;
                        px += 2;
                        ++dx;
                    }
                    ++ly;
                    py += bw;
                    dy += pm.rowBytes & Short.MAX_VALUE;
                }
                break;
            }
            case 2: {
                int dx;
                int px;
                int lx;
                int ly = 0;
                int py = 0;
                int dy = 0;
                while (ly < h && py < pixels.length && dy < data.length) {
                    lx = 0;
                    px = py;
                    dx = dy;
                    while (lx < w && px < pixels.length && dx < data.length) {
                        pixels[px] = colors[data[dx] >>> 6 & 3];
                        pixels[px + 1] = colors[data[dx] >>> 4 & 3];
                        pixels[px + 2] = colors[data[dx] >>> 2 & 3];
                        pixels[px + 3] = colors[data[dx] & 3];
                        ++lx;
                        px += 4;
                        ++dx;
                    }
                    ++ly;
                    py += bw;
                    dy += pm.rowBytes & Short.MAX_VALUE;
                }
                break;
            }
            case 1: {
                int dx;
                int px;
                int lx;
                int ly = 0;
                int py = 0;
                int dy = 0;
                while (ly < h && py < pixels.length && dy < data.length) {
                    lx = 0;
                    px = py;
                    dx = dy;
                    while (lx < w && px < pixels.length && dx < data.length) {
                        pixels[px] = colors[data[dx] >>> 7 & 1];
                        pixels[px + 1] = colors[data[dx] >>> 6 & 1];
                        pixels[px + 2] = colors[data[dx] >>> 5 & 1];
                        pixels[px + 3] = colors[data[dx] >>> 4 & 1];
                        pixels[px + 4] = colors[data[dx] >>> 3 & 1];
                        pixels[px + 5] = colors[data[dx] >>> 2 & 1];
                        pixels[px + 6] = colors[data[dx] >>> 1 & 1];
                        pixels[px + 7] = colors[data[dx] & 1];
                        ++lx;
                        px += 8;
                        ++dx;
                    }
                    ++ly;
                    py += bw;
                    dy += pm.rowBytes & Short.MAX_VALUE;
                }
                break;
            }
        }
        BufferedImage img = new BufferedImage(w, h, 2);
        img.setRGB(0, 0, w, h, pixels, 0, bw);
        return img;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] encodeString(String s) {
        try {
            return s.getBytes("MACROMAN");
        }
        catch (UnsupportedEncodingException uee) {
            bs = new ByteArrayOutputStream(s.length());
            var6_3 = s.toCharArray();
            var5_4 = var6_3.length;
            var4_5 = 0;
            ** while (var4_5 < var5_4)
        }
lbl-1000:
        // 1 sources

        {
            ch = var6_3[var4_5];
            if (ch < '\u0080') {
                bs.write(ch);
            } else {
                found = false;
                i = 128;
                while (i < 256) {
                    if (PICTUtilities.MACROMAN[i] == ch) {
                        found = true;
                        bs.write(i);
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    bs.write(63);
                }
            }
            ++var4_5;
            continue;
        }
lbl26:
        // 1 sources

        return bs.toByteArray();
    }

    /*
     * Unable to fully structure code
     */
    public static String decodeString(byte[] data) {
        try {
            return new String(data, "MACROMAN");
        }
        catch (UnsupportedEncodingException uee) {
            sb = new StringBuffer(data.length);
            var6_3 = data;
            var5_4 = data.length;
            var4_5 = 0;
            ** while (var4_5 < var5_4)
        }
lbl-1000:
        // 1 sources

        {
            b = var6_3[var4_5];
            if (b >= 0) {
                sb.append((char)b);
            } else {
                sb.append(PICTUtilities.MACROMAN[b & 255]);
            }
            ++var4_5;
            continue;
        }
lbl18:
        // 1 sources

        return sb.toString();
    }
}

