//  Copyright (c) 2014 Anton Bikineev
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const std::array<std::array<typename table_type<T>::type, 3>, 720
#if LDBL_MAX_10_EXP < 370
      - 5
#endif
   > bessel_j_prime_data = {{
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.553809732082299888134002685546875e-4), SC_(7.9648978910149220644314151981633892502393579865714) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.69304020144045352935791015625e-4), SC_(6.3653848991988529988220477650241685520191503142332) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.23264062474481761455535888671875e-3), SC_(1.8971705960000986690398059822421160899926699465394) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.4480001516640186309814453125e-3), SC_(0.98529897246253853844800411025777530163752073502973) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.5502865533344447612762451171875e-3), SC_(0.80213378584577808385371731269994831627611100850731) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.19227224402129650115966796875e-2), SC_(0.22881945446922959370415245044176092614274648710909) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.37370622158050537109375e-2), SC_(0.11639238325218579687879378821010964741303634572024) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.47696642577648162841796875e-2), SC_(0.090285635947979939708760228970288288400405507095951) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.1275280676782131195068359375e-1), SC_(0.028310110253065767611367722783039281567929780822508) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.20440109074115753173828125e-1), SC_(0.011437832630785135189848926023917028888883030118541) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.3429813683032989501953125e-1), SC_(-0.0042186780829510697643927657163520133060777440127718) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.96701286733150482177734375e-1), SC_(-0.043654403685014564129834014054367553568659669792961) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.159812271595001220703125e0), SC_(-0.076795076483668747332489412246651051532303741843621) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.297095477581024169921875e0), SC_(-0.14530589560654803595230285920771334403536798001997) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.77344071865081787109375e0), SC_(-0.35781255859257494677870346599515476750516695439221) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.1992881298065185546875e1), SC_(-0.57709619128762175849182337519495024595142653978034) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.3915013790130615234375e1), SC_(0.032874697176171305159599881134984554120579875033562) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.79858455657958984375e1), SC_(-0.23248455952535491176666424888090762133592541368724) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.1571910858154296875e2), SC_(-0.13744744338917036209493697966640300199111782413145) }}, 
      {{ SC_(0.4430477856658399105072021484375e-3), SC_(0.31483119964599609375e2), SC_(0.092384054297253080189500208979099324382934270491253) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.553809732082299888134002685546875e-4), SC_(9.9563140737354415945593422946525211226319134399898) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.69304020144045352935791015625e-4), SC_(7.9570862305908154157502670767893857144258643910134) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.23264062474481761455535888671875e-3), SC_(2.3719155181483651140283794679798873388028215296304) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.4480001516640186309814453125e-3), SC_(1.2319894744844574970516920107312783189510124193957) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.5502865533344447612762451171875e-3), SC_(1.0030112034602294475985095364967567453689835477452) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.19227224402129650115966796875e-2), SC_(0.28638350069997314241293417948854845587335617752927) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.37370622158050537109375e-2), SC_(0.14602972396377771654216460801323111364027557644216) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.47696642577648162841796875e-2), SC_(0.11351290994319074087410492441665358190230772804358) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.1275280676782131195068359375e-1), SC_(0.037008791924439581267986370097571362280888733460166) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.20440109074115753173828125e-1), SC_(0.016870508777086141024636797643775059196570100354985) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.3429813683032989501953125e-1), SC_(-0.0009748286242877649280689834700793092180965082559188) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.96701286733150482177734375e-1), SC_(-0.042489525327810393709078101729898351459510301627119) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.159812271595001220703125e0), SC_(-0.076077771654874512175725382541977707974494001219809) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.297095477581024169921875e0), SC_(-0.1449016974533794537266458225037915821627831419956) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.77344071865081787109375e0), SC_(-0.35763606304629819698651497909483012152923309977282) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.1992881298065185546875e1), SC_(-0.57707668367484666209769235993304653592448524328446) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.3915013790130615234375e1), SC_(0.032803565971798883663621750338601798771900853737723) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.79858455657958984375e1), SC_(-0.23245627383271580403946117793068576486562704835183) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.1571910858154296875e2), SC_(-0.13747319597155377972477306724918905968623791762052) }}, 
      {{ SC_(0.554432161152362823486328125e-3), SC_(0.31483119964599609375e2), SC_(0.092402972740382015495412561744044435050456817053477) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.553809732082299888134002685546875e-4), SC_(32.991155195510662374452228181394207719668827912585) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.69304020144045352935791015625e-4), SC_(26.374288085785808071594815766184735941437037668361) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.23264062474481761455535888671875e-3), SC_(7.8745670452285410777433428652060226596690838235756) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.4480001516640186309814453125e-3), SC_(4.0939888412516262352091077877368046329988231549179) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.5502865533344447612762451171875e-3), SC_(3.3341891189206161618889782248584501135265038836937) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.19227224402129650115966796875e-2), SC_(0.95560384937570815980175679166160209025653903976137) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.37370622158050537109375e-2), SC_(0.49090952938765514533182157874449576923325297005204) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.47696642577648162841796875e-2), SC_(0.38389476017333637199587327253156428168993195132975) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.1275280676782131195068359375e-1), SC_(0.138409389156362855297988849958748604218151741016) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.20440109074115753173828125e-1), SC_(0.080241816559198872765517481865392895830572812371149) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.3429813683032989501953125e-1), SC_(0.036892112652472221644586526213180260842441269686804) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.96701286733150482177734375e-1), SC_(-0.02887110612739140483997421990789250909295516887439) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.159812271595001220703125e0), SC_(-0.067685739169149094863754883494101630051701749161209) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.297095477581024169921875e0), SC_(-0.14016851381502971127112075638647269597367135444309) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.77344071865081787109375e0), SC_(-0.35556632184765282255617154328610427789832356622214) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.1992881298065185546875e1), SC_(-0.57684653674632859345467293924518112947171640665078) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.3915013790130615234375e1), SC_(0.031969124632149993427358514338814374853801046758595) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.79858455657958984375e1), SC_(-0.23212392987235794473256668897443830855028454545551) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.1571910858154296875e2), SC_(-0.13777498598113913007808999712256844131654804580519) }}, 
      {{ SC_(0.186112499795854091644287109375e-2), SC_(0.31483119964599609375e2), SC_(0.092624697644537533475041370994881579560890987351129) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.553809732082299888134002685546875e-4), SC_(62.454904613305025985092541568718072298279856562443) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.69304020144045352935791015625e-4), SC_(49.947950666961749968398510500237745648681418603404) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.23264062474481761455535888671875e-3), SC_(14.944193661627905898455586863695741230110016599631) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.4480001516640186309814453125e-3), SC_(7.7784129572206297283822428686304106551362644795044) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.5502865533344447612762451171875e-3), SC_(6.3371526780999425820466081747816869557736781837329) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.19227224402129650115966796875e-2), SC_(1.820993665575078594500973453282200116278151251087) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.37370622158050537109375e-2), SC_(0.9377936281725870885241868271005730443425730711559) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.47696642577648162841796875e-2), SC_(0.73450867711905500446374700000456510885348368932524) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.1275280676782131195068359375e-1), SC_(0.27029553238094754272834952547486499293865621939941) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.20440109074115753173828125e-1), SC_(0.16278442505650975565354006872279918590899945301714) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.3429813683032989501953125e-1), SC_(0.086292944004707690950589840564950857129632612299699) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.96701286733150482177734375e-1), SC_(-0.01104782892769029720544801382986554239946069854045) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.159812271595001220703125e0), SC_(-0.05668535469393136238714153940266293419595207886607) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.297095477581024169921875e0), SC_(-0.13395208202148233977338620116710632764449019915955) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.77344071865081787109375e0), SC_(-0.35283962535090438998824674990498799699024494912424) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.1992881298065185546875e1), SC_(-0.57653944367953511466145604243653167683836799979183) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.3915013790130615234375e1), SC_(0.030868990724401199078667741038245477603972593270015) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.79858455657958984375e1), SC_(-0.23168428917079507517559801618314290273647233672929) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.1571910858154296875e2), SC_(-0.13817198405516350060106646524335248058260389189795) }}, 
      {{ SC_(0.35840012133121490478515625e-2), SC_(0.31483119964599609375e2), SC_(0.092916436595105559391595180151309343563751077592049) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.553809732082299888134002685546875e-4), SC_(76.094037091452672841408919517251753935599130990416) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.69304020144045352935791015625e-4), SC_(60.86694014763617381883362484413204002437988483891) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.23264062474481761455535888671875e-3), SC_(18.229182783832605707598240444273148205330129326374) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.4480001516640186309814453125e-3), SC_(9.4933663212904445110802371668553605819628244021874) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.5502865533344447612762451171875e-3), SC_(7.7356648564267450544222554441272100183990241145299) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.19227224402129650115966796875e-2), SC_(2.2253316945948961542743895239623228539455376609079) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.37370622158050537109375e-2), SC_(1.1469531280898255753143802718054167596670751930758) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.47696642577648162841796875e-2), SC_(0.8987138042469555955140638448947036336020766497208) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.1275280676782131195068359375e-1), SC_(0.33222006268427673176001775575327506626793624720047) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.20440109074115753173828125e-1), SC_(0.20158797802098065441112035562918896779201063031557) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.3429813683032989501953125e-1), SC_(0.10954754542608689498762692934343451061816281331611) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.96701286733150482177734375e-1), SC_(-0.0026352030152986806285640288099372676975308652569059) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.159812271595001220703125e0), SC_(-0.051486300229518660533195827724135883555923546965981) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.297095477581024169921875e0), SC_(-0.13100921711901138238440294338076135399910977624865) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.77344071865081787109375e0), SC_(-0.35154547252275810168236545554332529311171223761341) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.1992881298065185546875e1), SC_(-0.57639213881628347984110125372663315128642382553447) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.3915013790130615234375e1), SC_(0.030346508334070453430651975727124470878861233027065) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.79858455657958984375e1), SC_(-0.23147490443190245853754535262108083070463877602731) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.1571910858154296875e2), SC_(-0.13836017664760414231270840005996432417492176750639) }}, 
      {{ SC_(0.44022924266755580902099609375e-2), SC_(0.31483119964599609375e2), SC_(0.093054758085530830928594196942552871371673202587369) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.553809732082299888134002685546875e-4), SC_(238.40366837144969439786103525601379114477677307153) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.69304020144045352935791015625e-4), SC_(191.16712873573625819054755770058932780852989850252) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.23264062474481761455535888671875e-3), SC_(58.019648524540935308440305137519165694212527314843) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.4480001516640186309814453125e-3), SC_(30.43392563287949994188281672966817873020334162581) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.5502865533344447612762451171875e-3), SC_(24.85533168119730302852076771558049252631942520417) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.19227224402129650115966796875e-2), SC_(7.2510627068545058442709465549514403544652820845905) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.37370622158050537109375e-2), SC_(3.7677615674740978933153881013861943903635063551538) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.47696642577648162841796875e-2), SC_(2.962324331943341100101643624061007763061585442363) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.1275280676782131195068359375e-1), SC_(1.1197441963909279005647512732082270829583516807172) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.20440109074115753173828125e-1), SC_(0.69788572344937366417209880630068985545559719963545) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.3429813683032989501953125e-1), SC_(0.40883500813978713691656188814831957578718243471079) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.96701286733150482177734375e-1), SC_(0.10700157693081281268315564619716643090427720046237) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.159812271595001220703125e0), SC_(0.016686833954731293114143419204690913686819214571699) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.297095477581024169921875e0), SC_(-0.092124902842593660026469490242650431046031191860855) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.77344071865081787109375e0), SC_(-0.33423965946999394482766889004297913580285873083183) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.1992881298065185546875e1), SC_(-0.57432599769968961776379817247419230653628340804375) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.3915013790130615234375e1), SC_(0.023338620631847629186573253547315649793186094107388) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.79858455657958984375e1), SC_(-0.22862990513409971505075485840350294504759601811506) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.1571910858154296875e2), SC_(-0.1408624244371769854856489920229138227673726479075) }}, 
      {{ SC_(0.153817795217037200927734375e-1), SC_(0.31483119964599609375e2), SC_(0.094895516987968244278180735467242514989968258763469) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.553809732082299888134002685546875e-4), SC_(401.03396568589946004426626518285877552588221703456) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.69304020144045352935791015625e-4), SC_(322.62287318261062067717298841026124993076998674488) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.23264062474481761455535888671875e-3), SC_(99.653154993389532146468468431109235573777170772011) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.4480001516640186309814453125e-3), SC_(52.772263261102197213931020894608318973782604772283) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.5502865533344447612762451171875e-3), SC_(43.227918910310427346951401482833588864302431474419) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.19227224402129650115966796875e-2), SC_(12.842688059620175274882027252980428180593090063375) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.37370622158050537109375e-2), SC_(6.7390274818843771110431882385099223900918335630655) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.47696642577648162841796875e-2), SC_(5.3179544066533640875307065878216351879107714339398) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.1275280676782131195068359375e-1), SC_(2.0435872586177536078792092041967345862250992458715) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.20440109074115753173828125e-1), SC_(1.2876735976248464722948927962724955876009337432191) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.3429813683032989501953125e-1), SC_(0.7695517710363719560199084953580644660557370801408) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.96701286733150482177734375e-1), SC_(0.24290377631717472590521846883415245818694289017361) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.159812271595001220703125e0), SC_(0.10235005529723907433661732235444859781219501249974) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.297095477581024169921875e0), SC_(-0.042435615294286794584933169804436673619316094085801) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.77344071865081787109375e0), SC_(-0.31153951624955756434303873284759634801131236594004) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.1992881298065185546875e1), SC_(-0.57134179001101895426174918063867092457941541295507) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.3915013790130615234375e1), SC_(0.014084292266465387671395167120939259589073512924039) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.79858455657958984375e1), SC_(-0.22476853968317214175668684393591069876083251260042) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.1571910858154296875e2), SC_(-0.14410426741350497805067959400220228144811652583962) }}, 
      {{ SC_(0.298964977264404296875e-1), SC_(0.31483119964599609375e2), SC_(0.097284960842721393212129686759239789256691963503028) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.553809732082299888134002685546875e-4), SC_(471.37166027199904636448992655317335001891374159055) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.69304020144045352935791015625e-4), SC_(379.91116285051480646999270370930575306961149889076) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.23264062474481761455535888671875e-3), SC_(118.5284534444992075821831811768895269929912679192) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.4480001516640186309814453125e-3), SC_(63.108590829623409668728674133337195241661276845369) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.5502865533344447612762451171875e-3), SC_(51.782740477944861994269980994470261382762600222885) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.19227224402129650115966796875e-2), SC_(15.544268928226126013996693399734864212029429548413) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.37370622158050537109375e-2), SC_(8.201851891655569453083763318076996379118826086076) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.47696642577648162841796875e-2), SC_(6.4855739049686344648114313800340052759496043249306) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.1275280676782131195068359375e-1), SC_(2.5138871135928275926305029572436771696322567881157) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.20440109074115753173828125e-1), SC_(1.5916781747744183611274648494292175428501268833477) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.3429813683032989501953125e-1), SC_(0.95799797262309709141604993694108452124333919330399) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.96701286733150482177734375e-1), SC_(0.31579947123617941869611707561671330150093828419791) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.159812271595001220703125e0), SC_(0.14888173291743319960009767579178948429207967528609) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.297095477581024169921875e0), SC_(-0.015024472899673308434232353549495206900642161504769) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.77344071865081787109375e0), SC_(-0.29871719574571292554481591851730285072696777681315) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.1992881298065185546875e1), SC_(-0.5695170506150984259661777633403544300740993771699) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.3915013790130615234375e1), SC_(0.0088241564811086707700323604495282469314479926180765) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.79858455657958984375e1), SC_(-0.22252074121304244082814905021275049155573635418883) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.1571910858154296875e2), SC_(-0.14591516715942387781225219256610088658797868602279) }}, 
      {{ SC_(0.381573140621185302734375e-1), SC_(0.31483119964599609375e2), SC_(0.098622081487985938170665823000958903932402318502123) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.553809732082299888134002685546875e-4), SC_(664.32533220017027254391971447388193587419000066854) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.69304020144045352935791015625e-4), SC_(543.14993593518730741749191498326451276400043639821) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.23264062474481761455535888671875e-3), SC_(183.08336288980652399978057154064375325217723169095) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.4480001516640186309814453125e-3), SC_(101.64612195822514506176998699703728506643345094973) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.5502865533344447612762451171875e-3), SC_(84.506782718783720410448144330858098521084558727765) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.19227224402129650115966796875e-2), SC_(27.478220778710823046480038139592344032974668283707) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.37370622158050537109375e-2), SC_(15.128612926718659706649583727766003486783508333581) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.47696642577648162841796875e-2), SC_(12.151610485805330583680296655400661422227790007773) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.1275280676782131195068359375e-1), SC_(5.0211988998270532788268629016500275009843181242807) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.20440109074115753173828125e-1), SC_(3.2833219226395894112637198307152793560437862511832) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.3429813683032989501953125e-1), SC_(2.0554845436111618577861954626046424038152843282732) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.96701286733150482177734375e-1), SC_(0.77926568698038937491970225128994882478930938769704) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.159812271595001220703125e0), SC_(0.45721448413953804880695655665538011048753399905673) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.297095477581024169921875e0), SC_(0.17595838820313970743143597894791134659072435368234) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.77344071865081787109375e0), SC_(-0.20234566166487137369485686737700596512087693740505) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.1992881298065185546875e1), SC_(-0.55245918030755774838887327767713821647691140899172) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.3915013790130615234375e1), SC_(-0.031569198201922343172110667422174391061517226818925) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.79858455657958984375e1), SC_(-0.2039691459012116792448785415127453560623250119731) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.1571910858154296875e2), SC_(-0.15904726852684046112032774465846226271684901212158) }}, 
      {{ SC_(0.10202245414257049560546875e0), SC_(0.31483119964599609375e2), SC_(0.10837642621725891831814701112308531098361497776006) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.553809732082299888134002685546875e-4), SC_(571.56461253029527068669000527929821362358876374892) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.69304020144045352935791015625e-4), SC_(473.79891993387176204277266117549424341033534115977) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.23264062474481761455535888671875e-3), SC_(172.05485839720109929947386950671741510964174125916) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.4480001516640186309814453125e-3), SC_(99.451419236599843003505543369104449891542801629795) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.5502865533344447612762451171875e-3), SC_(83.734472657295616189146164005523297644578211848323) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.19227224402129650115966796875e-2), SC_(29.404772483993622542588632660044020277977277726233) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.37370622158050537109375e-2), SC_(16.864978089537872687292665548563751461942199756629) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.47696642577648162841796875e-2), SC_(13.751298647148757554892114002160659377601354266307) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.1275280676782131195068359375e-1), SC_(6.0380360220553402596187004316610073017626864386626) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.20440109074115753173828125e-1), SC_(4.0663497714573359019588027393685113619794756585739) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.3429813683032989501953125e-1), SC_(2.6316996446281341936928939605476135172192414133571) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.96701286733150482177734375e-1), SC_(1.0800675534525642651799516999243058856882873167878) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.159812271595001220703125e0), SC_(0.67608209128463307278540094735467713432457749748998) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.297095477581024169921875e0), SC_(0.32608584374570126390899798719606813371587094547022) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.77344071865081787109375e0), SC_(-0.11501166816312720077701173878978907536708382694762) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.1992881298065185546875e1), SC_(-0.5314728961847169395439663807244209484201806638345) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.3915013790130615234375e1), SC_(-0.069744289285064377675956918739400471810698462043296) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.79858455657958984375e1), SC_(-0.18428739558678179918427752660934248572747222415676) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.1571910858154296875e2), SC_(-0.1701631830918606829888917633341779466808057826876) }}, 
      {{ SC_(0.163520872592926025390625e0), SC_(0.31483119964599609375e2), SC_(0.11673308889048171105260368484675293209410925971813) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.553809732082299888134002685546875e-4), SC_(308.58717356564466122617332899775649932714521649465) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.69304020144045352935791015625e-4), SC_(262.24338485799954579780263297984006371132805035765) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.23264062474481761455535888671875e-3), SC_(108.9140590822161623522014027028903621483296652945) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.4480001516640186309814453125e-3), SC_(67.698524590607803770047215956766889859219483667364) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.5502865533344447612762451171875e-3), SC_(58.314147078221691243234467406671269644673760065121) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.19227224402129650115966796875e-2), SC_(23.524741367197420763016782522906886655519879108938) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.37370622158050537109375e-2), SC_(14.524298936061566153087691391710501642546074047005) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.47696642577648162841796875e-2), SC_(12.167592249583090776182625308742942167019780554995) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.1275280676782131195068359375e-1), SC_(5.9591275776624168861248857531487249839683845595979) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.20440109074115753173828125e-1), SC_(4.2299993011890053254279767431385415972934287315434) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.3429813683032989501953125e-1), SC_(2.901983653662807706186712037814246852226231939235) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.96701286733150482177734375e-1), SC_(1.3496909380852439982995232509799172125294458203756) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.159812271595001220703125e0), SC_(0.91242525126551893446034914814532227010185508362973) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.297095477581024169921875e0), SC_(0.52064973039523048311960600009969390809510145563536) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.77344071865081787109375e0), SC_(0.02608182887713046998809955385365744878009456148488) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.1992881298065185546875e1), SC_(-0.48404394822521381052237521035874668152259518700201) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.3915013790130615234375e1), SC_(-0.13570201616386784215064959012924578121705433926688) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.79858455657958984375e1), SC_(-0.14498096948845041264536656900929936579020113377736) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.1571910858154296875e2), SC_(-0.18612546203267788136068772916555345383472834252897) }}, 
      {{ SC_(0.27438509464263916015625e0), SC_(0.31483119964599609375e2), SC_(0.12899781806261234090869739907021396206645515298816) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.553809732082299888134002685546875e-4), SC_(4.5011877008533588406242902236972176812286396782147) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.69304020144045352935791015625e-4), SC_(4.2783592963711542722485419051158488559847591811376) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.23264062474481761455535888671875e-3), SC_(3.2524659231367346417319767900467632749684587310339) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.4480001516640186309814453125e-3), SC_(2.8040379463680128740339422361998161891966695531645) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.5502865533344447612762451171875e-3), SC_(2.6764851124726492809937356104371686943624485612184) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.19227224402129650115966796875e-2), SC_(2.0163238633002003883069078490143730782017724876012) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.37370622158050537109375e-2), SC_(1.7346779498572830113915766279181497675283514219914) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.47696642577648162841796875e-2), SC_(1.6414560048736575318308206797185026809228580164098) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.1275280676782131195068359375e-1), SC_(1.3137218795657822490779781671024980814327832331883) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.20440109074115753173828125e-1), SC_(1.180498075807418501180599163023571364750679628292) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.3429813683032989501953125e-1), SC_(1.0495646967259391880319945252197306235384421843019) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.96701286733150482177734375e-1), SC_(0.82660826007368357107844931444771102363686958247508) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.159812271595001220703125e0), SC_(0.731697482250621946652780569750887216236363899678) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.297095477581024169921875e0), SC_(0.61562951899129792899436180038485577042502506518948) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.77344071865081787109375e0), SC_(0.36903938849520530212100602283754257446521956733474) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.1992881298065185546875e1), SC_(-0.19291140031800296501062914346386249321856024518691) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.3915013790130615234375e1), SC_(-0.35154036868679467260867304469480385731081099786064) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.79858455657958984375e1), SC_(0.059788933964965057005597574789855169709617546272128) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.1571910858154296875e2), SC_(-0.18723724545953900368479270357924724748499087579889) }}, 
      {{ SC_(0.773610293865203857421875e0), SC_(0.31483119964599609375e2), SC_(0.13400966478970684572882507496313188732146052204823) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.553809732082299888134002685546875e-4), SC_(0.029850558043384652101507429968555915143293202103747) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.69304020144045352935791015625e-4), SC_(0.031774415911652133140438383435382850754016739448122) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.23264062474481761455535888671875e-3), SC_(0.044519196152686710899624947084732057474064859756012) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.4480001516640186309814453125e-3), SC_(0.05343253965558058233007650357966646952486068878882) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.5502865533344447612762451171875e-3), SC_(0.056582050509995888920320047141538194664133884681765) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.19227224402129650115966796875e-2), SC_(0.080166705694688052505251448743101310730920964564891) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.37370622158050537109375e-2), SC_(0.096465313480839719026158485392665569685381937552601) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.47696642577648162841796875e-2), SC_(0.10324738754283731303233215056391131014396578323982) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.1275280676782131195068359375e-1), SC_(0.13577304320543918389355602959763206583957881062266) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.20440109074115753173828125e-1), SC_(0.15482474065003848502331515636750756782541403873783) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.3429813683032989501953125e-1), SC_(0.17879300147557342620703893492988364828644117397711) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.96701286733150482177734375e-1), SC_(0.23807839596703794694358205999845219045526959814198) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.159812271595001220703125e0), SC_(0.27258280278021451601361913139001300975146484153291) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.297095477581024169921875e0), SC_(0.3182433247889726108818474117334822562641936486915) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.77344071865081787109375e0), SC_(0.35683698469364376739850271914475103829253363482033) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.1992881298065185546875e1), SC_(0.070741464135753463004945635716734698943142968309161) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.3915013790130615234375e1), SC_(-0.39520273941287401008062462430234282654359660068325) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.79858455657958984375e1), SC_(0.22731076694710148914187566403459737901915531083197) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.1571910858154296875e2), SC_(-0.084753297042445161674776706201678874508373230926603) }}, 
      {{ SC_(0.1278498172760009765625e1), SC_(0.31483119964599609375e2), SC_(0.062225090158300477948826393889918289525552791431653) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.553809732082299888134002685546875e-4), SC_(2.1701155503596191995420732909718061056519326940212e-07) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.69304020144045352935791015625e-4), SC_(2.9551306553591138969355587313633131125997108375235e-07) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.23264062474481761455535888671875e-3), SC_(1.5655037999064767060378816153887775846765797047542e-06) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.4480001516640186309814453125e-3), SC_(3.8589657176343035828125278487873301105081231582557e-06) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.5502865533344447612762451171875e-3), SC_(5.1218954522128421501593736983874506030386512416042e-06) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.19227224402129650115966796875e-2), SC_(2.8672424699646570395201270796019428364107586215741e-05) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.37370622158050537109375e-2), SC_(7.1584131269989352016160990684310779348068505393798e-05) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.47696642577648162841796875e-2), SC_(0.00010016008067897047409150409831104755079644144359547) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.1275280676782131195068359375e-1), SC_(0.00038790640527498589848030243407349786907898487932215) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.20440109074115753173828125e-1), SC_(0.00074264228806456515397818291416507336565139941621982) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.3429813683032989501953125e-1), SC_(0.0015143065765106452690160624557993131465970744618239) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.96701286733150482177734375e-1), SC_(0.0063022557752983131925389842798930716204158533142837) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.159812271595001220703125e0), SC_(0.012557870640894605088772791192937453429777750849756) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.297095477581024169921875e0), SC_(0.029237072013682764068068954048522330751472665213812) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.77344071865081787109375e0), SC_(0.10168572061348920979793506543435383085628690885422) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.1992881298065185546875e1), SC_(0.22002878862596836274705220424499496372405634108772) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.3915013790130615234375e1), SC_(-0.10735465363172394169227652967155355244369432964178) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.79858455657958984375e1), SC_(0.18557681844475882257368896788898742437796376971596) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.1571910858154296875e2), SC_(0.18371304256631794662900176415524300546583527613927) }}, 
      {{ SC_(0.2376763820648193359375e1), SC_(0.31483119964599609375e2), SC_(-0.132794081024849303698958724423239291321967763688) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.553809732082299888134002685546875e-4), SC_(6.8618859334909328064313466022394478855895492126519e-27) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.69304020144045352935791015625e-4), SC_(2.1963286138774191146212025856359161441752536770309e-26) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.23264062474481761455535888671875e-3), SC_(1.1747834954200665458190549366081650771028030041504e-23) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.4480001516640186309814453125e-3), SC_(3.5179470865688125605246868941659466149519669762622e-22) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.5502865533344447612762451171875e-3), SC_(1.0223298989181615516658896945180863312854077986829e-21) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.19227224402129650115966796875e-2), SC_(6.7315860122034580871008571630351185332456357893131e-19) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.37370622158050537109375e-2), SC_(2.1149902345470196631249308634396410671647936549547e-17) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.47696642577648162841796875e-2), SC_(7.4983438891842891949410561775177614183558926276208e-17) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.1275280676782131195068359375e-1), SC_(1.2321058610359859670269189410586432608108543114872e-14) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.20440109074115753173828125e-1), SC_(1.4238028742033350327295610376208111939565068601957e-13) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.3429813683032989501953125e-1), SC_(2.0870108710052736709734956183853084596264302832559e-12) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.96701286733150482177734375e-1), SC_(4.5142628098260017065921905421191994854871890889804e-10) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.159812271595001220703125e0), SC_(6.1103562371576358382673002203839388993107168425553e-09) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.297095477581024169921875e0), SC_(1.519636746861460104553494708390828117800452172163e-07) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.77344071865081787109375e0), SC_(2.1237148222110387293617790655585931062215718762736e-05) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.1992881298065185546875e1), SC_(0.0024588707692055920796691283803993300690882442105627) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.3915013790130615234375e1), SC_(0.046142562971005864860944948899495431154518217952264) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.79858455657958984375e1), SC_(-0.036548537606470732421518346681033426360824355915209) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.1571910858154296875e2), SC_(-0.037440476178607689137062960891986908987275885225747) }}, 
      {{ SC_(0.618752574920654296875e1), SC_(0.31483119964599609375e2), SC_(-0.053576073500905579152051157218411132644761366492076) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.553809732082299888134002685546875e-4), SC_(3.5053748870324995265456069209257845719284000016634e-81) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.69304020144045352935791015625e-4), SC_(1.0003578068450191800043421410644801174017783442525e-79) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.23264062474481761455535888671875e-3), SC_(7.2295444983737221812617930416172046668810632639086e-72) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.4480001516640186309814453125e-3), SC_(1.2935778727519334502228823307340051077028641833215e-67) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.5502865533344447612762451171875e-3), SC_(2.7949076296376557021885976463896668140336092550744e-66) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.19227224402129650115966796875e-2), SC_(3.6757041380152731439397127857389554537960795984033e-58) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.37370622158050537109375e-2), SC_(7.5528355643960719116071021399542489454669220709129e-54) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.47696642577648162841796875e-2), SC_(2.8935963637630571857817897238455867910507638566588e-52) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.1275280676782131195068359375e-1), SC_(6.9804316898025259378717377799203520816940258467987e-46) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.20440109074115753173828125e-1), SC_(8.0421875393174843026599169482683520199102109359004e-43) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.3429813683032989501953125e-1), SC_(1.8381331544029745344694037671121786066061079707414e-39) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.96701286733150482177734375e-1), SC_(9.7973210467711664664952969673463280706045049213375e-33) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.159812271595001220703125e0), SC_(1.7833373802207954525116645092242418737555089885756e-29) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.297095477581024169921875e0), SC_(1.8824962469467906426300941758297149966409708294099e-25) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.77344071865081787109375e0), SC_(3.0224248046138209957759204404908493425528586816012e-19) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.1992881298065185546875e1), SC_(3.9661637521587291221956898563816149044021936980709e-13) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.3915013790130615234375e1), SC_(7.9002899016129279712962003653587507151377945199827e-09) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.79858455657958984375e1), SC_(0.00014361841243492096755775570171774438376661025382511) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.1571910858154296875e2), SC_(0.062984203221968378735689416171937661262267669219313) }}, 
      {{ SC_(0.15943050384521484375e2), SC_(0.31483119964599609375e2), SC_(0.048726541788000567271971666259984984863708245546479) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.553809732082299888134002685546875e-4), SC_(4.0775347617763827917636312558685682614460296107351e-172) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.69304020144045352935791015625e-4), SC_(3.6602525887553747946846569939947031192010308649901e-169) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.23264062474481761455535888671875e-3), SC_(3.2335500910719629265098050470900045320840646714859e-153) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.4480001516640186309814453125e-3), SC_(1.375811039138230237509060754300309226643944989626e-144) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.5502865533344447612762451171875e-3), SC_(7.0221526672657324482881656358705892542540431557517e-142) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.19227224402129650115966796875e-2), SC_(2.0903831170965663042808465354655697911514904752221e-125) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.37370622158050537109375e-2), SC_(1.1776766990907131544102457790255832296878257403093e-116) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.47696642577648162841796875e-2), SC_(1.9216247227927533544279814467673995609976280557166e-113) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.1275280676782131195068359375e-1), SC_(1.7136891099016486824251149584090773081176918430606e-100) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.20440109074115753173828125e-1), SC_(2.7914984872320211168187337887690887640432614280739e-94) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.3429813683032989501953125e-1), SC_(1.8256226510148527935317893516684443597280757769692e-87) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.96701286733150482177734375e-1), SC_(8.1345764464977027290798421463540075558737704545228e-74) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.159812271595001220703125e0), SC_(3.3531596261917949046621108542546348529678441385801e-67) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.297095477581024169921875e0), SC_(4.8978868001918715331354461307339987339721794255557e-59) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.77344071865081787109375e0), SC_(1.9370088688037995439389481817923380471357651000902e-46) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.1992881298065185546875e1), SC_(5.4737238540903762602781816763163779144308589723619e-34) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.3915013790130615234375e1), SC_(3.881678194319896190940421213131620834895771313082e-25) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.79858455657958984375e1), SC_(6.3193787632639199392093155246439027531457067096666e-16) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.1571910858154296875e2), SC_(1.0757417878047579347014714535384238216124501720368e-07) }}, 
      {{ SC_(0.31320110321044921875e2), SC_(0.31483119964599609375e2), SC_(0.040110799787632381784207142268257697341685918101293) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.553809732082299888134002685546875e-4), SC_(9.7441627699885499410827511483200119322124780648042e-375) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.69304020144045352935791015625e-4), SC_(1.2995106109464785944326424074902975173100812521663e-368) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.23264062474481761455535888671875e-3), SC_(1.5404062639522853160415873118716407582565237381265e-335) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.4480001516640186309814453125e-3), SC_(1.2154677714932701807701788654862612084731965495875e-317) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.5502865533344447612762451171875e-3), SC_(5.0258196383445896775189854678057167837900551572717e-312) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.19227224402129650115966796875e-2), SC_(7.4016350970405039598626088642455006858620983926416e-278) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.37370622158050537109375e-2), SC_(1.0454698907387783780995294442636270647131473144215e-259) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.47696642577648162841796875e-2), SC_(4.8154258474909796291892217560161879062331113459005e-253) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.1275280676782131195068359375e-1), SC_(3.4890053812228262365551933998185601135755662319548e-226) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.20440109074115753173828125e-1), SC_(2.6716519485260519907154162062382147851855142100751e-213) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.3429813683032989501953125e-1), SC_(3.6553234108502009052689983290899255876096233293036e-199) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.96701286733150482177734375e-1), SC_(7.4494817279246493182746623255291237577365435287533e-171) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.159812271595001220703125e0), SC_(3.9137994342944840648848064301593067243483912784954e-157) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.297095477581024169921875e0), SC_(3.3651957455367603520477072956196864467681836841573e-140) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.77344071865081787109375e0), SC_(4.5449584997779609452485892006864158282660967869106e-114) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.1992881298065185546875e1), SC_(3.1738690593564315149084568119212749276724766074797e-88) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.3915013790130615234375e1), SC_(8.3876764286771252132826802696540899650253274908687e-70) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.79858455657958984375e1), SC_(2.0360585647990444278788749162236601635563310041312e-50) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.1571910858154296875e2), SC_(3.0526073572369540920510993833683057297997072099125e-32) }}, 
      {{ SC_(0.638867645263671875e2), SC_(0.31483119964599609375e2), SC_(1.3013718253615034389340624948143462041150530900802e-14) }},
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.553809732082299888134002685546875e-4), SC_(-8.0352542252744082481307789764332850495725489505518) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.69304020144045352935791015625e-4), SC_(-6.4203614240557396975159598870215603286914369267472) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.23264062474481761455535888671875e-3), SC_(-1.9117166148811325766281752377913954732416206414629) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.4480001516640186309814453125e-3), SC_(-0.99260548284661030715869392644415963191732106033528) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.5502865533344447612762451171875e-3), SC_(-0.80812102308096530154610129316254886762601435421338) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.19227224402129650115966796875e-2), SC_(-0.23204280558098084511900377653875824621676552518528) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.37370622158050537109375e-2), SC_(-0.12072881073365528081110447354284280286097688241442) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.47696642577648162841796875e-2), SC_(-0.09550482234825882986471274711567749300336105446854) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.1275280676782131195068359375e-1), SC_(-0.041200536588552429584692663160666456452528166189948) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.20440109074115753173828125e-1), SC_(-0.031953857997720357584406329160755725345223306098128) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.3429813683032989501953125e-1), SC_(-0.030114397251918849407455448148697810176670467012896) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.96701286733150482177734375e-1), SC_(-0.052943922496156634733598654692054268878542225130523) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.159812271595001220703125e0), SC_(-0.082512406889389859121119964777034049609087542474697) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.297095477581024169921875e0), SC_(-0.1485255232855737930936769690388900259610771996183) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.77344071865081787109375e0), SC_(-0.35921701000936262458882788686129315404924380806201) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.1992881298065185546875e1), SC_(-0.57725076140254553359619035776337545293419911217499) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.3915013790130615234375e1), SC_(0.03344057878006016634512803472601346746069423389441) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.79858455657958984375e1), SC_(-0.23270933528743421315094393225058324641266170812782) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.1571910858154296875e2), SC_(-0.13724241991231743790482116318841294154717999058952) }}, 
      {{ SC_(-0.4430477856658399105072021484375e-3), SC_(0.31483119964599609375e2), SC_(0.09223345027076750470936443925038834150827279095626) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.553809732082299888134002685546875e-4), SC_(-10.066461933961981507792651012082779846170093092464) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.69304020144045352935791015625e-4), SC_(-8.0431411620505830001205801846984349465397924171235) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.23264062474481761455535888671875e-3), SC_(-2.3945631396997411883835874017501010814598653177206) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.4480001516640186309814453125e-3), SC_(-1.24317801002101410502924982177759462923499541887) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.5502865533344447612762451171875e-3), SC_(-1.0120758401869629091718060378244288438918105198374) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.19227224402129650115966796875e-2), SC_(-0.290343027908152859987594626260946647758968814052) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.37370622158050537109375e-2), SC_(-0.15070540484639218955142273115487939108948046279471) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.47696642577648162841796875e-2), SC_(-0.11898654024366730550988334200337880054318356808187) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.1275280676782131195068359375e-1), SC_(-0.0499772596852495244874245461700334882818390416664) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.20440109074115753173828125e-1), SC_(-0.037430108063425835799519590547664772219450450501968) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.3429813683032989501953125e-1), SC_(-0.033380876891004635328352864168353940029550374102897) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.96701286733150482177734375e-1), SC_(-0.054114477302162225953130009474375517188926951365292) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.159812271595001220703125e0), SC_(-0.083232467669685253061367673958149012193392848388591) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.297095477581024169921875e0), SC_(-0.14893075527015439332896904430547462629618745403482) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.77344071865081787109375e0), SC_(-0.35939360026382634840654742706922579497977841714828) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.1992881298065185546875e1), SC_(-0.57727011342927087551404477979110589721068173726712) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.3915013790130615234375e1), SC_(0.033511712938247184637368117516909474935042592541487) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.79858455657958984375e1), SC_(-0.23273755930250967807670274825488612930894587031682) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.1571910858154296875e2), SC_(-0.1372166286029628510440359619069144703727812571868) }}, 
      {{ SC_(-0.554432161152362823486328125e-3), SC_(0.31483119964599609375e2), SC_(0.092214506134989611076380630559393619074408058160705) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.553809732082299888134002685546875e-4), SC_(-34.23181462635478507822028182175431717667781372624) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.69304020144045352935791015625e-4), SC_(-27.343305234815061782266099942561415206187905358958) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.23264062474481761455535888671875e-3), SC_(-8.1273848706336958801247737688897901209292092021741) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.4480001516640186309814453125e-3), SC_(-4.2154668275747577532914376948639503328977697483243) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.5502865533344447612762451171875e-3), SC_(-3.4306834084062242073710579346983737042959836829079) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.19227224402129650115966796875e-2), SC_(-0.98047811481492919485194315319699114598506569880073) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.37370622158050537109375e-2), SC_(-0.50522334567765460611684549984928050137085344804579) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.47696642577648162841796875e-2), SC_(-0.39659709058903377385769093723835590470045000851205) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.1275280676782131195068359375e-1), SC_(-0.15359498622072033524837235497894371364376142666273) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.20440109074115753173828125e-1), SC_(-0.10203933275007621452849842412025700533200021422624) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.3429813683032989501953125e-1), SC_(-0.071890730780152667728329364548984000561104628670664) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.96701286733150482177734375e-1), SC_(-0.067894161135302898753927696333004765903404565336037) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.159812271595001220703125e0), SC_(-0.091702795042273366918864368933079051253776349615004) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.297095477581024169921875e0), SC_(-0.15369330938238308353603724941747339435790440319313) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.77344071865081787109375e0), SC_(-0.36146603204720034107470261596786851111539114117332) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.1992881298065185546875e1), SC_(-0.57749584025045821649519328067660040724951358425785) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.3915013790130615234375e1), SC_(0.034346238192839986437454661389726380162962796912464) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.79858455657958984375e1), SC_(-0.23306815103996906158022747899333186165145736610782) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.1571910858154296875e2), SC_(-0.13691373838339331226340502813220267438067995036718) }}, 
      {{ SC_(-0.186112499795854091644287109375e-2), SC_(0.31483119964599609375e2), SC_(0.0919920513180825947021514188521270090148213581859) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.553809732082299888134002685546875e-4), SC_(-67.056271870501367994225299855943649508994694008781) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.69304020144045352935791015625e-4), SC_(-53.54175363140112840600408722647405310378615327513) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.23264062474481761455535888671875e-3), SC_(-15.881207988567703715841269602542397948644528477246) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.4480001516640186309814453125e-3), SC_(-8.2277264602230928321577393634479731870258896542248) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.5502865533344447612762451171875e-3), SC_(-6.6935299793980016595106177046127151318109557942752) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.19227224402129650115966796875e-2), SC_(-1.9080343185556542996070263658766565867706699008104) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.37370622158050537109375e-2), SC_(-0.98075508769550439856427681584737488373549344454508) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.47696642577648162841796875e-2), SC_(-0.76869690974782950106133359949158417619515396821915) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.1275280676782131195068359375e-1), SC_(-0.29207097823754910281828673784976328503050496866988) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.20440109074115753173828125e-1), SC_(-0.18826130081197235022050368628059551681437423139242) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.3429813683032989501953125e-1), SC_(-0.12320242306806411399618773723522603088969456177809) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.96701286733150482177734375e-1), SC_(-0.086196741643040794918353323989169170469643966496374) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.159812271595001220703125e0), SC_(-0.10293588278606317172915919860376209690449043973811) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.297095477581024169921875e0), SC_(-0.15999703383708213928376998492609103192731212394886) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.77344071865081787109375e0), SC_(-0.36420072514576095375697021685081027415781263362758) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.1992881298065185546875e1), SC_(-0.5777897961065323135784411639495384785398961081964) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.3915013790130615234375e1), SC_(0.035446621494767570487811034376588469298122718716537) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.79858455657958984375e1), SC_(-0.23350258387760681986463355584579626915696673116663) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.1571910858154296875e2), SC_(-0.13651347032628514403227301964467648017065563110308) }}, 
      {{ SC_(-0.35840012133121490478515625e-2), SC_(0.31483119964599609375e2), SC_(0.091698142960977290200573339181083827107643995436865) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.553809732082299888134002685546875e-4), SC_(-83.037093324551699684264024514810856743180212901972) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.69304020144045352935791015625e-4), SC_(-66.289631714700939041160686151256998148675866512178) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.23264062474481761455535888671875e-3), SC_(-19.642901163509752389779868654081295474333346675263) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.4480001516640186309814453125e-3), SC_(-10.171088008319663671664133300271419189326470432375) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.5502865533344447612762451171875e-3), SC_(-8.2731052285936332381740047283964449451220912606779) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.19227224402129650115966796875e-2), SC_(-2.3556822683937317247313924442328408419058805410856) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.37370622158050537109375e-2), SC_(-1.2098723277414120717362840825349623627912664595916) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.47696642577648162841796875e-2), SC_(-0.9478703513414677389752274599534819040946861477237) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.1275280676782131195068359375e-1), SC_(-0.35858625576974802550691928581679940729588638492127) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.20440109074115753173828125e-1), SC_(-0.22962801236819251757397379209933685966997055419062) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.3429813683032989501953125e-1), SC_(-0.14778817682245036702917674194825307709095027340792) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.96701286733150482177734375e-1), SC_(-0.094943256228300421415696973236887828585507524283866) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.159812271595001220703125e0), SC_(-0.10829704020665712735091858934626890105404920145588) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.297095477581024169921875e0), SC_(-0.16300070709542560570938729145871767601360179849028) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.77344071865081787109375e0), SC_(-0.3655004483031575939694898478341350666944952239863) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.1992881298065185546875e1), SC_(-0.57792794944990254997704488561736555219857438938245) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.3915013790130615234375e1), SC_(0.035969277603863220159373882638485036321550606702405) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.79858455657958984375e1), SC_(-0.23370834076421522509139405806963960754726703194536) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.1571910858154296875e2), SC_(-0.13632299983189670750128563440512332933275681273293) }}, 
      {{ SC_(-0.44022924266755580902099609375e-2), SC_(0.31483119964599609375e2), SC_(0.091558310240599352987648819858958500654626497622027) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.553809732082299888134002685546875e-4), SC_(-323.45213945463234229013889680154351663561974016062) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.69304020144045352935791015625e-4), SC_(-257.58113725156369155776353286297851561131398667063) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.23264062474481761455535888671875e-3), SC_(-75.317853600830156764876591365747013181276745596686) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.4480001516640186309814453125e-3), SC_(-38.719511928695320833962932311070646235997196088527) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.5502865533344447612762451171875e-3), SC_(-31.422940951603923960515705608615289434032537674218) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.19227224402129650115966796875e-2), SC_(-8.8228739279443535003892578553342007432481062429613) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.37370622158050537109375e-2), SC_(-4.494723735604328765849150940140384573461736537374) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.47696642577648162841796875e-2), SC_(-3.5094625015210048661409444547047934231422637263711) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.1275280676782131195068359375e-1), SC_(-1.2987840043766237769332520032909456200005454056879) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.20440109074115753173828125e-1), SC_(-0.81115532009477097779611346576000499612899829740578) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.3429813683032989501953125e-1), SC_(-0.49133226391051353605553180300057321370516441349176) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.96701286733150482177734375e-1), SC_(-0.2156781193538221291294131700670540860931335417735) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.159812271595001220703125e0), SC_(-0.18185780425851551020497584257730950378764999765613) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.297095477581024169921875e0), SC_(-0.20390584764589693945869205722862488999236954450902) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.77344071865081787109375e0), SC_(-0.38299131775239725628819178645949094448183644930876) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.1992881298065185546875e1), SC_(-0.57968991614193627415054042875367289442368646934083) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.3915013790130615234375e1), SC_(0.042982933758334960569313811710720824706658812629693) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.79858455657958984375e1), SC_(-0.23643275937887443493821264201271578938035690601526) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.1571910858154296875e2), SC_(-0.13374504140868466884225855542680423136816728178356) }}, 
      {{ SC_(-0.153817795217037200927734375e-1), SC_(0.31483119964599609375e2), SC_(0.089667322440366316066610578376619970625122122450226) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.553809732082299888134002685546875e-4), SC_(-725.60388812634502116497577581096174464417453225645) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.69304020144045352935791015625e-4), SC_(-575.95680685121341045918860034843655536920144089988) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.23264062474481761455535888671875e-3), SC_(-165.47781280790728282138565486596148860048073676555) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.4480001516640186309814453125e-3), SC_(-84.263583652514398857809003219385428308331914261355) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.5502865533344447612762451171875e-3), SC_(-68.180449557757530865047254894621656951671344565923) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.19227224402129650115966796875e-2), SC_(-18.798084691116705356273612415274160601829996663749) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.37370622158050537109375e-2), SC_(-9.4830284139916943844187972919233437926322988775231) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.47696642577648162841796875e-2), SC_(-7.3771153920678228700152931806394953960549947325041) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.1275280676782131195068359375e-1), SC_(-2.6855256727116933276782927513072232408947873802069) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.20440109074115753173828125e-1), SC_(-1.659202091637520422183682309841553410776457852149) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.3429813683032989501953125e-1), SC_(-0.98607609795233336610497632483947698925553853348121) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.96701286733150482177734375e-1), SC_(-0.38515834407554964739621903400858160980698817286248) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.159812271595001220703125e0), SC_(-0.28381588884959607872655877768989540276971009686577) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.297095477581024169921875e0), SC_(-0.25970485572060694094796989362887049565598977652468) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.77344071865081787109375e0), SC_(-0.40625023849997096854581923443441253397060457051724) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.1992881298065185546875e1), SC_(-0.58175396157051217096634558063818100887320516756666) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.3915013790130615234375e1), SC_(0.052254646856877522738100400866085077989749826572634) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.79858455657958984375e1), SC_(-0.23992935887127384086006384290591685783732754240095) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.1571910858154296875e2), SC_(-0.13027418083029205026658210487081901945580698823601) }}, 
      {{ SC_(-0.298964977264404296875e-1), SC_(0.31483119964599609375e2), SC_(0.087125939160498837675593513567607234396386781832874) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.553809732082299888134002685546875e-4), SC_(-1004.6859486021017541023203743332692346106393511949) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.69304020144045352935791015625e-4), SC_(-796.00547333588938545445386365357077325403216751374) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.23264062474481761455535888671875e-3), SC_(-226.42336780202248510553958166136698643505130141032) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.4480001516640186309814453125e-3), SC_(-114.67538358156769735145875983000068890294406176426) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.5502865533344447612762451171875e-3), SC_(-92.630113579906723071779947466604561257835459190343) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.19227224402129650115966796875e-2), SC_(-25.276228587228107324012897838280646226306407820917) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.37370622158050537109375e-2), SC_(-12.680763595940505459347521762950057239490506764601) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.47696642577648162841796875e-2), SC_(-9.8445493267327168890329951149142804596902310323753) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.1275280676782131195068359375e-1), SC_(-3.5529657578107153662393107250209547708707297913846) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.20440109074115753173828125e-1), SC_(-2.1845957832490827861233138950362163012593492434232) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.3429813683032989501953125e-1), SC_(-1.289323015773201826960839436618104305738849066685) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.96701286733150482177734375e-1), SC_(-0.486777735591057263230139625364066590512939127167) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.159812271595001220703125e0), SC_(-0.34427980661032442140812840139010665226749007184295) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.297095477581024169921875e0), SC_(-0.29233716519329701131207248408313295340191228187593) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.77344071865081787109375e0), SC_(-0.41954921569620798110383102549818658320238954428757) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.1992881298065185546875e1), SC_(-0.58279172954206145900906677183569582602038176823114) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.3915013790130615234375e1), SC_(0.05752957287882339804261284805013815435471324917482) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.79858455657958984375e1), SC_(-0.2418651953573152386189066686655477217073650188379) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.1571910858154296875e2), SC_(-0.12826743181414229865637491792217895852855237873308) }}, 
      {{ SC_(-0.381573140621185302734375e-1), SC_(0.31483119964599609375e2), SC_(0.085658882263130460924983003926708821343532049465639) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.553809732082299888134002685546875e-4), SC_(-5021.4388835985321077822197612494180215228611508713) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.69304020144045352935791015625e-4), SC_(-3921.8734307134052994591437509299821025250295550788) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.23264062474481761455535888671875e-3), SC_(-1032.5478352822006422528531545457632557402051621165) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.4480001516640186309814453125e-3), SC_(-501.51400874744938819546320667109536265200736389128) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.5502865533344447612762451171875e-3), SC_(-399.8166333544894648442811208436079709080356432968) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.19227224402129650115966796875e-2), SC_(-100.71848232122494924067861671571417782212617327175) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.37370622158050537109375e-2), SC_(-48.425426594435213772677350265517725377950510169043) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.47696642577648162841796875e-2), SC_(-37.01056268120809544427519087487383951231992638864) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.1275280676782131195068359375e-1), SC_(-12.529870507977695417379290742548380462554156354031) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.20440109074115753173828125e-1), SC_(-7.4600218209139626431874029585042163259340745663875) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.3429813683032989501953125e-1), SC_(-4.2336827459776509543039633593470530591144486647929) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.96701286733150482177734375e-1), SC_(-1.4076911758039395419438678561352416140994516102487) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.159812271595001220703125e0), SC_(-0.87364245158685752884071312682168379947181270610304) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.297095477581024169921875e0), SC_(-0.56581981271073774131848134488035157368952382106283) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.77344071865081787109375e0), SC_(-0.52334641335918569867220708820460190469418647348557) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.1992881298065185546875e1), SC_(-0.58733582447097000423159278592022563252973067325037) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.3915013790130615234375e1), SC_(0.098148426611487347492824812034647890766195227954355) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.79858455657958984375e1), SC_(-0.25545685118167396706373254697883910424384005529709) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.1571910858154296875e2), SC_(-0.11202340417340619861504442217252110116788114834578) }}, 
      {{ SC_(-0.10202245414257049560546875e0), SC_(0.31483119964599609375e2), SC_(0.073839678247298834355739968654379935792127228391286) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.553809732082299888134002685546875e-4), SC_(-14591.064213061089165837423518828097507666158372983) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.69304020144045352935791015625e-4), SC_(-11239.902564268926556604507173940790761066763746957) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.23264062474481761455535888671875e-3), SC_(-2746.8530583911553657584614056005107923329244981864) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.4480001516640186309814453125e-3), SC_(-1281.4633935425504671800390512188925490804517939886) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.5502865533344447612762451171875e-3), SC_(-1008.7683405233342969507420679482719911493815317167) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.19227224402129650115966796875e-2), SC_(-235.30073204152926713716247008806375707592231157316) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.37370622158050537109375e-2), SC_(-108.60007981381217337152204100307858589475338051002) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.47696642577648162841796875e-2), SC_(-81.76344982413764784378525698316628482243640292672) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.1275280676782131195068359375e-1), SC_(-26.049679340717903315713103086676133509501408128064) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.20440109074115753173828125e-1), SC_(-15.058953341128067901598825812053678646049489146363) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.3429813683032989501953125e-1), SC_(-8.2670895889416687400487118206671710803622383007887) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.96701286733150482177734375e-1), SC_(-2.5425726441082783539097226104706324323282907944463) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.159812271595001220703125e0), SC_(-1.4914567252730700937853154883220220116181475377399) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.297095477581024169921875e0), SC_(-0.8632725176533903359858477333142360141675842731196) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.77344071865081787109375e0), SC_(-0.6234292886729097644681651354134756448566678345503) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.1992881298065185546875e1), SC_(-0.58558610668515311817834536848864645073035983132359) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.3915013790130615234375e1), SC_(0.13668651414168138934340967404720630620976656638158) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.79858455657958984375e1), SC_(-0.26612983518078324262431516120429976552320108816765) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.1571910858154296875e2), SC_(-0.095264523648592787444884232574176294732450669999133) }}, 
      {{ SC_(-0.163520872592926025390625e0), SC_(0.31483119964599609375e2), SC_(0.06173752066484881976914818698955446252942030874574) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.553809732082299888134002685546875e-4), SC_(-70055.006417124017455883308196763018161565032369383) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.69304020144045352935791015625e-4), SC_(-52640.113594817198684386936391750444029168036133061) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.23264062474481761455535888671875e-3), SC_(-11248.203674019324536337199438466846592947765997285) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.4480001516640186309814453125e-3), SC_(-4879.8080035283893388040441594092795260474557634959) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.5502865533344447612762451171875e-3), SC_(-3754.7978085981910388267899865471598402118360736627) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.19227224402129650115966796875e-2), SC_(-762.39674662423880098867949611441126696630528369554) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.37370622158050537109375e-2), SC_(-326.87797411097895366160065584324895997801172344437) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.47696642577648162841796875e-2), SC_(-239.53186080281830983579670418013199291682381608593) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.1275280676782131195068359375e-1), SC_(-68.419850156793746757830431816786088124775866273892) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.20440109074115753173828125e-1), SC_(-37.525744669245238756963541430758905495168843320176) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.3429813683032989501953125e-1), SC_(-19.434623426150950622526401338014245375205379266868) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.96701286733150482177734375e-1), SC_(-5.278256043476905240140508445981318287783880252522) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.159812271595001220703125e0), SC_(-2.8777308956382304556048192286347294935922191210744) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.297095477581024169921875e0), SC_(-1.4710226796697763010123257766717571882497401271846) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.77344071865081787109375e0), SC_(-0.79642432308663174707004503487712244732812484279319) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.1992881298065185546875e1), SC_(-0.56612269402057352361688016332508188545049675733684) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.3915013790130615234375e1), SC_(0.20336091423685768783909328601206788571790985202848) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.79858455657958984375e1), SC_(-0.27894883313028255267330235996664759672024535305973) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.1571910858154296875e2), SC_(-0.062780398462795947357271687241684592413572950434451) }}, 
      {{ SC_(-0.27438509464263916015625e0), SC_(0.31483119964599609375e2), SC_(0.03849732252340896827395694578850472049659073379106) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.553809732082299888134002685546875e-4), SC_(-11643371.160466587585669407134435084427919016477159) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.69304020144045352935791015625e-4), SC_(-7822272.1898300553801367114473307038320493340483874) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.23264062474481761455535888671875e-3), SC_(-913152.25026118026767706305376317815062318601678415) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.4480001516640186309814453125e-3), SC_(-285618.89217363187058048532649939516725880162268906) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.5502865533344447612762451171875e-3), SC_(-198328.24134808742495322686233204368763113096517048) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.19227224402129650115966796875e-2), SC_(-21564.309161499202266153010760285217055861424115293) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.37370622158050537109375e-2), SC_(-6635.2160485548545867927262596655119927287446001148) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.47696642577648162841796875e-2), SC_(-4304.6165067879596667544757848951548833552069326892) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.1275280676782131195068359375e-1), SC_(-752.48867462527562508752217575030123403028930518054) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.20440109074115753173828125e-1), SC_(-326.07771358935044259815120056192030387572987185451) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.3429813683032989501953125e-1), SC_(-130.38021269958001460550773617540933755870967270791) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.96701286733150482177734375e-1), SC_(-21.03494823343058616292489481214304589704518288651) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.159812271595001220703125e0), SC_(-8.8677490983754768902167272470145959243449594675605) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.297095477581024169921875e0), SC_(-3.2536197142376517989250287598790633341464382798799) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.77344071865081787109375e0), SC_(-0.97659448586055620157617924635446593965742594980785) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.1992881298065185546875e1), SC_(-0.20809799037495579932186690745545983420313992822374) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.3915013790130615234375e1), SC_(0.39703968367637254438174957792930593034151463586959) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.79858455657958984375e1), SC_(-0.22554028330521586002605540735602991496631898015283) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.1571910858154296875e2), SC_(0.093633855470003473208809563463409739430069350910437) }}, 
      {{ SC_(-0.773610293865203857421875e0), SC_(0.31483119964599609375e2), SC_(-0.070461745595949681092731243985402876714254585230743) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.553809732082299888134002685546875e-4), SC_(3411563292.9669796968942111028927746747449026912013) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.69304020144045352935791015625e-4), SC_(2046598362.3380277794050000226232431427674677129183) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.23264062474481761455535888671875e-3), SC_(129630922.50446339331155017819677365672220689660444) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.4480001516640186309814453125e-3), SC_(29124927.143476381060749270075197015061256245381856) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.5502865533344447612762451171875e-3), SC_(18229319.979238976100645658531262040951818547006941) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.19227224402129650115966796875e-2), SC_(1053897.956929569185955175319621657818949265062221) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.37370622158050537109375e-2), SC_(231841.1058891395815352896585377817238414867631727) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.47696642577648162841796875e-2), SC_(132973.34058880932283158982294999835148475126525153) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.1275280676782131195068359375e-1), SC_(14143.154724499012452193671302600271852897387117945) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.20440109074115753173828125e-1), SC_(4827.0002138856521246867589597595652858439787350198) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.3429813683032989501953125e-1), SC_(1483.6553845873024913995747798876739824063717521137) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.96701286733150482177734375e-1), SC_(139.26739836871849880232137398143962623378368507862) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.159812271595001220703125e0), SC_(43.976463496518941763685458110029121972927739474599) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.297095477581024169921875e0), SC_(10.387458193796098091458741004438449603082306315889) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.77344071865081787109375e0), SC_(0.99240849019214068933320060350367869050615793023443) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.1992881298065185546875e1), SC_(0.38007621281164781816882276366718911085812475276781) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.3915013790130615234375e1), SC_(0.29403596953295701246022014094101894218001927703594) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.79858455657958984375e1), SC_(-0.01837951078983691561532112217348471277074821384291) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.1571910858154296875e2), SC_(0.19427115245753018672180398439230100630688488506532) }}, 
      {{ SC_(-0.1278498172760009765625e1), SC_(0.31483119964599609375e2), SC_(-0.13799728876142446935574975446216803968015474106104) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.553809732082299888134002685546875e-4), SC_(-1052534856334011.1715539380253442490393529354168594) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.69304020144045352935791015625e-4), SC_(-493567972016271.98593229233453766283237137175644106) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.23264062474481761455535888671875e-3), SC_(-8268281865770.6799723507075477047670236530702536031) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.4480001516640186309814453125e-3), SC_(-904509767542.57871242723570720295130551599003784941) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.5502865533344447612762451171875e-3), SC_(-451681172344.62275199563178724755053271724610716152) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.19227224402129650115966796875e-2), SC_(-6609106181.9315655323865091360718866593066117802884) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.37370622158050537109375e-2), SC_(-700748933.32738239550418059678170023119352690168661) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.47696642577648162841796875e-2), SC_(-307446225.29443781072879309174993795877958539308929) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.1275280676782131195068359375e-1), SC_(-11104382.334915614447662856663000022842550526037284) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.20440109074115753173828125e-1), SC_(-2257745.0631981596507978280357107785541246723841944) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.3429813683032989501953125e-1), SC_(-393215.54108344107745778732644950546167752024313407) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.96701286733150482177734375e-1), SC_(-11875.215377301361527607788678372426690815266675372) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.159812271595001220703125e0), SC_(-2178.2043791543280008244860279137202543771878307036) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.297095477581024169921875e0), SC_(-268.80841515377336154846614677034462642010213198625) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.77344071865081787109375e0), SC_(-10.653831565503460653054171073382042711333639447853) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.1992881298065185546875e1), SC_(-0.46405184762078718718459838928519754469724229927788) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.3915013790130615234375e1), SC_(-0.37388358442212335882627303155170282309105103172024) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.79858455657958984375e1), SC_(0.2605248427954328669351611971306267348449505723959) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.1571910858154296875e2), SC_(-0.0044288367831751747332630422754772844341893323667545) }}, 
      {{ SC_(-0.2376763820648193359375e1), SC_(0.31483119964599609375e2), SC_(-0.0034984374041546566085717607248133391319551924960149) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.553809732082299888134002685546875e-4), SC_(-51998884562397766833638082608780563.737710080783588) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.69304020144045352935791015625e-4), SC_(-10373958678561228310418298843892260.299325543471815) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.23264062474481761455535888671875e-3), SC_(-1721193673013960740632763534764.5228214424091055852) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.4480001516640186309814453125e-3), SC_(-15499334906533236567606620530.200191728031049025026) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.5502865533344447612762451171875e-3), SC_(-3535003298421510578639833490.1298202600643335995787) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.19227224402129650115966796875e-2), SC_(-439752257691660682841541.75551794749699979175321037) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.37370622158050537109375e-2), SC_(-3705011706337639112308.1152209359387228834835931875) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.47696642577648162841796875e-2), SC_(-641530904911065947149.99803989774066863308464555235) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.1275280676782131195068359375e-1), SC_(-546132673072666047.00762658792974245303347213408634) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.20440109074115753173828125e-1), SC_(-18396701945112916.384895654825593702168225876869444) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.3429813683032989501953125e-1), SC_(-445744577892577.55674541900235843479039451134156993) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.96701286733150482177734375e-1), SC_(-259210670573.87288769946854267773996879304687746878) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.159812271595001220703125e0), SC_(-7010082148.1406965960052632072139869221477975711535) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.297095477581024169921875e0), SC_(-81491453.188992740300521508908029235919983115000153) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.77344071865081787109375e0), SC_(-85445.976575401714336017146103914454068580259978837) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.1992881298065185546875e1), SC_(-105.85384695262030240377338945392033413256061144355) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.3915013790130615234375e1), SC_(-1.1183215030957860901241466804409166833411563137547) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.79858455657958984375e1), SC_(-0.15924647968524992013750712539382612404853915739277) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.1571910858154296875e2), SC_(-0.13646497651694413062087338033835273332177981957281) }}, 
      {{ SC_(-0.618752574920654296875e1), SC_(0.31483119964599609375e2), SC_(0.027827355903320065863025843071254167156921275283086) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.553809732082299888134002685546875e-4), SC_(8.4001523341827038432231402722998721443142330918029e+88) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.69304020144045352935791015625e-4), SC_(1.8796222553522528946620379625259071351108320901138e+87) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.23264062474481761455535888671875e-3), SC_(2.3081325916347882778073752606750486492668025854818e+78) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.4480001516640186309814453125e-3), SC_(3.478515150118406691595592053627769982231673500328e+73) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.5502865533344447612762451171875e-3), SC_(1.0670813727575964549272980712377341426694937581102e+72) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.19227224402129650115966796875e-2), SC_(6.6461334772063947653408668199451299578982343030567e+62) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.37370622158050537109375e-2), SC_(8.5619384530651836961194424228825518552684541970703e+57) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.47696642577648162841796875e-2), SC_(1.3719213377554659464306815751401633848492260535841e+56) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.1275280676782131195068359375e-1), SC_(7955158190212178420335468368124232663880717342110.2) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.20440109074115753173828125e-1), SC_(2687830185054672115670778035161362230550317234.9171) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.3429813683032989501953125e-1), SC_(417660847046267243923149265721102299918747.3327615) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.96701286733150482177734375e-1), SC_(9857412566370820437179391176824948.4480973116452753) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.159812271595001220703125e0), SC_(1982746222928083889201392122860.5529495215191051141) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.297095477581024169921875e0), SC_(54342658614656265715301011.291462576149999975040162) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.77344071865081787109375e0), SC_(4989069325897041578.9287143951601924931745358960062) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.1992881298065185546875e1), SC_(568820654109.75213716307392588957540692056153767208) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.3915013790130615234375e1), SC_(7228733.3457096840440213548757017280593929621744697) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.79858455657958984375e1), SC_(85.218410883780746589554552518759217135548634643101) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.1571910858154296875e2), SC_(0.083138583238802217337982342423668412467885504693672) }}, 
      {{ SC_(-0.15943050384521484375e2), SC_(0.31483119964599609375e2), SC_(0.026092609809789979593703213872413724681414333167314) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.553809732082299888134002685546875e-4), SC_(6.732265130331118411406210733134040868570474523393e+180) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.69304020144045352935791015625e-4), SC_(4.7890805105156653308354285280134561894764616686371e+177) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.23264062474481761455535888671875e-3), SC_(4.8109334124012977057393970639279785207684445563722e+160) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.4480001516640186309814453125e-3), SC_(3.049052750399900587178257099373852751425565819684e+151) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.5502865533344447612762451171875e-3), SC_(3.9594237279973587787148322093805851499714508240285e+148) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.19227224402129650115966796875e-2), SC_(1.0894842839824276085850763917542395186000660442094e+131) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.37370622158050537109375e-2), SC_(5.1190963995973892592278162982935522403814915185721e+121) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.47696642577648162841796875e-2), SC_(1.9259093785260067277950959762634816738979484178694e+118) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.1275280676782131195068359375e-1), SC_(3.0209004816077561502611340316195266897611051320687e+104) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.20440109074115753173828125e-1), SC_(7.2189850508763419944174046157635499799131383398434e+97) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.3429813683032989501953125e-1), SC_(3.9203759513806755842698539491059510914538050043793e+90) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.96701286733150482177734375e-1), SC_(1.1068238961489066737178853560695046742443653655441e+76) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.159812271595001220703125e0), SC_(9.8310501753961151205121686731703916211875717169597e+68) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.297095477581024169921875e0), SC_(1.9474201739442400194932589993162245643234473214871e+60) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.77344071865081787109375e0), SC_(72637648749801605640594500299031420664728634405.057) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.1992881298065185546875e1), SC_(3865026197564005029397831991829306.6380852182772186) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.3915013790130615234375e1), SC_(1404011109550035690853366.2231718837052560358837621) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.79858455657958984375e1), SC_(201998574478312.5859314533387877544464625179036473) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.1571910858154296875e2), SC_(273866.85062463153642269420825285461481145130239201) }}, 
      {{ SC_(-0.31320110321044921875e2), SC_(0.31483119964599609375e2), SC_(0.040177706317001652135569144163854139601049432365744) }}, 
#if LDBL_MAX_10_EXP > 370
      {{ SC_(-0.638867645263671875e2), SC_(0.553809732082299888134002685546875e-4), SC_(2.3698927678173738831066761972137110281877681762679e+383) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.69304020144045352935791015625e-4), SC_(1.1347435085188848198271269654218346241788725670797e+377) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.23264062474481761455535888671875e-3), SC_(8.4954816338456215028286500709836088758658594626306e+342) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.4480001516640186309814453125e-3), SC_(2.9033181046257357700429477801583184943123438667291e+324) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.5502865533344447612762451171875e-3), SC_(4.6538211817343001183895076979754694438753107525127e+318) }}, 
#endif
      {{ SC_(-0.638867645263671875e2), SC_(0.19227224402129650115966796875e-2), SC_(2.5884127570342517807802184680833064189350946360272e+283) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.37370622158050537109375e-2), SC_(4.8508986987836801234656433955696736929307399214621e+264) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.47696642577648162841796875e-2), SC_(6.4652313804985336441271270491093075957693244755895e+257) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.1275280676782131195068359375e-1), SC_(1.2481913994843204247151724194175209513818899114211e+230) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.20440109074115753173828125e-1), SC_(6.3452402812155401507978956824225465373086743151221e+216) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.3429813683032989501953125e-1), SC_(1.6471284344367667896225149421358528479494425365156e+202) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.96701286733150482177734375e-1), SC_(1.0167245949532858220681726036512131689235250729876e+173) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.159812271595001220703125e0), SC_(7.0855606144842314101921479749180352596328021493921e+158) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.297095477581024169921875e0), SC_(2.3844448492985196529635784175504063632397857898622e+141) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.77344071865081787109375e0), SC_(2.6048251069659582851724058248351336224666813212987e+114) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.1992881298065185546875e1), SC_(5.6160513564930999055692078692461392613591823835801e+87) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.3915013790130615234375e1), SC_(5.498812871670615045881011453415585469720132723112e+68) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.79858455657958984375e1), SC_(5411799740662393319191711873139592736080843868560.4) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.1571910858154296875e2), SC_(910129039949789177025388333870.53660912834462595725) }}, 
      {{ SC_(-0.638867645263671875e2), SC_(0.31483119964599609375e2), SC_(477742493665.49170927134873191131936373256371654668) }},
   }};
